/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AffectedVersionsSystemField;
import com.atlassian.jira.issue.fields.AggregateEstimateSystemField;
import com.atlassian.jira.issue.fields.AggregateOriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.AggregateProgressBarSystemField;
import com.atlassian.jira.issue.fields.AggregateTimeSpentSystemField;
import com.atlassian.jira.issue.fields.AssigneeSystemField;
import com.atlassian.jira.issue.fields.AttachmentSystemField;
import com.atlassian.jira.issue.fields.CommentSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CreatedSystemField;
import com.atlassian.jira.issue.fields.CreatorSystemField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.DescriptionSystemField;
import com.atlassian.jira.issue.fields.DueDateSystemField;
import com.atlassian.jira.issue.fields.EnvironmentSystemField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.FixVersionsSystemField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.KeySystemField;
import com.atlassian.jira.issue.fields.LabelsSystemField;
import com.atlassian.jira.issue.fields.LastViewedSystemField;
import com.atlassian.jira.issue.fields.MandatoryField;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.OriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.PrioritySystemField;
import com.atlassian.jira.issue.fields.ProgressBarSystemField;
import com.atlassian.jira.issue.fields.ProjectField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.ReporterSystemField;
import com.atlassian.jira.issue.fields.RequirableField;
import com.atlassian.jira.issue.fields.ResolutionDateSystemField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.fields.StatusSystemField;
import com.atlassian.jira.issue.fields.SubTaskSystemField;
import com.atlassian.jira.issue.fields.SummarySystemField;
import com.atlassian.jira.issue.fields.ThumbnailSystemField;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.fields.TimeSpentSystemField;
import com.atlassian.jira.issue.fields.TimeTrackingSystemField;
import com.atlassian.jira.issue.fields.UnscreenableField;
import com.atlassian.jira.issue.fields.UpdatedSystemField;
import com.atlassian.jira.issue.fields.VotesSystemField;
import com.atlassian.jira.issue.fields.WatchesSystemField;
import com.atlassian.jira.issue.fields.WorkRatioSystemField;
import com.atlassian.jira.issue.fields.WorklogSystemField;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.RenderableField;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultFieldManager
implements FieldManager {
    private static final Logger log = Logger.getLogger(DefaultFieldManager.class);
    private FieldLayoutManager fieldLayoutManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, Field> fields;
    private List<OrderableField> orderableFields;
    private List<NavigableField> navigableFields;
    private ProjectSystemField projectSystemField;

    public DefaultFieldManager(FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.init();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try {
            if (this.lock.writeLock().tryLock() || this.lock.writeLock().tryLock(10L, TimeUnit.MINUTES)) {
                ImmutableMap.Builder fieldsBuilder = ImmutableMap.builder();
                ImmutableList.Builder orderableFieldsBuilder = ImmutableList.builder();
                ImmutableList.Builder navigableFieldsBuilder = ImmutableList.builder();
                this.projectSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, ProjectSystemField.class);
                navigableFieldsBuilder.add((Object)this.projectSystemField);
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, KeySystemField.class));
                SummarySystemField summarySystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, SummarySystemField.class);
                orderableFieldsBuilder.add((Object)summarySystemField);
                navigableFieldsBuilder.add((Object)summarySystemField);
                IssueTypeSystemField issueTypeSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, IssueTypeSystemField.class);
                orderableFieldsBuilder.add((Object)issueTypeSystemField);
                navigableFieldsBuilder.add((Object)issueTypeSystemField);
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, StatusSystemField.class));
                PrioritySystemField prioritySystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, PrioritySystemField.class);
                orderableFieldsBuilder.add((Object)prioritySystemField);
                navigableFieldsBuilder.add((Object)prioritySystemField);
                ResolutionSystemField resolutionSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, ResolutionSystemField.class);
                orderableFieldsBuilder.add((Object)resolutionSystemField);
                navigableFieldsBuilder.add((Object)resolutionSystemField);
                AssigneeSystemField assigneeSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, AssigneeSystemField.class);
                orderableFieldsBuilder.add((Object)assigneeSystemField);
                navigableFieldsBuilder.add((Object)assigneeSystemField);
                ReporterSystemField reporterSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, ReporterSystemField.class);
                orderableFieldsBuilder.add((Object)reporterSystemField);
                navigableFieldsBuilder.add((Object)reporterSystemField);
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, CreatorSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, CreatedSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, LastViewedSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, UpdatedSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, ResolutionDateSystemField.class));
                AffectedVersionsSystemField affectedVersionsSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, AffectedVersionsSystemField.class);
                orderableFieldsBuilder.add((Object)affectedVersionsSystemField);
                navigableFieldsBuilder.add((Object)affectedVersionsSystemField);
                FixVersionsSystemField fixVersionsSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, FixVersionsSystemField.class);
                orderableFieldsBuilder.add((Object)fixVersionsSystemField);
                navigableFieldsBuilder.add((Object)fixVersionsSystemField);
                ComponentsSystemField componentsSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, ComponentsSystemField.class);
                orderableFieldsBuilder.add((Object)componentsSystemField);
                navigableFieldsBuilder.add((Object)componentsSystemField);
                DueDateSystemField dueDateSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, DueDateSystemField.class);
                orderableFieldsBuilder.add((Object)dueDateSystemField);
                navigableFieldsBuilder.add((Object)dueDateSystemField);
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, VotesSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, WatchesSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, ThumbnailSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, OriginalEstimateSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, TimeEstimateSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, TimeSpentSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, WorkRatioSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, SubTaskSystemField.class));
                IssueLinksSystemField issueLinksSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, IssueLinksSystemField.class);
                orderableFieldsBuilder.add((Object)issueLinksSystemField);
                navigableFieldsBuilder.add((Object)issueLinksSystemField);
                orderableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, AttachmentSystemField.class));
                EnvironmentSystemField environmentSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, EnvironmentSystemField.class);
                orderableFieldsBuilder.add((Object)environmentSystemField);
                navigableFieldsBuilder.add((Object)environmentSystemField);
                DescriptionSystemField descriptionSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, DescriptionSystemField.class);
                orderableFieldsBuilder.add((Object)descriptionSystemField);
                navigableFieldsBuilder.add((Object)descriptionSystemField);
                orderableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, TimeTrackingSystemField.class));
                SecurityLevelSystemField securityLevelSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, SecurityLevelSystemField.class);
                orderableFieldsBuilder.add((Object)securityLevelSystemField);
                navigableFieldsBuilder.add((Object)securityLevelSystemField);
                orderableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, CommentSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, ProgressBarSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, AggregateProgressBarSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, AggregateTimeSpentSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, AggregateEstimateSystemField.class));
                navigableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, AggregateOriginalEstimateSystemField.class));
                LabelsSystemField labelsSystemField = this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, LabelsSystemField.class);
                orderableFieldsBuilder.add((Object)labelsSystemField);
                navigableFieldsBuilder.add((Object)labelsSystemField);
                orderableFieldsBuilder.add((Object)this.createAndRegister((ImmutableMap.Builder<String, Field>)fieldsBuilder, WorklogSystemField.class));
                this.fields = fieldsBuilder.build();
                this.orderableFields = orderableFieldsBuilder.build();
                this.navigableFields = navigableFieldsBuilder.build();
            } else {
                log.error((Object)("Unable to acquire the write lock for refreshing the contents of this field manager. Current read lock count (may be already obsolete): " + this.lock.getReadHoldCount()));
            }
        }
        catch (InterruptedException interruptedException) {
            log.warn((Object)"Waiting for write lock was interrupted.", (Throwable)interruptedException);
        }
        finally {
            if (this.lock.writeLock().isHeldByCurrentThread()) {
                this.lock.writeLock().unlock();
            }
        }
    }

    private <T extends Field> T createAndRegister(ImmutableMap.Builder<String, Field> fields, Class<T> clazz) {
        Field field = (Field)JiraUtils.loadComponent(clazz);
        fields.put((Object)field.getId(), (Object)field);
        return (T)field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Field getField(String id) {
        try {
            this.lock.readLock().lock();
            if (this.isCustomField(id)) {
                CustomField customField = this.getCustomField(id);
                return customField;
            }
            Field field = this.fields.get(id);
            return field;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<NavigableField> getAllAvailableNavigableFields() throws FieldException {
        try {
            this.lock.readLock().lock();
            Set<NavigableField> allAvailableFields = this.getAvailableNavigableFields();
            Set<FieldLayout> uniqueSchemes = this.getAllFieldLayouts();
            Set<NavigableField> set = this.getAvailableFields(allAvailableFields, uniqueSchemes);
            return set;
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            log.error((Object)"Error retrieving field layout.", (Throwable)e);
            throw new FieldException("Error retrieving field layout.", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<NavigableField> getAvailableNavigableFields(User remoteUser) throws FieldException {
        HashSet<NavigableField> availableFields = new HashSet<NavigableField>();
        try {
            this.lock.readLock().lock();
            Set<FieldLayout> uniqueSchemes = this.getUniqueSchemes(Collections.<Long>emptyList(), Collections.<String>emptyList(), remoteUser);
            HashSet<String> browsableProjects = DefaultFieldManager.getBrowsableProjectKeys(remoteUser);
            Set<NavigableField> allAvailableFields = this.getAvailableNavigableFields();
            for (NavigableField field : allAvailableFields) {
                if (this.isFieldHidden(uniqueSchemes, (Field)field)) continue;
                if (this.isCustomField((Field)field)) {
                    CustomField customField = this.getCustomField(field.getId());
                    if (!DefaultFieldManager.userHasPermissionToCustomFieldProjects(customField, browsableProjects)) continue;
                    availableFields.add(field);
                    continue;
                }
                availableFields.add(field);
            }
            HashSet<NavigableField> hashSet = availableFields;
            return hashSet;
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            log.error((Object)"Error retrieving field layout.", (Throwable)e);
            throw new FieldException("Error retrieving field layout.", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static boolean userHasPermissionToCustomFieldProjects(CustomField customField, HashSet<String> browsableProjects) {
        if (customField.isAllProjects()) {
            return true;
        }
        List projects = customField.getAssociatedProjects();
        if (projects == null) {
            return false;
        }
        for (GenericValue project : projects) {
            if (!browsableProjects.contains(project.getString("key"))) continue;
            return true;
        }
        return false;
    }

    private static HashSet<String> getBrowsableProjectKeys(User remoteUser) {
        Collection<Project> browsableProjectObjects = DefaultFieldManager.getBrowsableProjectObjects(remoteUser);
        HashSet<String> browsableProjectKeys = new HashSet<String>(browsableProjectObjects.size());
        for (Project project : browsableProjectObjects) {
            browsableProjectKeys.add(project.getKey());
        }
        return browsableProjectKeys;
    }

    public Set<SearchableField> getAllSearchableFields() {
        LinkedHashSet<SearchableField> allFields = new LinkedHashSet<SearchableField>();
        this.addAllSystemSearchableFields(allFields);
        allFields.addAll(DefaultFieldManager.getCustomFieldManager().getCustomFieldObjects());
        return allFields;
    }

    public Set<SearchableField> getSystemSearchableFields() {
        LinkedHashSet<SearchableField> allFields = new LinkedHashSet<SearchableField>();
        this.addAllSystemSearchableFields(allFields);
        return allFields;
    }

    public IssueTypeField getIssueTypeField() {
        return (IssueTypeField)this.getField("issuetype");
    }

    public ProjectField getProjectField() {
        return (ProjectField)this.getField("project");
    }

    public Set<NavigableField> getAvailableNavigableFieldsWithScope(User user) throws FieldException {
        return this.getAvailableNavigableFieldsWithScope(user, Collections.<Long>emptyList(), Collections.<String>emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NavigableField> getAvailableNavigableFieldsWithScope(User remoteUser, QueryContext queryContext) throws FieldException {
        try {
            this.lock.readLock().lock();
            LinkedHashSet<NavigableField> allFields = new LinkedHashSet<NavigableField>();
            for (QueryContext.ProjectIssueTypeContexts context : queryContext.getProjectIssueTypeContexts()) {
                Set<NavigableField> availableFields = this.getAvailableNavigableFieldsWithScope(remoteUser, context.getProjectIdInList(), context.getIssueTypeIds());
                allFields.addAll(availableFields);
            }
            LinkedHashSet<NavigableField> linkedHashSet = allFields;
            return linkedHashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Set<NavigableField> getAvailableNavigableFieldsWithScope(User remoteUser, List<Long> projectIds, List<String> issueTypes) throws FieldException {
        LinkedHashSet<NavigableField> availableFields = new LinkedHashSet<NavigableField>();
        try {
            this.lock.readLock().lock();
            Set<FieldLayout> schemes = this.getUniqueSchemes(projectIds, issueTypes, remoteUser);
            LinkedHashSet<NavigableField> allAvailableFields = new LinkedHashSet<NavigableField>();
            allAvailableFields.addAll(this.navigableFields);
            allAvailableFields.removeAll(this.getUnavailableFields());
            availableFields.addAll(this.getAvailableFields(allAvailableFields, schemes));
            availableFields.addAll(this.getAvailableCustomFieldsWithScope(remoteUser, projectIds, issueTypes));
            LinkedHashSet<NavigableField> linkedHashSet = availableFields;
            return linkedHashSet;
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout.";
            log.error((Object)"Error retrieving field layout.", (Throwable)e);
            throw new FieldException("Error retrieving field layout.", (Throwable)e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends Field> Set<F> getAvailableFields(Collection<F> fieldsToCheck, Set<FieldLayout> schemes) {
        LinkedHashSet<Field> availableFields = new LinkedHashSet<Field>();
        try {
            this.lock.readLock().lock();
            for (Field field : fieldsToCheck) {
                if (this.isFieldHidden(schemes, field)) continue;
                availableFields.add(field);
            }
            LinkedHashSet<Field> linkedHashSet = availableFields;
            return linkedHashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<CustomField> getAvailableCustomFields(User remoteUser, Issue issue) throws FieldException {
        Project project = issue.getProjectObject();
        List projectList = project == null ? Collections.emptyList() : CollectionBuilder.list((Object[])new Long[]{project.getId()});
        return this.getAvailableCustomFieldsWithScope(remoteUser, projectList, CollectionBuilder.list((Object[])new String[]{issue.getIssueTypeObject().getId()}));
    }

    private Set<CustomField> getAvailableCustomFieldsWithScope(User remoteUser, List<Long> projectIds, List<String> issueTypes) throws FieldException {
        try {
            Set<FieldLayout> schemes = this.getUniqueSchemes(projectIds, issueTypes, remoteUser);
            Collection existingCustomFields = new HashSet();
            for (Long projectId : projectIds) {
                List existingCustomFieldsForProject = DefaultFieldManager.getCustomFieldManager().getCustomFieldObjects(projectId, issueTypes);
                if (existingCustomFieldsForProject == null) continue;
                existingCustomFields.addAll(existingCustomFieldsForProject);
            }
            if (projectIds.isEmpty()) {
                existingCustomFields = DefaultFieldManager.getCustomFieldManager().getCustomFieldObjects(null, issueTypes);
            }
            return this.getAvailableFields(existingCustomFields, schemes);
        }
        catch (DataAccessException e) {
            String message = "Error retrieving field layout for " + (projectIds != null && !projectIds.isEmpty() ? "projects '" + projectIds + "'." : "null project.");
            log.error((Object)message, (Throwable)e);
            throw new FieldException(message, (Throwable)e);
        }
    }

    private Set<FieldLayout> getUniqueSchemes(List<Long> projectIds, List<String> issueTypes, User remoteUser) {
        if (projectIds.isEmpty() && issueTypes.isEmpty()) {
            Collection<Project> projects = DefaultFieldManager.getBrowsableProjectObjects(remoteUser);
            HashSet<FieldLayout> fieldLayoutSet = new HashSet<FieldLayout>();
            for (Project project : projects) {
                fieldLayoutSet.addAll(this.getFieldLayoutManager().getUniqueFieldLayouts(project));
            }
            return fieldLayoutSet;
        }
        if (projectIds.isEmpty() && !issueTypes.isEmpty()) {
            return this.findVisibleFieldLayouts(DefaultFieldManager.getBrowsableProjectObjects(remoteUser), issueTypes);
        }
        if (!projectIds.isEmpty() && issueTypes.isEmpty()) {
            return this.getVisibleFieldLayouts(ComponentAccessor.getProjectManager().convertToProjects(projectIds), DefaultFieldManager.getAllIssueTypes());
        }
        return this.getVisibleFieldLayouts(ComponentAccessor.getProjectManager().convertToProjects(projectIds), issueTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFieldHidden(User remoteUser, String fieldId) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.isFieldHidden(remoteUser, this.getField(fieldId));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isFieldHidden(User remoteUser, Field field) {
        Set<FieldLayout> visibleFieldLayouts = this.getVisibleFieldLayouts(remoteUser);
        return this.isFieldHidden(visibleFieldLayouts, field);
    }

    public Set<FieldLayout> getVisibleFieldLayouts(User user) {
        return this.getUniqueSchemes(Collections.<Long>emptyList(), Collections.<String>emptyList(), user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFieldHidden(Set<FieldLayout> fieldLayouts, Field field) {
        try {
            this.lock.readLock().lock();
            if (!this.isOrderableField(field)) {
                boolean bl = false;
                return bl;
            }
            OrderableField orderableField = this.getOrderableField(field.getId());
            for (FieldLayout fieldLayout : fieldLayouts) {
                FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(orderableField);
                if (fieldLayoutItem.isHidden()) continue;
                boolean bl = fieldLayoutItem.isHidden();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Set<FieldLayout> getAllFieldLayouts() {
        return this.getVisibleFieldLayouts(ComponentAccessor.getProjectManager().getProjects(), DefaultFieldManager.getAllIssueTypes());
    }

    private static List<String> getAllIssueTypes() {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        return constantsManager.expandIssueTypeIds((Collection)EasyList.build((Object)"-4"));
    }

    private static Collection<Project> getBrowsableProjectObjects(User remoteUser) {
        return ComponentAccessor.getPermissionManager().getProjectObjects(10, remoteUser);
    }

    private Set<FieldLayout> findVisibleFieldLayouts(Collection<Project> projects, List<String> issueTypes) {
        HashSet<FieldLayout> uniqueSchemes = new HashSet<FieldLayout>();
        for (Project project : projects) {
            for (String issueTypeId : issueTypes) {
                FieldLayout fieldLayout = this.getFieldLayoutManager().getFieldLayout(project, issueTypeId);
                uniqueSchemes.add(fieldLayout);
            }
        }
        return uniqueSchemes;
    }

    private Set<FieldLayout> getVisibleFieldLayouts(Collection<GenericValue> projects, List<String> issueTypes) {
        HashSet<FieldLayout> uniqueSchemes = new HashSet<FieldLayout>();
        for (GenericValue project : projects) {
            for (String issueTypeId : issueTypes) {
                FieldLayout fieldLayout = this.getFieldLayoutManager().getFieldLayout(project, issueTypeId);
                uniqueSchemes.add(fieldLayout);
            }
        }
        return uniqueSchemes;
    }

    public boolean isCustomField(String key) {
        return DefaultFieldManager.getCustomFieldManager().exists(key);
    }

    public boolean isCustomField(Field field) {
        return field instanceof CustomField;
    }

    public CustomField getCustomField(String key) {
        CustomField customFieldObject = DefaultFieldManager.getCustomFieldManager().getCustomFieldObject(key);
        if (customFieldObject == null) {
            throw new IllegalArgumentException("Custom field with id '" + key + "' does not exist.");
        }
        return customFieldObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHideableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        try {
            this.lock.readLock().lock();
            Field field = this.fields.get(id);
            boolean bl = this.isHideableField(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isHideableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        return field instanceof HideableField;
    }

    public HideableField getHideableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        try {
            this.lock.readLock().lock();
            if (this.isHideableField(id)) {
                HideableField hideableField = (HideableField)this.fields.get(id);
                return hideableField;
            }
            throw new IllegalArgumentException("The field with id '" + id + "' is not a HideableField.");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOrderableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        try {
            this.lock.readLock().lock();
            Field field = this.fields.get(id);
            boolean bl = this.isOrderableField(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOrderableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        try {
            this.lock.readLock().lock();
            boolean bl = field instanceof OrderableField && this.orderableFields.contains(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderableField getOrderableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        try {
            this.lock.readLock().lock();
            if (this.isOrderableField(id)) {
                OrderableField orderableField = (OrderableField)this.fields.get(id);
                return orderableField;
            }
            OrderableField orderableField = null;
            return orderableField;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ConfigurableField getConfigurableField(String id) {
        OrderableField field = this.getOrderableField(id);
        if (field != null && field instanceof ConfigurableField) {
            return (ConfigurableField)field;
        }
        if (log.isInfoEnabled() && field != null) {
            log.info((Object)("Field found for " + id + " but was not a ConfigurableField. Type is " + field.getClass().getName() + " : " + field));
        }
        return null;
    }

    public Set<OrderableField> getOrderableFields() {
        return Collections.unmodifiableSet(this.getAvailableOrderableFields());
    }

    public Set<NavigableField> getNavigableFields() {
        return Collections.unmodifiableSet(this.getAvailableNavigableFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNavigableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        try {
            this.lock.readLock().lock();
            Field field = this.fields.get(id);
            boolean bl = this.isNavigableField(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNavigableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        try {
            this.lock.readLock().lock();
            boolean bl = field instanceof NavigableField && this.navigableFields.contains(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public NavigableField getNavigableField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        try {
            this.lock.readLock().lock();
            if (this.isNavigableField(id)) {
                NavigableField navigableField = (NavigableField)this.fields.get(id);
                return navigableField;
            }
            throw new IllegalArgumentException("The field with id '" + id + "' is not a NavigableField.");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequirableField(String id) {
        if (this.isCustomField(id)) {
            return true;
        }
        try {
            this.lock.readLock().lock();
            boolean bl = this.isRequirableField(this.fields.get(id));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isRequirableField(Field field) {
        if (this.isCustomField(field)) {
            return true;
        }
        return field instanceof RequirableField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMandatoryField(String id) {
        if (this.isCustomField(id)) {
            return false;
        }
        try {
            this.lock.readLock().lock();
            Field field = this.fields.get(id);
            boolean bl = this.isMandatoryField(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isMandatoryField(Field field) {
        if (this.isCustomField(field)) {
            return false;
        }
        return field instanceof MandatoryField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRenderableField(String id) {
        if (this.isCustomField(id)) {
            CustomField field = this.getCustomField(id);
            return field.isRenderable();
        }
        try {
            this.lock.readLock().lock();
            Field field = this.fields.get(id);
            boolean bl = this.isRenderableField(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isRenderableField(Field field) {
        if (this.isCustomField(field)) {
            return ((CustomField)field).isRenderable();
        }
        return field instanceof RenderableField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnscreenableField(String id) {
        if (this.isCustomField(id)) {
            return false;
        }
        try {
            this.lock.readLock().lock();
            Field field = this.fields.get(id);
            boolean bl = this.isUnscreenableField(field);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isUnscreenableField(Field field) {
        if (this.isCustomField(field)) {
            return false;
        }
        return field instanceof UnscreenableField;
    }

    public RequirableField getRequiredField(String id) {
        if (this.isCustomField(id)) {
            return this.getCustomField(id);
        }
        try {
            this.lock.readLock().lock();
            if (this.isRequirableField(id)) {
                RequirableField requirableField = (RequirableField)this.fields.get(id);
                return requirableField;
            }
            throw new IllegalArgumentException("The field with id '" + id + "' is not a RequirableField.");
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static CustomFieldManager getCustomFieldManager() {
        return ComponentAccessor.getCustomFieldManager();
    }

    @Deprecated
    public FieldLayoutManager getFieldLayoutManager() {
        if (this.fieldLayoutManager == null) {
            this.fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        }
        return this.fieldLayoutManager;
    }

    @Deprecated
    public ColumnLayoutManager getColumnLayoutManager() {
        return ComponentAccessor.getColumnLayoutManager();
    }

    public void refresh() {
        this.refreshSearchersAndIndexers();
        this.getFieldLayoutManager().refresh();
        this.getColumnLayoutManager().refresh();
    }

    public boolean isTimeTrackingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.timetracking");
    }

    private static boolean isVotingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.voting");
    }

    private static boolean isWatchingOn() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.watching");
    }

    private static boolean isSubTasksOn() {
        return ComponentAccessor.getSubTaskManager().isSubTasksEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NavigableField> getAvailableNavigableFields() {
        try {
            this.lock.readLock().lock();
            Set set = this.getAvailableFields(this.navigableFields);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<OrderableField> getAvailableOrderableFields() {
        try {
            this.lock.readLock().lock();
            Set set = this.getAvailableFields(this.orderableFields);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Set getAvailableFields(List<? extends Field> allFields) {
        HashSet<? extends Field> availableFields = new HashSet<Field>(allFields);
        availableFields.addAll(DefaultFieldManager.getCustomFieldManager().getCustomFieldObjects());
        availableFields.removeAll(this.getUnavailableFields());
        return availableFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Field> getUnavailableFields() {
        try {
            this.lock.readLock().lock();
            HashSet<Field> unavailableFields = new HashSet<Field>();
            if (!this.isTimeTrackingOn()) {
                unavailableFields.add(this.fields.get("timetracking"));
                unavailableFields.add(this.fields.get("timeoriginalestimate"));
                unavailableFields.add(this.fields.get("timeestimate"));
                unavailableFields.add(this.fields.get("timespent"));
                unavailableFields.add(this.fields.get("progress"));
                unavailableFields.add(this.fields.get("worklog"));
            }
            if (!DefaultFieldManager.isSubTasksOn() || !this.isTimeTrackingOn()) {
                unavailableFields.add(this.fields.get("aggregatetimespent"));
                unavailableFields.add(this.fields.get("aggregatetimeoriginalestimate"));
                unavailableFields.add(this.fields.get("aggregatetimeestimate"));
                unavailableFields.add(this.fields.get("aggregateprogress"));
            }
            if (!DefaultFieldManager.isVotingOn()) {
                unavailableFields.add(this.fields.get("votes"));
            }
            if (!DefaultFieldManager.isWatchingOn()) {
                unavailableFields.add(this.fields.get("watches"));
            }
            if (!DefaultFieldManager.isSubTasksOn()) {
                unavailableFields.add(this.fields.get("subtasks"));
            }
            HashSet<Field> hashSet = unavailableFields;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllSystemSearchableFields(Set<SearchableField> searchableFields) {
        try {
            this.lock.readLock().lock();
            searchableFields.add((SearchableField)this.projectSystemField);
            CollectionUtils.select(this.orderableFields, (Predicate)InstanceofPredicate.getInstance(SearchableField.class), searchableFields);
            CollectionUtils.select(this.navigableFields, (Predicate)InstanceofPredicate.getInstance(SearchableField.class), searchableFields);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private synchronized void refreshSearchersAndIndexers() {
        this.fieldConfigSchemeManager.init();
        IssueSearcherManager issueSearcherManager = (IssueSearcherManager)ComponentAccessor.getComponentOfType(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponentOfType(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }
}

