/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.core.util.FileSize;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.AttachmentFileNameCreationDateComparator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableField;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentRenderedJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.util.AttachmentException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.action.Action;
import webwork.config.Configuration;

public class AttachmentSystemField
extends AbstractOrderableField
implements HideableField,
RestAwareField {
    private static final Logger log = Logger.getLogger(AttachmentSystemField.class);
    public static final String FILETOCONVERT = "filetoconvert";
    private final AttachmentManager attachmentManager;
    private final PermissionManager permissionManager;
    private final TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator;
    private final JiraBaseUrls jiraBaseUrls;
    private final ThumbnailManager thumbnailManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public AttachmentSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, AttachmentManager attachmentManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator, JiraBaseUrls jiraBaseUrls, ThumbnailManager thumbnailManager, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super("attachment", "issue.field.attachment", templatingEngine, applicationProperties, authenticationContext, permissionManager, null);
        this.attachmentManager = attachmentManager;
        this.permissionManager = permissionManager;
        this.temporaryAttachmentsMonitorLocator = temporaryAttachmentsMonitorLocator;
        this.jiraBaseUrls = jiraBaseUrls;
        this.thumbnailManager = thumbnailManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        Long maxSizeRaw = Long.valueOf(Configuration.getString((String)"webwork.multipart.maxSize"));
        velocityParams.put("maxSizeRaw", maxSizeRaw);
        velocityParams.put("maxSize", FileSize.format((Long)maxSizeRaw));
        TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(true);
        Collection tempFiles = temporaryAttachmentsMonitor.getByIssueId(issue.getId());
        Object checkedFiles = operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put("tempFiles", tempFiles);
        if (checkedFiles != null) {
            ImmutableList tempFileIds = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((List)tempFiles), (Function)new Function<TemporaryAttachment, Long>(){

                public Long apply(TemporaryAttachment attachment) {
                    return attachment.getId();
                }
            }));
            ((List)checkedFiles).addAll(tempFileIds);
            velocityParams.put("checkedFiles", checkedFiles);
        } else {
            temporaryAttachmentsMonitor.clearEntriesForIssue(issue.getId());
        }
        return this.renderTemplate("attachment-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        return "bulk.edit.unavailable";
    }

    public boolean isShown(Issue issue) {
        boolean hasCreateAttachmentPermission = issue.isCreated() ? this.permissionManager.hasPermission(19, issue, this.getAuthenticationContext().getUser()) : this.permissionManager.hasPermission(19, issue.getProjectObject(), this.getAuthenticationContext().getUser(), true);
        return hasCreateAttachmentPermission && this.attachmentManager.attachmentsEnabled();
    }

    public void populateDefaults(Map<String, Object> fieldValuesHolder, Issue issue) {
    }

    public void populateFromIssue(Map<String, Object> fieldValuesHolder, Issue issue) {
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        List tempAttachmentIds = (List)fieldValuesHolder.get(this.getId());
        if (tempAttachmentIds == null || tempAttachmentIds.isEmpty()) {
            return;
        }
        for (Long tempAttachmentId : tempAttachmentIds) {
            TemporaryAttachment temporaryAttachment = this.getTemporaryAttachment(tempAttachmentId);
            if (temporaryAttachment != null && temporaryAttachment.getFile().exists()) continue;
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("attachment.temporary.id.session.time.out"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void createValue(Issue issue, Object value) {
        this.addAttachment(issue, (List)value);
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        issueChangeHolder.addChangeItems(this.addAttachment(issue, (List)modifiedValue.getNewValue()));
    }

    private List<ChangeItemBean> addAttachment(Issue issue, List<Long> tempAttachmentIds) {
        if (tempAttachmentIds == null || tempAttachmentIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(false);
            if (temporaryAttachmentsMonitor != null) {
                return this.attachmentManager.convertTemporaryAttachments(this.getAuthenticationContext().getLoggedInUser(), issue, tempAttachmentIds, temporaryAttachmentsMonitor);
            }
            log.error((Object)"Session timed out or cleared since validation happened.  No temporary attachments could be converted to attachments!");
        }
        catch (AttachmentException e) {
            log.error((Object)"Error occurred while creating attachment.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            issue.setExternalFieldValue(this.getId(), fieldValueHolder.get(this.getId()));
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        return new MessagedResult(false);
    }

    public void populateForMove(Map<String, Object> fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return false;
    }

    public boolean hasValue(Issue issue) {
        return false;
    }

    public Object getValueFromParams(Map params) throws FieldValidationException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void populateParamsFromString(Map<String, Object> fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public List<IssueSearcher<?>> getAssociatedSearchers() {
        return Collections.emptyList();
    }

    @Override
    protected Object getRelevantParams(Map<String, String[]> params) {
        ArrayList<Long> temporaryAttachmentIds = new ArrayList<Long>();
        if (params.containsKey(FILETOCONVERT)) {
            String[] idStrings;
            for (String idString : idStrings = params.get(FILETOCONVERT)) {
                temporaryAttachmentIds.add(Long.parseLong(idString));
            }
        }
        return temporaryAttachmentIds;
    }

    private TemporaryAttachment getTemporaryAttachment(Long temporaryAttachmentId) {
        TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(false);
        if (temporaryAttachmentsMonitor != null) {
            return temporaryAttachmentsMonitor.getById(temporaryAttachmentId);
        }
        return null;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.systemArray((String)"attachment", (String)this.getId());
    }

    public FieldJsonRepresentation getJsonFromIssue(Issue issue, boolean renderedVersionRequired, FieldLayoutItem fieldLayoutItem) {
        List comments = this.attachmentManager.getAttachments(issue, (Comparator)new AttachmentFileNameCreationDateComparator(this.getAuthenticationContext().getLocale()));
        FieldJsonRepresentation fieldJsonRepresentation = new FieldJsonRepresentation(new JsonData((Object)AttachmentJsonBean.shortBeans((Collection)comments, (JiraBaseUrls)this.jiraBaseUrls, (ThumbnailManager)this.thumbnailManager)));
        if (renderedVersionRequired) {
            fieldJsonRepresentation.setRenderedData(new JsonData((Object)AttachmentRenderedJsonBean.shortBeans((Collection)comments, (JiraBaseUrls)this.jiraBaseUrls, (ThumbnailManager)this.thumbnailManager, (DateTimeFormatterFactory)this.dateTimeFormatterFactory)));
        }
        return fieldJsonRepresentation;
    }
}

