/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.issue.search.QueryContextConverter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.DefaultCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldContextValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CascadingSelectCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.statistics.CascadingSelectStatisticsMapper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.CascadingSelectCustomFieldIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.context.CascadingSelectCustomFieldClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.CascadingSelectCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.ValidatingDecoratorQueryFactory;
import com.atlassian.jira.jql.util.JqlCascadingSelectLiteralUtil;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.jql.validator.CascadingSelectCustomFieldValidator;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.CustomFieldOptionsClauseValuesGenerator;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class CascadingSelectSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
CustomFieldStattable {
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private volatile CustomFieldInputHelper customFieldInputHelper;
    private volatile ClauseNames clauseNames;
    private final ComponentLocator componentLocator;
    private final ComponentFactory componentFactory;

    public CascadingSelectSearcher(ComponentLocator componentLocator, ComponentFactory componentFactory) {
        this.componentLocator = (ComponentLocator)Assertions.notNull((String)"componentLocator", (Object)componentLocator);
        this.componentFactory = (ComponentFactory)Assertions.notNull((String)"componentFactory", (Object)componentFactory);
    }

    public void init(CustomField field) {
        FieldVisibilityManager fieldVisibilityManager = (FieldVisibilityManager)this.componentLocator.getComponentInstanceOfType(FieldVisibilityManager.class);
        SelectConverter selectConverter = (SelectConverter)this.componentLocator.getComponentInstanceOfType(SelectConverter.class);
        JqlOperandResolver jqlOperandResolver = (JqlOperandResolver)this.componentLocator.getComponentInstanceOfType(JqlOperandResolver.class);
        JqlSelectOptionsUtil jqlSelectOptionsUtil = (JqlSelectOptionsUtil)this.componentLocator.getComponentInstanceOfType(JqlSelectOptionsUtil.class);
        JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil = (JqlCascadingSelectLiteralUtil)this.componentLocator.getComponentInstanceOfType(JqlCascadingSelectLiteralUtil.class);
        QueryContextConverter queryContextConverter = (QueryContextConverter)this.componentLocator.getComponentInstanceOfType(QueryContextConverter.class);
        this.customFieldInputHelper = (CustomFieldInputHelper)this.componentLocator.getComponentInstanceOfType(CustomFieldInputHelper.class);
        OperatorUsageValidator usageValidator = (OperatorUsageValidator)this.componentLocator.getComponentInstanceOfType(OperatorUsageValidator.class);
        this.clauseNames = field.getClauseNames();
        CascadingSelectCustomFieldIndexer indexer = new CascadingSelectCustomFieldIndexer(fieldVisibilityManager, field);
        DefaultCustomFieldValueProvider customFieldValueProvider = new DefaultCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(this.clauseNames, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, fieldVisibilityManager);
        this.searchInputTransformer = new CascadingSelectCustomFieldSearchInputTransformer(this.clauseNames, field, this.searcherInformation.getId(), selectConverter, jqlOperandResolver, jqlSelectOptionsUtil, jqlCascadingSelectLiteralUtil, queryContextConverter, this.customFieldInputHelper);
        Object queryFactory = new CascadingSelectCustomFieldClauseQueryFactory(field, field.getId(), jqlSelectOptionsUtil, jqlOperandResolver, jqlCascadingSelectLiteralUtil);
        queryFactory = new ValidatingDecoratorQueryFactory(usageValidator, (ClauseQueryFactory)queryFactory);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldContextValueGeneratingClauseHandler((ClauseValidator)this.componentFactory.createObject(CascadingSelectCustomFieldValidator.class, field), (ClauseQueryFactory)queryFactory, (ClauseContextFactory)this.componentFactory.createObject(CascadingSelectCustomFieldClauseContextFactory.class, field), (ClauseValuesGenerator)this.componentLocator.getComponentInstanceOfType(CustomFieldOptionsClauseValuesGenerator.class), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.CASCADING_OPTION);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        if (this.clauseNames == null) {
            throw new IllegalStateException("Attempt to retrieve Statistics Mapper off uninitialised custom field searcher.");
        }
        SelectConverter selectConverter = (SelectConverter)this.componentLocator.getComponentInstanceOfType(SelectConverter.class);
        return new CascadingSelectStatisticsMapper(customField, selectConverter, ComponentAccessor.getJiraAuthenticationContext(), this.customFieldInputHelper);
    }
}

