/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.persistence;

import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.OfBizCustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.collect.MapBuilder;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

public class EagerLoadingOfBizCustomFieldPersister
extends OfBizCustomFieldValuePersister {
    public EagerLoadingOfBizCustomFieldPersister(OfBizDelegator delegator) {
        super(delegator);
    }

    @Override
    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        super.createValues(field, issueId, persistenceFieldType, values);
        this.clearCache();
    }

    @Override
    public void createValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        super.createValues(field, issueId, persistenceFieldType, values, parentKey);
        this.clearCache();
    }

    @Override
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values) {
        super.updateValues(field, issueId, persistenceFieldType, values);
        this.clearCache();
    }

    @Override
    public void updateValues(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Collection values, String parentKey) {
        super.updateValues(field, issueId, persistenceFieldType, values, parentKey);
        this.clearCache();
    }

    @Override
    public Set<Long> removeValue(CustomField field, Long issueId, PersistenceFieldType persistenceFieldType, Object value) {
        Set<Long> set = super.removeValue(field, issueId, persistenceFieldType, value);
        this.clearCache();
        return set;
    }

    public Set removeAllValues(String customFieldId) {
        Set<Long> set = super.removeAllValues(customFieldId);
        this.clearCache();
        return set;
    }

    private void clearCache() {
        this.getCache().clear();
    }

    @Override
    protected List<GenericValue> getValuesForTypeAndParent(CustomField field, Long issueId, String parentKey) {
        List<?> cachedValuesForIssue = this.getValuesForIssueId(issueId);
        return EntityUtil.filterByAnd(cachedValuesForIssue, (Map)UtilMisc.toMap((String)"customfield", (Object)CustomFieldUtils.getCustomFieldId((String)field.getId()), (String)"parentkey", (Object)parentKey));
    }

    @Override
    protected List getValuesForType(CustomField field, Long issueId) {
        List<?> cachedValuesForIssue = this.getValuesForIssueId(issueId);
        return EntityUtil.filterByAnd(cachedValuesForIssue, (Map)UtilMisc.toMap((String)"customfield", (Object)CustomFieldUtils.getCustomFieldId((String)field.getId())));
    }

    private List<?> getValuesForIssueId(Long issueId) {
        List cachedValuesForIssue;
        CacheKey key;
        Map<CacheKey, SoftReference<List<?>>> queryToResultsCache = this.getCache();
        SoftReference<List<?>> cachedValuesReference = queryToResultsCache.get(key = new CacheKey(issueId));
        List list = cachedValuesForIssue = cachedValuesReference == null ? null : cachedValuesReference.get();
        if (cachedValuesForIssue == null) {
            Map limitClause = MapBuilder.build((Object)"issue", (Object)issueId);
            cachedValuesForIssue = this.delegator.findByAnd("CustomFieldValue", limitClause);
            queryToResultsCache.put(key, new SoftReference<List>(cachedValuesForIssue));
        }
        return cachedValuesForIssue;
    }

    private Map<CacheKey, SoftReference<List<?>>> getCache() {
        ConcurrentHashMap cache = (ConcurrentHashMap)JiraAuthenticationContextImpl.getRequestCache().get("jira.customfield.values.cache");
        if (cache == null) {
            cache = new ConcurrentHashMap();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.customfield.values.cache", cache);
        }
        return cache;
    }

    static final class CacheKey {
        private final Long issueId;

        CacheKey(Long issueId) {
            this.issueId = issueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.issueId == null ? cacheKey.issueId == null : this.issueId.equals(cacheKey.issueId);
        }

        public int hashCode() {
            return this.issueId != null ? this.issueId.hashCode() : 0;
        }
    }
}

