/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.event.issue.IssueEventDispatcher;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentComparator;
import com.atlassian.jira.issue.comments.CommentImpl;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDateUtils;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultCommentManager
implements CommentManager {
    private final UserManager userManager;
    private final IssueManager issueManager;
    private final ProjectRoleManager projectRoleManager;
    private final CommentPermissionManager commentPermissionManager;
    private final OfBizDelegator delegator;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private static final String COMMENT_ID = "id";
    public static final String COMMENT_ENTITY = "Action";

    public DefaultCommentManager(IssueManager issueManager, ProjectRoleManager projectRoleManager, CommentPermissionManager commentPermissionManager, OfBizDelegator delegator, JiraAuthenticationContext jiraAuthenticationContext, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, UserManager userManager) {
        this(issueManager, projectRoleManager, commentPermissionManager, delegator, jiraAuthenticationContext, textFieldCharacterLengthValidator, userManager, (JsonEntityPropertyManager)ComponentAccessor.getComponent(JsonEntityPropertyManager.class));
    }

    public DefaultCommentManager(IssueManager issueManager, ProjectRoleManager projectRoleManager, CommentPermissionManager commentPermissionManager, OfBizDelegator delegator, JiraAuthenticationContext jiraAuthenticationContext, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, UserManager userManager, JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.issueManager = issueManager;
        this.projectRoleManager = projectRoleManager;
        this.commentPermissionManager = commentPermissionManager;
        this.delegator = delegator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.userManager = userManager;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    public ProjectRole getProjectRole(Long projectRoleId) {
        return this.projectRoleManager.getProjectRole(projectRoleId);
    }

    public Comment convertToComment(GenericValue gv) {
        return this.convertToComment(gv, (Issue)this.issueManager.getIssueObject(gv.getLong("issue")));
    }

    public Comment getCommentById(Long commentId) {
        return this.getMutableComment(commentId);
    }

    public MutableComment getMutableComment(Long commentId) {
        if (commentId == null) {
            throw new IllegalArgumentException("The comment id must not be null.");
        }
        GenericValue gv = this.delegator.findById(COMMENT_ENTITY, commentId);
        if (gv != null) {
            return this.convertToComment(gv, (Issue)this.issueManager.getIssueObject(gv.getLong("issue")));
        }
        return null;
    }

    public List<Comment> getCommentsForUser(Issue issue, ApplicationUser user) {
        ArrayList<Comment> visibleComments = new ArrayList<Comment>();
        try {
            List allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            for (GenericValue commentGV : allComments) {
                MutableComment comment = this.convertToComment(commentGV, issue);
                if (!this.commentPermissionManager.hasBrowsePermission(user, (Comment)comment)) continue;
                visibleComments.add((Comment)comment);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(visibleComments, CommentComparator.COMPARATOR);
        return visibleComments;
    }

    public List<Comment> getCommentsForUser(Issue issue, User user) {
        return this.getCommentsForUser(issue, ApplicationUsers.from((User)user));
    }

    public List<Comment> getComments(Issue issue) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        try {
            List allComments = this.issueManager.getEntitiesByIssueObject("IssueComments", issue);
            for (Object allComment : allComments) {
                MutableComment comment = this.convertToComment((GenericValue)allComment, issue);
                comments.add((Comment)comment);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        Collections.sort(comments, CommentComparator.COMPARATOR);
        return comments;
    }

    public Comment create(Issue issue, ApplicationUser author, String body, boolean dispatchEvent) {
        return this.create(issue, author, body, null, null, dispatchEvent);
    }

    public Comment create(Issue issue, String author, String body, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), body, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, body, groupLevel, roleLevelId, new Date(), dispatchEvent);
    }

    public Comment create(Issue issue, String author, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), body, groupLevel, roleLevelId, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, author, body, groupLevel, roleLevelId, created, created, dispatchEvent);
    }

    public Comment create(Issue issue, String author, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), body, groupLevel, roleLevelId, created, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, ApplicationUser updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, updateAuthor, body, groupLevel, roleLevelId, created, updated, dispatchEvent, true);
    }

    public Comment create(Issue issue, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), this.userManager.getUserByKeyEvenWhenUnknown(updateAuthor), body, groupLevel, roleLevelId, created, updated, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, ApplicationUser updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent, boolean modifyIssueUpdateDate) {
        CommentImpl comment = new CommentImpl(this, author, updateAuthor, body, groupLevel, roleLevelId, created, updated, issue);
        if (this.textFieldCharacterLengthValidator.isTextTooLong(comment.getBody())) {
            long maximumNumberOfCharacters = this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters();
            String errorMessage = this.getText("field.error.text.toolong", String.valueOf(maximumNumberOfCharacters));
            throw new IllegalArgumentException(errorMessage);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("issue", issue.getId());
        fields.put("type", "comment");
        ApplicationUser commentAuthor = comment.getAuthorApplicationUser();
        ApplicationUser commentUpdateAuthor = comment.getUpdateAuthorApplicationUser();
        fields.put("author", commentAuthor == null ? null : commentAuthor.getKey());
        fields.put("updateauthor", commentUpdateAuthor == null ? null : commentUpdateAuthor.getKey());
        fields.put("body", comment.getBody());
        fields.put("level", comment.getGroupLevel());
        fields.put("rolelevel", comment.getRoleLevelId());
        fields.put("created", new Timestamp(comment.getCreated().getTime()));
        fields.put("updated", new Timestamp(comment.getUpdated().getTime()));
        GenericValue commentGV = EntityUtils.createValue(COMMENT_ENTITY, fields);
        comment.setId(commentGV.getLong(COMMENT_ID));
        if (modifyIssueUpdateDate && comment.getUpdated().getTime() > issue.getUpdated().getTime()) {
            IssueFactory issueFactory = (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
            MutableIssue mutableIssue = issueFactory.getIssue(issue.getGenericValue());
            mutableIssue.setUpdated(new Timestamp(comment.getUpdated().getTime()));
            issue.store();
        }
        if (dispatchEvent) {
            this.dispatchEvent(EventType.ISSUE_COMMENTED_ID, (Comment)comment, MapBuilder.build((Object)"eventsource", (Object)"action"));
        }
        return comment;
    }

    public Comment create(Issue issue, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent, boolean modifyIssueUpdateDate) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), this.userManager.getUserByKeyEvenWhenUnknown(updateAuthor), body, groupLevel, roleLevelId, created, updated, dispatchEvent, modifyIssueUpdateDate);
    }

    public void update(Comment comment, boolean dispatchEvent) {
        if (comment == null) {
            throw new IllegalArgumentException("Comment must not be null");
        }
        if (comment.getId() == null) {
            throw new IllegalArgumentException("Comment ID must not be null");
        }
        Comment originalComment = this.getCommentById(comment.getId());
        if (originalComment == null) {
            throw new IllegalArgumentException("Can not find a comment in the datastore with id: " + comment.getId());
        }
        if (this.areCommentsEquivalent(originalComment, comment)) {
            return;
        }
        try {
            GenericValue commentGV = this.delegator.findById(COMMENT_ENTITY, comment.getId());
            this.populateGenericValueFromComment(comment, commentGV);
            commentGV.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        IssueFactory issueFactory = (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
        GenericValue issueGV = comment.getIssue().getGenericValue();
        MutableIssue mutableIssue = issueFactory.getIssue(issueGV);
        mutableIssue.setUpdated(UtilDateTime.nowTimestamp());
        mutableIssue.store();
        if (dispatchEvent) {
            this.dispatchEvent(EventType.ISSUE_COMMENT_EDITED_ID, comment, MapBuilder.build((Object)"eventsource", (Object)"action", (Object)"originalcomment", (Object)originalComment));
        }
    }

    public ChangeItemBean delete(Comment comment) {
        ChangeItemBean changeItemBean = this.constructChangeItemBeanForCommentDelete(comment);
        this.delegator.removeByAnd(COMMENT_ENTITY, (Map)FieldMap.build((String)COMMENT_ID, (Object)comment.getId(), (String)"type", (Object)"comment"));
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.COMMENT_PROPERTY.getDbEntityName(), comment.getId());
        return changeItemBean;
    }

    public boolean isUserCommentAuthor(ApplicationUser user, Comment comment) {
        return this.commentPermissionManager.isUserCommentAuthor(user, comment);
    }

    public boolean isUserCommentAuthor(User user, Comment comment) {
        return this.isUserCommentAuthor(ApplicationUsers.from((User)user), comment);
    }

    public int swapCommentGroupRestriction(String groupName, String swapGroup) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        if (swapGroup == null) {
            throw new IllegalArgumentException("You must provide a non null swap group name.");
        }
        return this.delegator.bulkUpdateByAnd(COMMENT_ENTITY, (Map)FieldMap.build((String)"level", (Object)swapGroup), (Map)FieldMap.build((String)"level", (Object)groupName, (String)"type", (Object)"comment"));
    }

    public long getCountForCommentsRestrictedByGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)"level", (Object)groupName, (String)"type", (Object)"comment"), EntityOperator.AND);
        List commentCount = this.delegator.findByCondition("ActionCount", (EntityCondition)condition, (Collection)EasyList.build((Object)"count"), Collections.EMPTY_LIST);
        if (commentCount != null && commentCount.size() == 1) {
            GenericValue commentCountGV = (GenericValue)commentCount.get(0);
            return commentCountGV.getLong("count");
        }
        throw new DataAccessException("Unable to access the count for the Action table");
    }

    ChangeItemBean constructChangeItemBeanForCommentDelete(Comment comment) {
        String groupLevel = comment.getGroupLevel();
        String roleLevel = comment.getRoleLevel() == null ? null : comment.getRoleLevel().getName();
        String actionLevel = groupLevel == null ? roleLevel : groupLevel;
        String message = actionLevel != null ? this.getText("comment.manager.deleted.comment.with.restricted.level", actionLevel) : comment.getBody();
        return new ChangeItemBean("jira", "Comment", message, null);
    }

    void dispatchEvent(Long eventTypeId, Comment comment, Map parameters) {
        IssueEventDispatcher.dispatchEvent(eventTypeId, comment.getIssue(), comment.getUpdateAuthorUser(), comment, null, null, parameters);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }

    private void populateGenericValueFromComment(Comment updatedComment, GenericValue commentGV) {
        ApplicationUser updateAuthor = updatedComment.getUpdateAuthorApplicationUser();
        commentGV.setString("updateauthor", updateAuthor == null ? null : updateAuthor.getKey());
        commentGV.setString("body", updatedComment.getBody());
        commentGV.setString("level", updatedComment.getGroupLevel());
        commentGV.set("rolelevel", (Object)updatedComment.getRoleLevelId());
        commentGV.set("updated", (Object)JiraDateUtils.copyOrCreateTimestampNullsafe((Date)updatedComment.getUpdated()));
    }

    private MutableComment convertToComment(GenericValue gv, Issue issue) {
        Timestamp createdTS = gv.getTimestamp("created");
        Timestamp updatedTS = gv.getTimestamp("updated");
        CommentImpl comment = new CommentImpl(this, this.userManager.getUserByKeyEvenWhenUnknown(gv.getString("author")), this.userManager.getUserByKeyEvenWhenUnknown(gv.getString("updateauthor")), gv.getString("body"), gv.getString("level"), gv.getLong("rolelevel"), JiraDateUtils.copyDateNullsafe((Date)createdTS), JiraDateUtils.copyDateNullsafe((Date)updatedTS), issue);
        comment.setId(gv.getLong(COMMENT_ID));
        return comment;
    }

    private boolean areCommentsEquivalent(Comment comment1, Comment comment2) {
        return ObjectUtils.equalsNullSafe((Object)comment1.getBody(), (Object)comment2.getBody()) && ObjectUtils.equalsNullSafe((Object)comment1.getGroupLevel(), (Object)comment2.getGroupLevel()) && ObjectUtils.equalsNullSafe((Object)comment1.getRoleLevelId(), (Object)comment2.getRoleLevelId());
    }
}

