/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AbstractIssue;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueImpl
extends AbstractIssue
implements MutableIssue {
    private final ProjectManager projectManager;
    private final VersionManager versionManager;
    private final LabelManager labelManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final SubTaskManager subTaskManager;
    private final ProjectComponentManager projectComponentManager;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private GenericValue genericValue;
    private Long projectId;
    private Long issueNumber;
    private String key;
    private String issueTypeId;
    private String summary;
    private String description;
    private String environment;
    private String assigneeId;
    private String reporterId;
    private Timestamp created;
    private Timestamp updated;
    private Timestamp dueDate;
    private Timestamp resolutionDate;
    private Long securityLevelId;
    private String priorityId;
    private String resolutionId;
    private String statusId;
    private Long votes;
    private Long watches;
    private Long originalEstimate;
    private Long estimate;
    private Long timespent;
    private Long workflowId;
    private Set<Label> labels;
    private String creatorId;
    private GenericValue issueType;
    private User assignee;
    private User reporter;
    private User creator;
    private Collection<GenericValue> components;
    private Collection<Version> affectedVersions;
    private Collection<Version> fixVersions;
    private GenericValue securityLevel;
    private GenericValue priority;
    private GenericValue resolution;
    private GenericValue status;
    private final Map<CustomField, Object> customFieldValues;
    private final Map<String, ModifiedValue> modifiedFields;
    private final Map<String, Object> externalFields;
    private Long parentId;
    boolean hasNoParentId = false;
    private Issue parentIssue;

    public IssueImpl(GenericValue genericValue, IssueManager issueManager, ProjectManager projectManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ConstantsManager constantsManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, LabelManager labelManager, ProjectComponentManager projectComponentManager, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext) {
        super(constantsManager, issueManager, attachmentManager);
        this.genericValue = genericValue;
        this.projectManager = projectManager;
        this.versionManager = versionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.subTaskManager = subTaskManager;
        this.labelManager = labelManager;
        this.projectComponentManager = projectComponentManager;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.customFieldValues = new HashMap<CustomField, Object>();
        this.modifiedFields = new HashMap<String, ModifiedValue>();
        this.externalFields = new HashMap<String, Object>();
        this.init(genericValue);
        this.initializeKey();
    }

    public IssueImpl(Issue issue, IssueManager issueManager, ProjectManager projectManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ConstantsManager constantsManager, SubTaskManager subTaskManager, AttachmentManager attachmentManager, LabelManager labelManager, ProjectComponentManager projectComponentManager, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this((GenericValue)null, issueManager, projectManager, versionManager, issueSecurityLevelManager, constantsManager, subTaskManager, attachmentManager, labelManager, projectComponentManager, userManager, jiraAuthenticationContext);
        this.setAffectedVersions(issue.getAffectedVersions());
        this.setFixVersions(issue.getFixVersions());
        this.setComponents(issue.getComponents());
        this.setLabels(issue.getLabels());
        this.init(issue.getGenericValue());
        this.setParentId(issue.getParentId());
    }

    public static MutableIssue getIssueObject(GenericValue genericValue) {
        return new IssueImpl(genericValue, ComponentAccessor.getIssueManager(), ComponentAccessor.getProjectManager(), ComponentAccessor.getVersionManager(), ComponentAccessor.getIssueSecurityLevelManager(), ComponentAccessor.getConstantsManager(), ComponentAccessor.getSubTaskManager(), ComponentAccessor.getAttachmentManager(), (LabelManager)ComponentAccessor.getComponentOfType(LabelManager.class), (ProjectComponentManager)ComponentAccessor.getComponentOfType(ProjectComponentManager.class), (UserManager)ComponentAccessor.getComponentOfType(UserManager.class), (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class));
    }

    private void init(GenericValue genericValue) {
        if (genericValue != null) {
            this.projectId = genericValue.getLong("project");
            this.issueNumber = genericValue.getLong("number");
            this.issueTypeId = genericValue.getString("type");
            this.summary = genericValue.getString("summary");
            this.description = genericValue.getString("description");
            this.environment = genericValue.getString("environment");
            this.assigneeId = genericValue.getString("assignee");
            this.reporterId = genericValue.getString("reporter");
            this.creatorId = genericValue.getString("creator");
            this.dueDate = genericValue.getTimestamp("duedate");
            this.securityLevelId = genericValue.getLong("security");
            this.priorityId = genericValue.getString("priority");
            this.statusId = genericValue.getString("status");
            this.resolutionId = genericValue.getString("resolution");
            this.created = genericValue.getTimestamp("created");
            this.updated = genericValue.getTimestamp("updated");
            this.resolutionDate = genericValue.getTimestamp("resolutiondate");
            this.originalEstimate = genericValue.getLong("timeoriginalestimate");
            this.estimate = genericValue.getLong("timeestimate");
            this.timespent = genericValue.getLong("timespent");
            this.votes = genericValue.getLong("votes");
            this.watches = genericValue.getLong("watches");
            if (this.votes == null) {
                this.votes = new Long(0L);
            }
            this.workflowId = genericValue.getLong("workflowId");
        }
    }

    public Long getId() {
        return this.genericValue == null ? null : this.genericValue.getLong("id");
    }

    public GenericValue getProject() {
        GenericValue project = null;
        if (this.projectId != null) {
            project = this.projectManager.getProject(this.projectId);
        }
        return project;
    }

    public Project getProjectObject() {
        Project project = null;
        if (this.projectId != null) {
            project = this.projectManager.getProjectObj(this.projectId);
        }
        return project;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        if (projectId == null) {
            this.setProjectObject(null);
        } else {
            Project project = this.projectManager.getProjectObj(projectId);
            if (project == null) {
                throw new IllegalArgumentException("Invalid Project ID '" + projectId + "'.");
            }
            this.setProjectObject(project);
        }
    }

    public void setProject(GenericValue project) {
        if (project == null) {
            this.setProjectObject(null);
        } else {
            this.setProjectId(project.getLong("id"));
        }
    }

    public void setProjectObject(Project project) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getProjectObject(), (Object)project);
        this.modifiedFields.put("project", modifiedValue);
        this.projectId = project != null ? project.getId() : null;
        if (this.genericValue != null) {
            this.genericValue.set("project", (Object)this.projectId);
        }
        this.initializeKey();
    }

    public GenericValue getIssueType() {
        if (this.issueType == null && this.issueTypeId != null) {
            this.issueType = this.constantsManager.getIssueType(this.issueTypeId);
        }
        return this.issueType;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueType(GenericValue issueType) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getIssueType(), (Object)issueType);
        this.issueType = issueType;
        this.modifiedFields.put("issuetype", modifiedValue);
        this.issueTypeId = issueType != null ? issueType.getString("id") : null;
        this.updateGV("type", this.issueTypeId);
    }

    public void setIssueTypeObject(IssueType issueType) {
        if (issueType == null) {
            this.setIssueType(null);
        } else {
            this.setIssueType(issueType.getGenericValue());
        }
    }

    public void setIssueTypeId(String issueTypeId) {
        if (issueTypeId != null) {
            this.setIssueType(this.constantsManager.getIssueType(issueTypeId));
        } else {
            this.setIssueType(null);
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getSummary(), (Object)summary);
        this.summary = summary;
        this.updateGV("summary", summary);
        this.modifiedFields.put("summary", modifiedValue);
    }

    public User getReporterUser() {
        return this.getReporter();
    }

    public User getReporter() {
        if (this.reporter == null && this.reporterId != null) {
            this.reporter = this.getUserByKey(this.reporterId);
        }
        return this.reporter;
    }

    public String getReporterId() {
        return this.reporterId;
    }

    public User getCreator() {
        if (this.creator == null && this.creatorId != null) {
            this.creator = this.getUserByKey(this.creatorId);
        }
        return this.creator;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setReporter(User reporter) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getReporter(), (Object)reporter);
        this.reporter = reporter;
        this.modifiedFields.put("reporter", modifiedValue);
        this.reporterId = reporter != null ? ApplicationUsers.getKeyFor((User)reporter) : null;
        this.updateGV("reporter", this.reporterId);
    }

    public void setReporterId(String reporterId) {
        this.setReporter(this.getUserByKey(reporterId));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getDescription(), (Object)description);
        this.description = description;
        this.modifiedFields.put("description", modifiedValue);
        this.updateGV("description", description);
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getEnvironment(), (Object)environment);
        this.environment = environment;
        this.modifiedFields.put("environment", modifiedValue);
        this.updateGV("environment", environment);
    }

    public User getAssigneeUser() {
        return this.getAssignee();
    }

    public User getAssignee() {
        if (this.assignee == null && this.assigneeId != null) {
            this.assignee = this.getUserByKey(this.assigneeId);
        }
        return this.assignee;
    }

    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssignee(User assignee) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getAssignee(), (Object)assignee);
        this.assignee = assignee;
        this.modifiedFields.put("assignee", modifiedValue);
        this.assigneeId = assignee != null ? ApplicationUsers.getKeyFor((User)assignee) : null;
        this.updateGV("assignee", this.assigneeId);
    }

    public void setAssigneeId(String assigneeKey) {
        this.setAssignee(this.getUserByKey(assigneeKey));
    }

    public Collection<ProjectComponent> getComponentObjects() {
        return this.projectComponentManager.findComponentsByIssue((Issue)this);
    }

    public Collection<GenericValue> getComponents() {
        if (this.components == null) {
            this.components = this.projectComponentManager.findComponentsByIssueGV((Issue)this);
        }
        return new ArrayList<GenericValue>(this.components);
    }

    public void setComponents(Collection<GenericValue> components) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getComponents(), components);
        this.components = components;
        this.modifiedFields.put("components", modifiedValue);
    }

    public void setComponentObjects(Collection<ProjectComponent> components) {
        if (components == null) {
            components = Collections.emptyList();
        }
        ArrayList<GenericValue> gvComponents = new ArrayList<GenericValue>(components.size());
        for (ProjectComponent component : components) {
            gvComponents.add(component.getGenericValue());
        }
        this.setComponents(gvComponents);
    }

    public Collection<Version> getFixVersions() {
        if (this.fixVersions == null) {
            if (this.genericValue != null) {
                ArrayList<Version> newValue = new ArrayList<Version>(this.versionManager.getFixVersionsFor((Issue)this));
                Collections.sort(newValue, VersionComparator.COMPARATOR);
                this.fixVersions = newValue;
            } else {
                this.fixVersions = Collections.emptyList();
            }
        }
        return new ArrayList<Version>(this.fixVersions);
    }

    public void setFixVersions(Collection<Version> fixVersions) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getFixVersions(), fixVersions);
        this.fixVersions = fixVersions;
        this.modifiedFields.put("fixVersions", modifiedValue);
    }

    public Timestamp getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Timestamp dueDate) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getDueDate(), (Object)dueDate);
        this.dueDate = dueDate;
        this.modifiedFields.put("duedate", modifiedValue);
        this.updateGV("duedate", dueDate);
    }

    public GenericValue getSecurityLevel() {
        if (this.securityLevel == null && this.securityLevelId != null) {
            try {
                this.securityLevel = this.issueSecurityLevelManager.getIssueSecurityLevel(this.securityLevelId);
            }
            catch (GenericEntityException e) {
                throw new DataAccessException("Cannot retrieve security level with id '" + this.securityLevelId + "'.", (Throwable)e);
            }
        }
        return this.securityLevel;
    }

    public Long getSecurityLevelId() {
        return this.securityLevelId;
    }

    public void setSecurityLevelId(Long securityLevelId) {
        if (securityLevelId == null) {
            this.setSecurityLevel(null);
        } else {
            GenericValue securityLevelGV = null;
            try {
                securityLevelGV = this.issueSecurityLevelManager.getIssueSecurityLevel(securityLevelId);
            }
            catch (GenericEntityException e) {
                throw new IllegalArgumentException("Invalid SecurityLevel ID '" + securityLevelId + "'.");
            }
            if (securityLevelGV == null) {
                throw new IllegalArgumentException("Invalid SecurityLevel ID '" + securityLevelId + "'.");
            }
            this.setSecurityLevel(securityLevelGV);
        }
    }

    public void setSecurityLevel(GenericValue securityLevel) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getSecurityLevel(), (Object)securityLevel);
        this.securityLevel = securityLevel;
        this.modifiedFields.put("security", modifiedValue);
        this.securityLevelId = securityLevel != null ? securityLevel.getLong("id") : null;
        this.updateGV("security", this.securityLevelId);
    }

    public GenericValue getPriority() {
        if (this.priority == null && this.priorityId != null) {
            Priority priorityObject = this.constantsManager.getPriorityObject(this.priorityId);
            this.priority = priorityObject != null ? priorityObject.getGenericValue() : null;
        }
        return this.priority;
    }

    public void setPriority(GenericValue priority) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getPriority(), (Object)priority);
        this.priority = priority;
        this.modifiedFields.put("priority", modifiedValue);
        this.priorityId = priority != null ? priority.getString("id") : null;
        this.updateGV("priority", this.priorityId);
    }

    public void setPriorityObject(Priority priority) {
        if (priority == null) {
            this.setPriority(null);
        } else {
            this.setPriority(priority.getGenericValue());
        }
    }

    public void setPriorityId(String priorityId) {
        if (priorityId != null) {
            Priority priorityObject = this.constantsManager.getPriorityObject(priorityId);
            this.setPriority(priorityObject != null ? priorityObject.getGenericValue() : null);
        } else {
            this.setPriority(null);
        }
    }

    public String getResolutionId() {
        return this.resolutionId;
    }

    public GenericValue getResolution() {
        if (this.resolution == null && this.resolutionId != null) {
            this.resolution = this.constantsManager.getResolution(this.resolutionId);
        }
        return this.resolution;
    }

    public void setResolutionId(String resolutionId) {
        if (resolutionId != null) {
            this.setResolution(this.constantsManager.getResolution(resolutionId));
        } else {
            this.setResolution(null);
        }
    }

    public void setResolution(GenericValue resolution) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getResolution(), (Object)resolution);
        this.resolution = resolution;
        this.modifiedFields.put("resolution", modifiedValue);
        if (resolution != null && resolution.getString("id") != null) {
            String oldResolutionId = this.resolutionId;
            this.resolutionId = resolution.getString("id");
            if (!this.resolutionId.equals(oldResolutionId) || this.resolutionDate == null) {
                this.setResolutionDate(new Timestamp(System.currentTimeMillis()));
            }
        } else {
            this.resolutionId = null;
            this.setResolutionDate(null);
        }
        this.updateGV("resolution", this.resolutionId);
    }

    public void setResolutionObject(Resolution resolution) {
        if (resolution == null) {
            this.setResolution(null);
        } else {
            this.setResolution(resolution.getGenericValue());
        }
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        if (this.genericValue != null) {
            return this.genericValue.getString("key");
        }
        return null;
    }

    public Long getNumber() {
        return this.issueNumber;
    }

    public void setKey(String key) {
        this.setProjectId(null);
        this.setNumber(null);
        if (key != null) {
            IssueKey issueKey = IssueKey.from((String)key);
            Project project = this.projectManager.getProjectObjByKey(issueKey.getProjectKey());
            if (project == null) {
                throw new IllegalArgumentException(String.format("Invalid project key '%s'", issueKey.getProjectKey()));
            }
            this.setProjectObject(project);
            this.setNumber(issueKey.getIssueNumber());
        }
        this.initializeKey();
    }

    public void setNumber(Long number) {
        this.issueNumber = number;
        this.updateGV("number", number);
        this.initializeKey();
    }

    public Long getVotes() {
        return this.votes;
    }

    public void setVotes(Long votes) {
        this.votes = votes;
        this.updateGV("votes", votes);
    }

    public Long getWatches() {
        return this.watches;
    }

    public void setWatches(Long watches) {
        this.watches = watches;
        this.updateGV("watches", watches);
    }

    public Collection<Version> getAffectedVersions() {
        if (this.affectedVersions == null) {
            if (this.genericValue != null) {
                ArrayList<Version> newValue = new ArrayList<Version>(this.versionManager.getAffectedVersionsFor((Issue)this));
                Collections.sort(newValue, VersionComparator.COMPARATOR);
                this.affectedVersions = newValue;
            } else {
                this.affectedVersions = Collections.emptyList();
            }
        }
        return new ArrayList<Version>(this.affectedVersions);
    }

    public void setAffectedVersions(Collection<Version> affectedVersions) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getAffectedVersions(), affectedVersions);
        this.affectedVersions = affectedVersions;
        this.modifiedFields.put("versions", modifiedValue);
    }

    public String getString(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getString(name);
        }
        throw new IllegalStateException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    public Timestamp getTimestamp(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getTimestamp(name);
        }
        throw new IllegalArgumentException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    public Long getLong(String name) {
        if (this.genericValue != null) {
            return this.genericValue.getLong(name);
        }
        throw new IllegalArgumentException("Cannot retrieve '" + name + "' as the issue has not been saved yet.");
    }

    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public void setCreated(Timestamp created) {
        this.created = created;
        this.updateGV("created", created);
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    public void setUpdated(Timestamp updated) {
        this.updated = updated;
        this.updateGV("updated", updated);
    }

    public Timestamp getResolutionDate() {
        return this.resolutionDate;
    }

    public void setResolutionDate(Timestamp resolutionDate) {
        this.resolutionDate = resolutionDate;
        this.updateGV("resolutiondate", resolutionDate);
    }

    public Long getWorkflowId() {
        return this.workflowId;
    }

    public void setWorkflowId(Long workflowId) {
        this.workflowId = workflowId;
    }

    public Object getCustomFieldValue(CustomField customField) {
        if (!this.customFieldValues.containsKey(customField)) {
            if (this.genericValue != null) {
                this.customFieldValues.put(customField, customField.getValue((Issue)this));
            } else {
                this.customFieldValues.put(customField, customField.getDefaultValue((Issue)this));
            }
        }
        return this.customFieldValues.get(customField);
    }

    public void setCustomFieldValue(CustomField customField, Object value) {
        ModifiedValue modifiedValue = new ModifiedValue(this.getCustomFieldValue(customField), value);
        this.customFieldValues.put(customField, value);
        this.modifiedFields.put(customField.getId(), modifiedValue);
    }

    public Object getExternalFieldValue(String fieldId) {
        return this.externalFields.get(fieldId);
    }

    public void setExternalFieldValue(String fieldId, Object newValue) {
        this.setExternalFieldValue(fieldId, null, newValue);
    }

    public void setExternalFieldValue(String fieldId, Object oldValue, Object newValue) {
        ModifiedValue modifiedValue = new ModifiedValue(oldValue, newValue);
        this.externalFields.put(fieldId, newValue);
        this.modifiedFields.put(fieldId, modifiedValue);
    }

    public boolean isSubTask() {
        return this.getParentId() != null;
    }

    public Long getParentId() {
        if (this.parentId == null && this.getGenericValue() != null && !this.hasNoParentId) {
            this.parentId = this.subTaskManager.getParentIssueId(this.getGenericValue());
            if (this.parentId == null) {
                this.hasNoParentId = true;
            }
        }
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
        this.parentIssue = null;
    }

    public void setParentObject(Issue parentIssue) throws IllegalArgumentException {
        if (parentIssue == null) {
            this.parentId = null;
        } else {
            if (parentIssue.getId() == null) {
                throw new IllegalArgumentException("Parent issue cannot have a null ID.");
            }
            this.parentId = parentIssue.getId();
        }
        this.parentIssue = parentIssue;
    }

    @Override
    public Issue getParentObject() {
        if (this.parentIssue == null) {
            return super.getParentObject();
        }
        return this.parentIssue;
    }

    @Override
    public GenericValue getParent() {
        if (this.parentIssue == null) {
            return super.getParent();
        }
        return this.parentIssue.getGenericValue();
    }

    public Collection<GenericValue> getSubTasks() {
        if (this.isCreated()) {
            return this.subTaskManager.getSubTasks(this.getGenericValue());
        }
        return Collections.emptyList();
    }

    public Collection<Issue> getSubTaskObjects() {
        if (this.isCreated()) {
            return this.subTaskManager.getSubTaskObjects((Issue)this);
        }
        return Collections.emptyList();
    }

    public boolean isCreated() {
        return this.getGenericValue() != null;
    }

    public GenericValue getStatus() {
        if (this.status == null && this.statusId != null) {
            this.status = this.constantsManager.getStatus(this.statusId);
        }
        return this.status;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
        this.status = this.constantsManager.getStatus(statusId);
        this.updateGV("status", statusId);
    }

    public void setLabels(Set<Label> labels) {
        String oldLabels = StringUtils.join(this.getLabels(), (String)" ");
        String newLabels = StringUtils.join(labels, (String)" ");
        ModifiedValue modifiedValue = new ModifiedValue((Object)oldLabels, (Object)newLabels);
        this.labels = labels;
        this.modifiedFields.put("labels", modifiedValue);
    }

    public Set<Label> getLabels() {
        if (this.labels == null) {
            this.labels = this.genericValue != null ? this.labelManager.getLabels(this.getId()) : Collections.emptySet();
        }
        return this.labels;
    }

    public void setStatus(GenericValue status) {
        this.status = status;
        if (status != null) {
            this.statusId = status.getString("id");
        }
        this.updateGV("status", this.statusId);
    }

    public void setStatusObject(Status status) {
        if (status == null) {
            this.setStatus(null);
        } else {
            this.setStatus(status.getGenericValue());
        }
    }

    public Long getOriginalEstimate() {
        return this.originalEstimate;
    }

    public void setOriginalEstimate(Long originalEstimate) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getOriginalEstimate(), (Object)originalEstimate);
        this.originalEstimate = originalEstimate;
        this.modifiedFields.put("timetracking", modifiedValue);
        this.updateGV("timeoriginalestimate", originalEstimate);
    }

    public Long getEstimate() {
        return this.estimate;
    }

    public void setEstimate(Long estimate) {
        ModifiedValue modifiedValue = new ModifiedValue((Object)this.getEstimate(), (Object)estimate);
        this.estimate = estimate;
        this.modifiedFields.put("timetracking", modifiedValue);
        this.updateGV("timeestimate", estimate);
    }

    public Long getTimeSpent() {
        return this.timespent;
    }

    public void setTimeSpent(Long timespent) {
        this.timespent = timespent;
        this.updateGV("timespent", timespent);
    }

    public IssueRenderContext getIssueRenderContext() {
        return new IssueRenderContext((Issue)this);
    }

    public void store() {
        try {
            if (!this.isCreated()) {
                this.creatorId = this.getLoggedInUserKey();
                FieldMap fields = new FieldMap();
                fields.put((Object)"project", (Object)this.projectId);
                fields.put((Object)"type", (Object)this.issueTypeId);
                fields.put((Object)"created", (Object)this.created);
                fields.put((Object)"updated", (Object)this.updated);
                fields.put((Object)"duedate", (Object)this.dueDate);
                fields.put((Object)"resolutiondate", (Object)this.resolutionDate);
                fields.put((Object)"assignee", (Object)this.assigneeId);
                fields.put((Object)"reporter", (Object)this.reporterId);
                fields.put((Object)"creator", (Object)this.creatorId);
                fields.put((Object)"summary", (Object)this.summary);
                fields.put((Object)"description", (Object)this.description);
                fields.put((Object)"environment", (Object)this.environment);
                fields.put((Object)"priority", (Object)this.priorityId);
                fields.put((Object)"status", (Object)this.statusId);
                fields.put((Object)"number", (Object)this.issueNumber);
                fields.put((Object)"votes", (Object)this.votes);
                fields.put((Object)"watches", (Object)this.watches);
                fields.put((Object)"security", (Object)this.securityLevelId);
                fields.put((Object)"timeoriginalestimate", (Object)this.originalEstimate);
                fields.put((Object)"timeestimate", (Object)this.estimate);
                fields.put((Object)"timespent", (Object)this.timespent);
                fields.put((Object)"workflowId", (Object)this.workflowId);
                this.genericValue = EntityUtils.createValue("Issue", (Map<String, Object>)fields);
                this.init(this.genericValue);
            } else {
                this.genericValue.store();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while storing issue.", (Throwable)e);
        }
    }

    public Map<String, ModifiedValue> getModifiedFields() {
        return this.modifiedFields;
    }

    public void resetModifiedFields() {
        this.modifiedFields.clear();
        this.externalFields.clear();
    }

    private void initializeKey() {
        this.key = this.getProjectObject() != null && this.issueNumber != null ? IssueKey.format((Project)this.getProjectObject(), (long)this.issueNumber) : null;
    }

    private void updateGV(String fieldName, Object fieldValue) {
        if (this.genericValue != null) {
            this.genericValue.set(fieldName, fieldValue);
        }
    }

    private User getUserByKey(String userKey) {
        if (userKey != null) {
            return this.userManager.getUserByKeyEvenWhenUnknown(userKey).getDirectoryUser();
        }
        return null;
    }

    private String getLoggedInUserKey() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        return user != null ? user.getKey() : null;
    }

    public String toString() {
        String key = this.getKey();
        return key == null ? this.summary : key;
    }
}

