/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.io;

import com.atlassian.jira.io.SessionTempFile;
import com.atlassian.jira.io.SessionTempFileImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionTempFiles
implements HttpSessionBindingListener,
Serializable {
    @VisibleForTesting
    static final String SESSION_ATTRIBUTE_NAME = "jira.SessionTempFiles";
    private static final Logger logger = LoggerFactory.getLogger(SessionTempFiles.class);
    private final HttpSession session;
    private final List<SessionTempFile> tempFiles = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static SessionTempFiles forSession(@Nonnull HttpSession session) {
        SessionTempFiles tempFiles = (SessionTempFiles)session.getAttribute(SESSION_ATTRIBUTE_NAME);
        if (tempFiles == null) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                tempFiles = (SessionTempFiles)session.getAttribute(SESSION_ATTRIBUTE_NAME);
                if (tempFiles == null) {
                    tempFiles = new SessionTempFiles(session);
                    session.setAttribute(SESSION_ATTRIBUTE_NAME, (Object)tempFiles);
                }
            }
        }
        return tempFiles;
    }

    @VisibleForTesting
    SessionTempFiles(@Nonnull HttpSession session) {
        this.session = (HttpSession)Preconditions.checkNotNull((Object)session);
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        try {
            this.deleteAllSessionTempFiles();
        }
        catch (RuntimeException e) {
            logger.error("Error deleting session temp files for session" + this.session.getId(), (Throwable)e);
        }
    }

    String getSessionId() {
        return this.session.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionTempFile createTempFile(File file) {
        SessionTempFileImpl sessionTempFile = new SessionTempFileImpl(this, file);
        List<SessionTempFile> list = this.tempFiles;
        synchronized (list) {
            this.tempFiles.add(sessionTempFile);
        }
        return sessionTempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionTempFile getTempFile(File file) {
        List<SessionTempFile> list = this.tempFiles;
        synchronized (list) {
            for (SessionTempFile tempFile : this.tempFiles) {
                if (!tempFile.getFile().equals(file)) continue;
                return tempFile;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SessionTempFile sessionTempFile) {
        List<SessionTempFile> list = this.tempFiles;
        synchronized (list) {
            this.tempFiles.remove(sessionTempFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllSessionTempFiles() {
        List<SessionTempFile> list = this.tempFiles;
        synchronized (list) {
            for (SessionTempFile tempFile : ImmutableList.copyOf(this.tempFiles)) {
                File file;
                if (tempFile.delete() || !(file = tempFile.getFile()).exists()) continue;
                logger.warn("Failed to delete {}. Marking this file for deletion with File.deleteOnExit()...", (Object)tempFile);
                file.deleteOnExit();
            }
        }
    }
}

