/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.fugue.Option;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.IndexDocumentConfigurationFactory;
import com.atlassian.jira.index.property.EntityPropertyIndexDocument;
import com.atlassian.jira.index.property.EntityPropertyIndexDocumentFactory;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.sql.Timestamp;
import java.util.List;
import org.apache.log4j.Logger;

public class OfBizPluginIndexConfigurationManager
implements PluginIndexConfigurationManager {
    private static final Logger log = Logger.getLogger(OfBizPluginIndexConfigurationManager.class);
    private final EntityEngine entityEngine;
    private final IndexDocumentConfigurationFactory indexDocumentConfigurationFactory;
    private final ReindexMessageManager reindexMessageManager;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;

    public OfBizPluginIndexConfigurationManager(EntityEngine entityEngine, IndexDocumentConfigurationFactory indexDocumentConfigurationFactory, ReindexMessageManager reindexMessageManager, JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.entityEngine = entityEngine;
        this.indexDocumentConfigurationFactory = indexDocumentConfigurationFactory;
        this.reindexMessageManager = reindexMessageManager;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    @Override
    public Iterable<PluginIndexConfiguration> getDocumentsForEntity(final String entityName) {
        List indexDocuments = Select.from(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).whereEqual("entityKey", entityName).runWith(this.entityEngine).asList();
        return Iterables.filter((Iterable)Iterables.transform(indexDocuments, (Function)new Function<EntityPropertyIndexDocument, PluginIndexConfiguration>(){

            public PluginIndexConfiguration apply(EntityPropertyIndexDocument indexDocument) {
                try {
                    return new PluginIndexConfigurationImpl(indexDocument.getPluginKey(), indexDocument.getModuleKey(), OfBizPluginIndexConfigurationManager.this.indexDocumentConfigurationFactory.fromXML(indexDocument.getDocument()), indexDocument.getUpdated());
                }
                catch (IndexDocumentConfigurationFactory.IndexDocumentConfigurationParseException e) {
                    log.error((Object)("The configuration of index document for entity " + entityName + " is invalid id=" + indexDocument.getId()), (Throwable)e);
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull());
    }

    @Override
    public void put(final String pluginKey, final String moduleKey, final IndexDocumentConfiguration document) {
        Assertions.notNull((String)"pluginKey", (Object)pluginKey);
        OfBizPluginIndexConfigurationManager.restrictLength("pluginKey", pluginKey, 255);
        Assertions.notNull((String)"moduleKey", (Object)moduleKey);
        OfBizPluginIndexConfigurationManager.restrictLength("moduleKey", moduleKey, 255);
        Assertions.notNull((String)"document", (Object)document);
        final String documentValue = this.indexDocumentConfigurationFactory.toXML(document);
        Assertions.notBlank((String)"documentValue", (String)documentValue);
        OfBizPluginIndexConfigurationManager.restrictLength("documentValue", documentValue, 32768);
        final String entityKey = document.getEntityKey();
        Assertions.notNull((String)"entityKey", (Object)entityKey);
        OfBizPluginIndexConfigurationManager.restrictLength("entityKey", entityKey, 255);
        Option<EntityPropertyIndexDocument> entityPropertyIndexDocument = this.getDocumentForPluginAndModule(pluginKey, moduleKey);
        final Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        entityPropertyIndexDocument.fold((Supplier)new Supplier<Void>(){

            public Void get() {
                EntityPropertyIndexDocumentFactory.EntityPropertyIndexDocumentImpl indexDocument = new EntityPropertyIndexDocumentFactory.EntityPropertyIndexDocumentImpl(null, pluginKey, moduleKey, entityKey, documentValue, timestamp);
                OfBizPluginIndexConfigurationManager.this.entityEngine.createValue(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT, indexDocument);
                OfBizPluginIndexConfigurationManager.this.checkReindexRequired(document);
                return null;
            }
        }, (Function)new Function<EntityPropertyIndexDocument, Void>(){

            public Void apply(EntityPropertyIndexDocument existing) {
                if (!OfBizPluginIndexConfigurationManager.this.configurationsEquals(document, existing.getDocument())) {
                    Update.into(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).set("document", documentValue).set("updated", timestamp).set("entityKey", entityKey).whereEqual("id", existing.getId()).execute(OfBizPluginIndexConfigurationManager.this.entityEngine);
                    OfBizPluginIndexConfigurationManager.this.checkReindexRequired(document);
                }
                return null;
            }
        });
    }

    private void checkReindexRequired(IndexDocumentConfiguration document) {
        Iterable configurationElements = document.getConfigurationElements();
        if (Iterables.any((Iterable)configurationElements, (Predicate)new Predicate<IndexDocumentConfiguration.ConfigurationElement>(){

            public boolean apply(IndexDocumentConfiguration.ConfigurationElement input) {
                return OfBizPluginIndexConfigurationManager.this.jsonEntityPropertyManager.countByEntityNameAndPropertyKey(input.getEntityKey(), input.getPropertyKey()) > 0L;
            }
        })) {
            this.reindexMessageManager.pushMessage(null, "jira.plugin.index.configuration");
        }
    }

    private boolean configurationsEquals(IndexDocumentConfiguration newConfiguration, String existingCOnfigurationStr) {
        try {
            IndexDocumentConfiguration existingConfiguration = this.indexDocumentConfigurationFactory.fromXML(existingCOnfigurationStr);
            return existingConfiguration.equals((Object)newConfiguration);
        }
        catch (IndexDocumentConfigurationFactory.IndexDocumentConfigurationParseException e) {
            return false;
        }
    }

    @Override
    public void remove(String pluginKey) {
        Delete.from(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).whereEqual("pluginKey", pluginKey).execute(this.entityEngine);
    }

    private Option<EntityPropertyIndexDocument> getDocumentForPluginAndModule(String pluginKey, String moduleKey) {
        EntityPropertyIndexDocument entityPropertyIndexDocument = (EntityPropertyIndexDocument)Select.from(Entity.ENTITY_PROPERTY_INDEX_DOCUMENT).whereEqual("pluginKey", pluginKey).whereEqual("moduleKey", moduleKey).runWith(this.entityEngine).singleValue();
        return Option.option((Object)entityPropertyIndexDocument);
    }

    static void restrictLength(String field, String value, int maximumLength) {
        if (value.length() > maximumLength) {
            throw new IllegalArgumentException("Value of " + field + " is too long. Maximum length is " + maximumLength);
        }
    }

    public static class PluginIndexConfigurationImpl
    implements PluginIndexConfiguration {
        private final String pluginKey;
        private final String moduleKey;
        private final IndexDocumentConfiguration indexDocumentConfiguration;
        private final Timestamp lastUpdated;

        @VisibleForTesting
        public PluginIndexConfigurationImpl(String pluginKey, String moduleKey, IndexDocumentConfiguration indexDocumentConfiguration, Timestamp lastUpdated) {
            this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey);
            this.moduleKey = (String)Preconditions.checkNotNull((Object)moduleKey);
            this.indexDocumentConfiguration = (IndexDocumentConfiguration)Preconditions.checkNotNull((Object)indexDocumentConfiguration);
            this.lastUpdated = (Timestamp)Preconditions.checkNotNull((Object)lastUpdated);
        }

        @Override
        public String getPluginKey() {
            return this.pluginKey;
        }

        @Override
        public String getModuleKey() {
            return this.moduleKey;
        }

        @Override
        public IndexDocumentConfiguration getIndexDocumentConfiguration() {
            return this.indexDocumentConfiguration;
        }

        @Override
        public Timestamp getLastUpdated() {
            return this.lastUpdated;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("pluginKey", (Object)this.pluginKey).add("moduleKey", (Object)this.moduleKey).add("indexDocumentConfiguration", (Object)this.indexDocumentConfiguration).add("lastUpdated", (Object)this.lastUpdated).toString();
        }
    }
}

