/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizNodeIndexCounterStore {
    public static final String ENTITY_NAME = "NodeIndexCounter";
    public static final String VIEW_NAME = "IndexOperationMinId";
    public static final String NODE_ID = "nodeId";
    public static final String INDEX_OP_ID = "indexOperationId";
    public static final String MIN = "min";
    private final OfBizDelegator ofBizDelegator;

    public OfBizNodeIndexCounterStore(OfBizDelegator ofBizDelegator, ClusterManager clusterManager) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public void storeIndexOperationId(String nodeId, long indexOperationId) {
        List gvs = this.ofBizDelegator.findByCondition(ENTITY_NAME, (EntityCondition)new EntityExpr(NODE_ID, EntityOperator.EQUALS, (Object)nodeId), null);
        if (gvs.isEmpty()) {
            gvs.add(this.ofBizDelegator.createValue(ENTITY_NAME, (Map)ImmutableMap.of((Object)NODE_ID, (Object)nodeId, (Object)INDEX_OP_ID, (Object)indexOperationId)));
        } else {
            GenericValue gv = (GenericValue)gvs.get(0);
            gv.set(INDEX_OP_ID, (Object)indexOperationId);
            this.ofBizDelegator.store(gv);
        }
    }

    private long getStartingPoint() {
        List gvs = this.ofBizDelegator.findByCondition(VIEW_NAME, null, (Collection)ImmutableList.of((Object)MIN));
        if (gvs.isEmpty() || ((GenericValue)gvs.get(0)).getLong(MIN) == null) {
            return 0L;
        }
        return ((GenericValue)gvs.get(0)).getLong(MIN) - 1L;
    }

    public long getIndexOperationCounterForNodeId(String nodeId) {
        List gvs = this.ofBizDelegator.findByCondition(ENTITY_NAME, (EntityCondition)new EntityExpr(NODE_ID, EntityOperator.EQUALS, (Object)nodeId), null);
        if (gvs.isEmpty()) {
            return this.getStartingPoint();
        }
        return ((GenericValue)gvs.get(0)).getLong(INDEX_OP_ID);
    }
}

