/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class NullAwareIssueIdsIssueIterable
implements IssuesIterable {
    private final Collection<Long> ids;
    private final IssueManager issueManager;

    public NullAwareIssueIdsIssueIterable(Collection<Long> issueIds, IssueManager issueManager) {
        this.ids = Collections.unmodifiableCollection(new ArrayList((Collection)Assertions.notNull((String)"issueIds", issueIds)));
        this.issueManager = (IssueManager)Assertions.notNull((String)"issueManager", (Object)issueManager);
    }

    public void foreach(Consumer<Issue> sink) {
        for (Long id : this.ids) {
            MutableIssue issue = this.issueManager.getIssueObject(id);
            if (issue == null) continue;
            sink.consume((Object)issue);
        }
    }

    public int size() {
        return this.ids.size();
    }

    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    public String toString() {
        return this.getClass().getName() + " (" + this.size() + " items): " + this.ids;
    }
}

