/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.util.TempDirectoryUtil;
import com.atlassian.jira.util.ZipUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.PatternFilenameFilter;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.log4j.Logger;

public class IndexSnapshotService
extends AbstractService {
    private static final Logger LOG = Logger.getLogger(IndexSnapshotService.class);
    protected static final String SERVICE_NAME = "JIRA Index Snapshot Service";
    public static final String BACKUP_COUNT = "backupCount";
    public static final int DEFAULT_COUNT = 3;
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MMM-dd--HHmm";
    protected static final String INDEX_SNAPSHOT = "IndexSnapshot_";
    public static final String SERVICE_KEY = "indexsnapshotservice";
    private final IndexPathManager indexPathManager;
    private final JiraHome jiraHome;
    private final IndexUtils indexUtils;
    private int backupCount = 3;

    public IndexSnapshotService(IndexPathManager indexPathManager, JiraHome jiraHome, IndexUtils indexUtils) {
        this.indexPathManager = indexPathManager;
        this.jiraHome = jiraHome;
        this.indexUtils = indexUtils;
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(BACKUP_COUNT)) {
            String count = this.getProperty(BACKUP_COUNT);
            try {
                this.backupCount = Integer.parseInt(count);
                if (this.backupCount < 1) {
                    this.backupCount = 3;
                    LOG.warn((Object)"Invalid Index backup count specified in service configuration; defaulting to 3.");
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"Invalid Index backup count specified in service configuration; defaulting to 3.", (Throwable)e);
            }
        }
    }

    public String getKey() {
        return SERVICE_KEY;
    }

    public boolean isUnique() {
        return true;
    }

    public boolean isInternal() {
        return true;
    }

    public void run() {
        File workDir = null;
        try {
            workDir = TempDirectoryUtil.createTempDirectory("JIRAIndexBackup");
            this.indexUtils.copyIndexes(this.indexPathManager.getIndexRootPath(), workDir.getCanonicalPath());
            File backupDirectory = this.getSnapshotDirectory();
            if (!backupDirectory.exists()) {
                backupDirectory.mkdir();
            }
            File snapshot = new File(backupDirectory, this.createFileName());
            this.compressBackup(workDir, snapshot);
            this.deleteOldSnapshots(this.backupCount);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (workDir != null && workDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)workDir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private File getSnapshotDirectory() {
        return new File(this.jiraHome.getExportDirectory(), "indexsnapshots");
    }

    private void compressBackup(File workDir, File snapshot) throws IOException {
        ZipUtils.zip(workDir, snapshot);
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration(SERVICE_KEY, "services/com/atlassian/jira/service/services/index/indexsnapshotservice.xml", null);
    }

    private String createFileName() {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return INDEX_SNAPSHOT + format.format(new Date()) + ".zip";
    }

    @VisibleForTesting
    protected int deleteOldSnapshots(int numToKeep) {
        PatternFilenameFilter filter = new PatternFilenameFilter("IndexSnapshot_.*\\.zip");
        File[] snapshots = this.getSnapshotDirectory().listFiles((FilenameFilter)filter);
        Arrays.sort(snapshots, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
        int numKept = 0;
        int numDeleted = 0;
        for (File snapshot : snapshots) {
            if (numKept < numToKeep) {
                ++numKept;
                continue;
            }
            if (!snapshot.delete()) continue;
            ++numDeleted;
        }
        return numDeleted;
    }

    public static String getServiceName() {
        return SERVICE_NAME;
    }
}

