/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.Consumer;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

@EventComponent
public class DefaultReplicatedIndexManager
implements ReplicatedIndexManager {
    private static final Logger log = Logger.getLogger(DefaultReplicatedIndexManager.class);
    private final OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore;
    private final TaskManager taskManager;

    public DefaultReplicatedIndexManager(OfBizReplicatedIndexOperationStore ofBizReplicatedIndexOperationStore, TaskManager taskManager) {
        this.ofBizReplicatedIndexOperationStore = ofBizReplicatedIndexOperationStore;
        this.taskManager = taskManager;
    }

    @Override
    public void reindexIssues(@Nonnull IssuesIterable issuesIterable) {
        try {
            final HashSet issueIds = Sets.newHashSet();
            issuesIterable.foreach((Consumer)new Consumer<Issue>(){

                public void consume(@Nonnull Issue issue) {
                    issueIds.add(issue.getId());
                }
            });
            this.updateReplicatedIndex(issueIds, ReplicatedIndexOperation.AffectedIndex.ISSUE, ReplicatedIndexOperation.SharedEntityType.NONE, ReplicatedIndexOperation.Operation.UPDATE);
        }
        catch (Exception e) {
            log.error((Object)this.buildErrorMessage("reindexed issues"), (Throwable)e);
        }
    }

    @Override
    public void reindexComments(Collection<Comment> comments) {
        try {
            HashSet commentIds = Sets.newHashSet();
            for (Comment comment : comments) {
                commentIds.add(comment.getId());
            }
            this.updateReplicatedIndex(commentIds, ReplicatedIndexOperation.AffectedIndex.COMMENT, ReplicatedIndexOperation.SharedEntityType.NONE, ReplicatedIndexOperation.Operation.UPDATE);
        }
        catch (Exception e) {
            log.error((Object)this.buildErrorMessage("reindexed comments"));
        }
    }

    @Override
    public void deIndexIssues(Set<Issue> issuesToDelete) {
        try {
            HashSet issueIds = Sets.newHashSet();
            if (issuesToDelete != null) {
                for (Issue issue : issuesToDelete) {
                    issueIds.add(issue.getId());
                }
            }
            this.updateReplicatedIndex(issueIds, ReplicatedIndexOperation.AffectedIndex.ISSUE, ReplicatedIndexOperation.SharedEntityType.NONE, ReplicatedIndexOperation.Operation.DELETE);
        }
        catch (Exception e) {
            log.error((Object)this.buildErrorMessage("deindexed issues"), (Throwable)e);
        }
    }

    @Override
    public void indexSharedEntity(SharedEntity entity) {
        try {
            this.updateReplicatedIndex((Set<Long>)ImmutableSet.of((Object)entity.getId()), ReplicatedIndexOperation.AffectedIndex.SHAREDENTITY, ReplicatedIndexOperation.SharedEntityType.fromTypeDescriptor(entity.getEntityType()), ReplicatedIndexOperation.Operation.UPDATE);
        }
        catch (Exception e) {
            log.error((Object)this.buildErrorMessage("reindexed shared entity"), (Throwable)e);
        }
    }

    @Override
    public void deIndexSharedEntity(SharedEntity entity) {
        try {
            this.updateReplicatedIndex((Set<Long>)ImmutableSet.of((Object)entity.getId()), ReplicatedIndexOperation.AffectedIndex.SHAREDENTITY, ReplicatedIndexOperation.SharedEntityType.fromTypeDescriptor(entity.getEntityType()), ReplicatedIndexOperation.Operation.DELETE);
        }
        catch (Exception e) {
            log.error((Object)this.buildErrorMessage("deindexed shared entity"), (Throwable)e);
        }
    }

    @EventListener
    public void onReindexAllStarted(ReindexAllStartedEvent reindexAllStartedEvent) {
        if (reindexAllStartedEvent.shouldUpdateReplicatedIndex()) {
            ReplicatedIndexOperation.Operation reindex = reindexAllStartedEvent.isUsingBackgroundIndexing() ? ReplicatedIndexOperation.Operation.BACKGROUND_REINDEX_START : ReplicatedIndexOperation.Operation.FULL_REINDEX_START;
            this.ofBizReplicatedIndexOperationStore.createIndexOperation(new Timestamp(System.currentTimeMillis()), ReplicatedIndexOperation.AffectedIndex.ALL, ReplicatedIndexOperation.SharedEntityType.NONE, reindex, new HashSet<Long>());
        }
    }

    @EventListener
    public void onReindexAllCompleted(ReindexAllCompletedEvent reindexAllCompletedEvent) {
        if (reindexAllCompletedEvent.shouldUpdateReplicatedIndex()) {
            ReplicatedIndexOperation.Operation reindex = reindexAllCompletedEvent.isUsingBackgroundIndexing() ? ReplicatedIndexOperation.Operation.BACKGROUND_REINDEX_END : ReplicatedIndexOperation.Operation.FULL_REINDEX_END;
            this.ofBizReplicatedIndexOperationStore.createIndexOperation(new Timestamp(System.currentTimeMillis()), ReplicatedIndexOperation.AffectedIndex.ALL, ReplicatedIndexOperation.SharedEntityType.NONE, reindex, new HashSet<Long>());
        } else {
            TaskDescriptor taskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
            if (taskDescriptor != null && taskDescriptor.isFinished()) {
                this.taskManager.removeTask(taskDescriptor.getTaskId());
            }
        }
    }

    private void updateReplicatedIndex(Set<Long> ids, ReplicatedIndexOperation.AffectedIndex affectedIndex, ReplicatedIndexOperation.SharedEntityType entityType, ReplicatedIndexOperation.Operation operation) {
        this.ofBizReplicatedIndexOperationStore.createIndexOperation(new Timestamp(System.currentTimeMillis()), affectedIndex, entityType, operation, ids);
    }

    private String buildErrorMessage(String indexOperationInError) {
        return String.format("Caught an exception trying to replicate %s.  The replicated index may or may not be correct", indexOperationInError);
    }
}

