/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexRecoveryService;
import com.atlassian.jira.index.ha.IndexSnapshotService;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultIndexRecoveryService
implements IndexRecoveryService {
    private static final Logger LOG = Logger.getLogger(DefaultIndexRecoveryService.class);
    private final IndexRecoveryManager indexRecoveryManager;
    private final PermissionManager permissionManager;
    private final IndexPathManager indexPathManager;
    private final ServiceManager serviceManager;
    private final FileFactory fileFactory;

    public DefaultIndexRecoveryService(IndexRecoveryManager indexRecoveryManager, PermissionManager permissionManager, IndexPathManager indexPathManager, ServiceManager serviceManager, FileFactory fileFactory) {
        this.indexRecoveryManager = indexRecoveryManager;
        this.permissionManager = permissionManager;
        this.indexPathManager = indexPathManager;
        this.serviceManager = serviceManager;
        this.fileFactory = fileFactory;
    }

    @Override
    public IndexCommandResult recoverIndexFromBackup(ApplicationUser user, Context context, I18nHelper i18n, String recoveryFilename, TaskProgressSink taskProgressSink) throws IndexException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.permissionManager.hasPermission(44, user)) {
            errorCollection.addErrorMessage(i18n.getText("admin.errors.index.recovery.unauthorised"));
        }
        this.validateRecoveryFile(user, (ErrorCollection)errorCollection, i18n, recoveryFilename);
        if (errorCollection.hasAnyErrors()) {
            return new IndexCommandResult((ErrorCollection)errorCollection);
        }
        return this.indexRecoveryManager.recoverIndexFromBackup(context, i18n, recoveryFilename, taskProgressSink);
    }

    private void validateRecoveryFile(ApplicationUser user, ErrorCollection errorCollection, I18nHelper i18n, String path) {
        if (StringUtils.isBlank((String)path)) {
            errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.specified"));
        } else {
            File actualFile = this.fileFactory.getFile(path);
            if (!actualFile.exists()) {
                errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.found"));
            }
            if (actualFile.isDirectory()) {
                errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.zip"));
            } else if (!actualFile.canRead()) {
                errorCollection.addError("indexPath", i18n.getText("admin.errors.path.entered.is.not.readable"));
            } else if (!this.validIndexZipFile(user, actualFile)) {
                errorCollection.addError("recoveryFilename", i18n.getText("admin.index.recovery.file.error.not.zip"));
            }
        }
    }

    @Override
    public boolean validIndexZipFile(ApplicationUser user, File zipFile) {
        String segmentFileName = "segments.gen";
        HashMap<String, Boolean> requiredEntries = new HashMap<String, Boolean>();
        int basePathLength = this.indexPathManager.getIndexRootPath().length();
        requiredEntries.put(this.indexPathManager.getIssueIndexPath().substring(basePathLength + 1) + "/" + "segments.gen", Boolean.FALSE);
        requiredEntries.put(this.indexPathManager.getCommentIndexPath().substring(basePathLength + 1) + "/" + "segments.gen", Boolean.FALSE);
        requiredEntries.put(this.indexPathManager.getChangeHistoryIndexPath().substring(basePathLength + 1) + "/" + "segments.gen", Boolean.FALSE);
        try {
            ZipFile file = new ZipFile(zipFile.getAbsolutePath());
            Enumeration entries = file.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (!requiredEntries.containsKey(entry.getName())) continue;
                requiredEntries.put(entry.getName(), Boolean.TRUE);
            }
            for (Boolean found : requiredEntries.values()) {
                if (found.booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LOG.debug((Object)("Can't access zip file '" + zipFile.getPath() + "'"));
            return false;
        }
    }

    public int size() {
        return this.indexRecoveryManager.size();
    }

    public boolean isEmpty() {
        return this.indexRecoveryManager.isEmpty();
    }

    @Override
    public void updateRecoverySettings(ApplicationUser user, boolean recoveryEnabled, long snapshotInterval) throws Exception {
        JiraServiceContainer service = this.serviceManager.getServiceWithName(IndexSnapshotService.getServiceName());
        if (this.permissionManager.hasPermission(44, user)) {
            if (recoveryEnabled) {
                if (service == null) {
                    this.serviceManager.addService(IndexSnapshotService.getServiceName(), IndexSnapshotService.class, snapshotInterval);
                } else {
                    this.serviceManager.editService(service.getId(), snapshotInterval, Collections.emptyMap());
                }
            } else if (service != null) {
                this.serviceManager.removeService(service.getId());
            }
        }
    }

    @Override
    public boolean isRecoveryEnabled(ApplicationUser user) {
        try {
            return this.serviceManager.getServiceWithName(IndexSnapshotService.getServiceName()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Long getSnapshotInterval(ApplicationUser user) {
        try {
            JiraServiceContainer service = this.serviceManager.getServiceWithName(IndexSnapshotService.getServiceName());
            if (service != null) {
                return service.getDelay();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

