/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.index.IssueIndexHelper;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.NullAwareIssueIdsIssueIterable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ZipUtils;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Collector;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIndexRecoveryManager
implements IndexRecoveryManager {
    private static final Logger LOG = Logger.getLogger(DefaultIndexRecoveryManager.class);
    private final SearchProvider searchProvider;
    private final OfBizDelegator delegator;
    private final IssueBatcherFactory issueBatcherFactory;
    private final IssueManager issueManager;
    private final IssueIndexer issueIndexer;
    private final IndexLifecycleManager indexLifecycleManager;
    private final FileFactory fileFactory;
    private final IndexPathManager indexPathManager;
    private final IssueFactory issueFactory;
    private final SharedEntityIndexManager sharedEntityIndexManager;
    private final IndexingCounterManager indexingCounterManager;

    public DefaultIndexRecoveryManager(SearchProvider searchProvider, OfBizDelegator delegator, IssueBatcherFactory issueBatcherFactory, IssueManager issueManager, IssueIndexer issueIndexer, IndexLifecycleManager indexLifecycleManager, FileFactory fileFactory, IndexPathManager indexPathManager, IssueFactory issueFactory, SharedEntityIndexManager sharedEntityIndexManager, IndexingCounterManager indexingCounterManager) {
        this.searchProvider = searchProvider;
        this.delegator = delegator;
        this.issueBatcherFactory = issueBatcherFactory;
        this.issueManager = issueManager;
        this.issueIndexer = issueIndexer;
        this.indexLifecycleManager = indexLifecycleManager;
        this.fileFactory = fileFactory;
        this.indexPathManager = indexPathManager;
        this.issueFactory = issueFactory;
        this.sharedEntityIndexManager = sharedEntityIndexManager;
        this.indexingCounterManager = indexingCounterManager;
    }

    @Override
    public IndexCommandResult recoverIndexFromBackup(Context context, I18nHelper i18n, String recoveryFilename, TaskProgressSink taskProgressSink) throws IndexException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        LOG.info((Object)"Recovering issue index");
        long startTime = System.currentTimeMillis();
        this.indexLifecycleManager.deactivate();
        taskProgressSink.makeProgress(1L, "Restoring", "Unpacking index snapshot");
        try {
            this.replaceIndexes((ErrorCollection)errorCollection, i18n, recoveryFilename);
        }
        catch (IOException e) {
            throw new IndexException((Exception)e);
        }
        finally {
            this.indexLifecycleManager.activate(Contexts.nullContext(), false);
        }
        if (errorCollection.hasAnyErrors()) {
            return new IndexCommandResult((ErrorCollection)errorCollection);
        }
        taskProgressSink.makeProgress(20L, "Restoring", "Restored index backup");
        DateUtils.DateRange range = this.getDurationToRecover();
        try {
            this.reindexIssuesIn(range, taskProgressSink, i18n);
        }
        catch (SearchException e) {
            throw new IndexException((Exception)((Object)e));
        }
        taskProgressSink.makeProgress(80L, "Recovering", "Recovered issue index");
        this.sharedEntityIndexManager.reIndexAll(Contexts.nullContext());
        this.indexingCounterManager.incrementValue();
        taskProgressSink.makeProgress(100L, "Recovering", "Recovered all indexes");
        return new IndexCommandResult(System.currentTimeMillis() - startTime);
    }

    private void replaceIndexes(ErrorCollection errorCollection, I18nHelper i18n, String recoveryFilename) throws IOException {
        File backupFile = this.fileFactory.getFile(recoveryFilename);
        File indexDirectory = new File(this.indexPathManager.getIndexRootPath());
        FileUtils.deleteDirectory((File)new File(this.indexPathManager.getIssueIndexPath()));
        FileUtils.deleteDirectory((File)new File(this.indexPathManager.getCommentIndexPath()));
        FileUtils.deleteDirectory((File)new File(this.indexPathManager.getChangeHistoryIndexPath()));
        FileUtils.deleteDirectory((File)new File(this.indexPathManager.getSharedEntityIndexPath()));
        if (!indexDirectory.exists()) {
            indexDirectory.mkdir();
        }
        ZipUtils.unzip(backupFile, indexDirectory);
    }

    private DateUtils.DateRange getDurationToRecover() {
        Date latestIndexDate = this.getLatestIndexDate(null);
        Date latestDbDate = this.getLatestDbDate();
        if (latestDbDate.after(latestIndexDate)) {
            latestDbDate = DateUtils.addMinutes((Date)latestDbDate, (int)1);
            latestIndexDate = DateUtils.addMinutes((Date)latestIndexDate, (int)-1);
        } else {
            latestIndexDate = DateUtils.addMinutes((Date)latestIndexDate, (int)1);
            latestDbDate = DateUtils.addMinutes((Date)latestDbDate, (int)-1);
        }
        return new DateUtils.DateRange(latestIndexDate, latestDbDate);
    }

    private void reindexIssuesIn(DateUtils.DateRange range, TaskProgressSink taskProgressSink, I18nHelper i18n) throws IndexException, SearchException {
        if (range.startDate.before(range.endDate)) {
            try {
                this.reindexUsingDatabaseLatest(range);
            }
            catch (GenericEntityException e) {
                throw new RuntimeException(e);
            }
        } else if (range.startDate.after(range.endDate)) {
            this.reindexUsingLucene(range, null, i18n);
        }
        taskProgressSink.makeProgress(60L, "Recovering", "Recovered added and updated issues");
        this.deIndexDeletedIssues(taskProgressSink, i18n);
        taskProgressSink.makeProgress(80L, "Recovering", "Cleaned removed issues");
    }

    private void reindexUsingDatabaseLatest(DateUtils.DateRange range) throws IndexException, GenericEntityException {
        EntityExpr ge = new EntityExpr("updated", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)new Timestamp(range.startDate.getTime()));
        EntityExpr le = new EntityExpr("updated", EntityOperator.LESS_THAN_EQUAL_TO, (Object)new Timestamp(range.endDate.getTime()));
        EntityConditionList condition = new EntityConditionList(Arrays.asList(ge, le), EntityOperator.AND);
        Context context = Contexts.nullContext();
        IssuesBatcher batches = this.issueBatcherFactory.getBatcher((EntityCondition)condition);
        for (IssuesIterable batch : batches) {
            this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batch, context, true, true, false);
        }
    }

    private void reindexUsingLucene(DateUtils.DateRange range, ApplicationUser user, I18nHelper i18n) throws SearchException, IndexException {
        FieldHitCollector collector = new FieldHitCollector("issue_id");
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.where().addDateRangeCondition("updated", range.endDate, range.startDate);
        this.searchProvider.searchOverrideSecurity(queryBuilder.buildQuery(), user, (Collector)collector);
        List issueIds = Lists.transform(collector.getValues(), (Function)new Function<String, Long>(){

            public Long apply(@Nullable String input) {
                return Long.valueOf(input);
            }
        });
        NullAwareIssueIdsIssueIterable batch = new NullAwareIssueIdsIssueIterable(issueIds, this.issueManager);
        this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batch, Contexts.nullContext(), true, true, false);
    }

    private void deIndexDeletedIssues(TaskProgressSink taskProgressSink, I18nHelper i18n) throws SearchException {
        long[] indexedIssues = new IssueIndexHelper(this.issueManager, this.issueIndexer, this.issueFactory).getAllIssueIds();
        HashSet indexIssueIds = Sets.newHashSetWithExpectedSize((int)indexedIssues.length);
        for (long id : indexedIssues) {
            indexIssueIds.add(id);
        }
        OfBizListIterator issuesIterator = this.delegator.findListIteratorByCondition("Issue", null, null, Arrays.asList("id"), null, null);
        for (GenericValue value : issuesIterator) {
            indexIssueIds.remove(value.getLong("id"));
        }
        for (Long id : indexIssueIds) {
            GenericValue gv = this.delegator.makeValue("Issue", (Map)new FieldMap("id", (Object)id));
            MutableIssue deletedIssue = this.issueFactory.getIssue(gv);
            IssueObjectIssuesIterable issues = new IssueObjectIssuesIterable(Collections.singletonList(deletedIssue));
            this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)issues, Contexts.nullContext());
        }
    }

    private Date getLatestIndexDate(ApplicationUser user) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.orderBy().updatedDate(SortOrder.DESC);
        try {
            PagerFilter filter = new PagerFilter(0, 1);
            List issues = this.searchProvider.searchOverrideSecurity(queryBuilder.buildQuery(), user, filter, null).getIssues();
            if (issues.size() > 0) {
                return ((Issue)issues.get(0)).getUpdated();
            }
        }
        catch (SearchException e) {
            LOG.error((Object)"Error searching for issues", (Throwable)e);
        }
        return null;
    }

    private Date getLatestDbDate() {
        OfBizListIterator iterator = this.delegator.findListIteratorByCondition("Issue", null, null, null, Arrays.asList("updated DESC"), EntityFindOptions.findOptions().maxResults(1));
        Iterator i$ = iterator.iterator();
        if (i$.hasNext()) {
            GenericValue genericValue = (GenericValue)i$.next();
            return genericValue.getTimestamp("updated");
        }
        return null;
    }

    public int size() {
        return 100;
    }

    public boolean isEmpty() {
        return false;
    }
}

