/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.AtomicSupplier;
import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.FutureResult;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.RuntimeInterruptedException;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;

class QueueingIndex
implements CloseableIndex {
    private final BlockingQueue<FutureOperation> queue = new LinkedBlockingQueue<FutureOperation>();
    private final Task task = new Task(this.queue);
    private final AtomicSupplier<Thread> indexerThread = new AtomicSupplier<Thread>(){

        @Override
        protected Thread create() {
            Thread thread = QueueingIndex.this.threadFactory.newThread(QueueingIndex.this.task);
            thread.start();
            return thread;
        }
    };
    private final CloseableIndex delegate;
    private final ThreadFactory threadFactory;

    QueueingIndex(@Nonnull String name, @Nonnull CloseableIndex delegate, long maxQueueSize) {
        this(ThreadFactories.namedThreadFactory((String)Assertions.notNull((String)"name", (Object)name) + "-indexQueue"), delegate, maxQueueSize);
    }

    QueueingIndex(@Nonnull ThreadFactory threadFactory, @Nonnull CloseableIndex delegate, long maxQueueSize) {
        this.threadFactory = (ThreadFactory)Assertions.notNull((String)"threadFactory", (Object)threadFactory);
        this.delegate = (CloseableIndex)Assertions.notNull((String)"delegate", (Object)delegate);
    }

    @Override
    public Index.Result perform(@Nonnull Index.Operation operation) {
        FutureOperation future = new FutureOperation(operation);
        try {
            this.queue.put(future);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        this.check();
        return new FutureResult((Future<Index.Result>)((Object)future));
    }

    @Override
    public void close() {
        Thread thread = this.indexerThread.get();
        try {
            while (thread.isAlive()) {
                thread.interrupt();
                thread.join(100L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        finally {
            this.indexerThread.compareAndSetNull(thread);
            this.delegate.close();
        }
    }

    private void check() {
        Thread thread;
        while (!(thread = this.indexerThread.get()).isAlive()) {
            this.indexerThread.compareAndSetNull(thread);
        }
    }

    static class CompositeOperation
    extends Index.Operation {
        private final List<FutureOperation> operations;

        CompositeOperation(List<FutureOperation> operations) {
            this.operations = Collections.unmodifiableList(operations);
        }

        public void set(Index.Result result) {
            for (FutureOperation future : this.operations) {
                future.set(result);
            }
        }

        @Override
        void perform(Writer writer) throws IOException {
            for (FutureOperation future : this.operations) {
                future.operation.perform(writer);
            }
        }

        @Override
        Index.UpdateMode mode() {
            for (FutureOperation future : this.operations) {
                if (future.mode() != Index.UpdateMode.BATCH) continue;
                return Index.UpdateMode.BATCH;
            }
            return Index.UpdateMode.INTERACTIVE;
        }
    }

    static class FutureOperation
    extends SettableFuture<Index.Result> {
        private final Index.Operation operation;

        FutureOperation(Index.Operation operation) {
            this.operation = (Index.Operation)Assertions.notNull((String)"operation", (Object)operation);
        }

        Index.UpdateMode mode() {
            return this.operation.mode();
        }
    }

    class Task
    implements Runnable {
        private final BlockingQueue<FutureOperation> queue;

        Task(BlockingQueue<FutureOperation> queue) {
            this.queue = (BlockingQueue)Assertions.notNull((String)"queue", queue);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    this.index();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        void index() throws InterruptedException {
            ArrayList<FutureOperation> list = new ArrayList<FutureOperation>();
            list.add(this.queue.take());
            this.queue.drainTo(list);
            CompositeOperation operation = new CompositeOperation(list);
            operation.set(QueueingIndex.this.delegate.perform(operation));
        }
    }
}

