/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.BackgroundIndexListener;
import com.atlassian.jira.issue.index.IndexReconciler;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.util.IssueIdsIssueIterable;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.collect.EnclosedIterable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;

public class IssueIndexHelper {
    private static final Logger log = Logger.getLogger(IssueIndexHelper.class);
    private final IndexReader indexReader;
    private final IssueManager issueManager;
    private final IssueIndexer issueIndexer;
    private final IndexSearcher issueSearcher;
    private final IssueFactory issueFactory;

    public IssueIndexHelper(IssueManager issueManager, IssueIndexer issueIndexer, IssueFactory issueFactory) {
        this.issueManager = issueManager;
        this.issueIndexer = issueIndexer;
        this.issueFactory = issueFactory;
        this.issueSearcher = this.issueIndexer.getIssueSearcher();
        this.indexReader = this.issueSearcher.getIndexReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getAllIssueIds() {
        long[] issueIds = new long[this.indexReader.numDocs()];
        int i = 0;
        try {
            TermEnum termEnum = null;
            termEnum = this.indexReader.terms(new Term("issue_id", ""));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != "issue_id") {
                    } else {
                        String issueId = term.text();
                        issueIds = this.ensureCapacity(issueIds, i);
                        issueIds[i] = Long.parseLong(issueId);
                        ++i;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            finally {
                termEnum.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return issueIds;
    }

    private long[] ensureCapacity(long[] issueIds, int i) {
        if (issueIds.length <= i) {
            int newSize = Math.max(i, issueIds.length + issueIds.length / 10);
            return Arrays.copyOf(issueIds, newSize);
        }
        return issueIds;
    }

    public void fixupConcurrentlyIndexedIssues(Context context, AccumulatingResultBuilder resultBuilder, BackgroundIndexListener backgroundIndexListener, boolean reIndexComments, boolean reIndexChangeHistory) {
        IssueIdsIssueIterable issueIterable = new IssueIdsIssueIterable(backgroundIndexListener.getUpdatedIssues(), this.issueManager);
        resultBuilder.add(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issueIterable, context, reIndexComments, reIndexChangeHistory, true));
        resultBuilder.toResult().await();
        this.safelyRemoveOrphans(resultBuilder, backgroundIndexListener.getDeletedIssues());
        resultBuilder.toResult().await();
    }

    public void fixupIndexCorruptions(AccumulatingResultBuilder resultBuilder, IndexReconciler reconciler) {
        this.safelyAddMissing(resultBuilder, reconciler.getUnindexed());
        resultBuilder.toResult().await();
        log.debug((Object)("" + reconciler.getUnindexed().size() + " missing issues add to the index."));
        this.safelyRemoveOrphans(resultBuilder, reconciler.getOrphans());
        resultBuilder.toResult().await();
        log.debug((Object)("" + reconciler.getOrphans().size() + " deleted issues removed from the index."));
    }

    public void safelyAddMissing(AccumulatingResultBuilder resultBuilder, Collection<Long> unindexed) {
        for (Long issueId : unindexed) {
            try {
                MutableIssue issue = this.issueManager.getIssueObject(issueId);
                if (issue == null) continue;
                TermQuery query = new TermQuery(new Term("issue_id", String.valueOf(issueId)));
                TopDocs topDocs = this.issueSearcher.search((Query)query, 1);
                if (topDocs.totalHits != 0) continue;
                IssueObjectIssuesIterable issues = new IssueObjectIssuesIterable(Collections.singletonList(issue));
                resultBuilder.add(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issues, Contexts.nullContext(), true, true, false));
            }
            catch (IOException e) {
                resultBuilder.add(new DefaultIndex.Failure(e));
            }
        }
    }

    public void safelyRemoveOrphans(AccumulatingResultBuilder resultBuilder, Collection<Long> orphans) {
        for (Long issueId : orphans) {
            try {
                MutableIssue issue = this.issueManager.getIssueObject(issueId);
                if (issue != null) continue;
                TermQuery query = new TermQuery(new Term("issue_id", String.valueOf(issueId)));
                TopDocs topDocs = this.issueSearcher.search((Query)query, 1);
                for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                    Document doc = this.issueSearcher.doc(scoreDoc.doc);
                    Issue issueToDelete = this.issueFactory.getIssue(doc);
                    IssueObjectIssuesIterable issues = new IssueObjectIssuesIterable(Collections.singletonList(issueToDelete));
                    resultBuilder.add(this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)issues, Contexts.nullContext()));
                }
            }
            catch (IOException e) {
                resultBuilder.add(new DefaultIndex.Failure(e));
            }
        }
    }
}

