/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;

public class IndexDocumentConfigurationFactory {
    public static final String INDEX_DOCUMENT_CONFIGURATION_ROOT = "index-document-configuration";
    public static final String INDEX_DOCUMENT_KEY_ELEMENT = "key";
    public static final String INDEX_DOCUMENT_ENTITY_KEY_ATTRIBUTE = "entity-key";
    public static final String INDEX_DOCUMENT_KEY_PROPERTY_KEY_ATTRIBUTE = "property-key";
    public static final String INDEX_DOCUMENT_EXTRACT_ELEMENT = "extract";
    public static final String INDEX_DOCUMENT_EXTRACT_PATH_ATTRIBUTE = "path";
    public static final String INDEX_DOCUMENT_EXTRACT_TYPE_ATTRIBUTE = "type";

    public IndexDocumentConfiguration fromXML(String element) throws IndexDocumentConfigurationParseException {
        try {
            return this.fromXML(DocumentHelper.parseText((String)element).getRootElement());
        }
        catch (DocumentException e) {
            throw new IndexDocumentConfigurationParseException("Cannot parse document ", e);
        }
    }

    public IndexDocumentConfiguration fromXML(Element element) throws IndexDocumentConfigurationParseException {
        if (!INDEX_DOCUMENT_CONFIGURATION_ROOT.equals(element.getName())) {
            throw new IndexDocumentConfigurationParseException(MessageFormat.format("Root element for configuration should be {0}", INDEX_DOCUMENT_CONFIGURATION_ROOT));
        }
        String entityKey = IndexDocumentConfigurationFactory.getRequiredAttribute(element, INDEX_DOCUMENT_CONFIGURATION_ROOT, INDEX_DOCUMENT_ENTITY_KEY_ATTRIBUTE);
        return new IndexDocumentConfiguration(entityKey, IndexDocumentConfigurationFactory.transformRequiredElements(element, INDEX_DOCUMENT_KEY_ELEMENT, new Function<Element, Either<IndexDocumentConfiguration.KeyConfiguration, IndexDocumentConfigurationParseException>>(){

            public Either<IndexDocumentConfiguration.KeyConfiguration, IndexDocumentConfigurationParseException> apply(Element input) {
                return IndexDocumentConfigurationFactory.keyConfigurationFromXml(input);
            }
        }));
    }

    public String toXML(IndexDocumentConfiguration indexDocumentConfiguration) {
        DOMDocument document = new DOMDocument();
        DOMElement configurationElement = new DOMElement(INDEX_DOCUMENT_CONFIGURATION_ROOT);
        configurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_ENTITY_KEY_ATTRIBUTE), indexDocumentConfiguration.getEntityKey()));
        document.setRootElement((Element)configurationElement);
        for (IndexDocumentConfiguration.KeyConfiguration keyConfiguration : indexDocumentConfiguration.getKeyConfigurations()) {
            DOMElement keyConfigurationElement = new DOMElement(INDEX_DOCUMENT_KEY_ELEMENT);
            keyConfigurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_KEY_PROPERTY_KEY_ATTRIBUTE), keyConfiguration.getPropertyKey()));
            for (IndexDocumentConfiguration.ExtractConfiguration extractConfiguration : keyConfiguration.getExtractorConfigurations()) {
                DOMElement extractConfigurationElement = new DOMElement(INDEX_DOCUMENT_EXTRACT_ELEMENT);
                extractConfigurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_EXTRACT_PATH_ATTRIBUTE), extractConfiguration.getPath()));
                extractConfigurationElement.add((Attribute)new DOMAttribute(QName.get((String)INDEX_DOCUMENT_EXTRACT_TYPE_ATTRIBUTE), extractConfiguration.getType().name()));
                keyConfigurationElement.add((Element)extractConfigurationElement);
            }
            configurationElement.add((Element)keyConfigurationElement);
        }
        return document.asXML();
    }

    private static Either<IndexDocumentConfiguration.KeyConfiguration, IndexDocumentConfigurationParseException> keyConfigurationFromXml(Element keyElement) {
        assert (INDEX_DOCUMENT_KEY_ELEMENT.equals(keyElement.getName())) : "Unexpected name for element " + keyElement.getName();
        try {
            String propertyKey = IndexDocumentConfigurationFactory.getRequiredAttribute(keyElement, INDEX_DOCUMENT_KEY_ELEMENT, INDEX_DOCUMENT_KEY_PROPERTY_KEY_ATTRIBUTE);
            return Either.left((Object)new IndexDocumentConfiguration.KeyConfiguration(propertyKey, IndexDocumentConfigurationFactory.transformRequiredElements(keyElement, INDEX_DOCUMENT_EXTRACT_ELEMENT, new Function<Element, Either<IndexDocumentConfiguration.ExtractConfiguration, IndexDocumentConfigurationParseException>>(){

                public Either<IndexDocumentConfiguration.ExtractConfiguration, IndexDocumentConfigurationParseException> apply(Element input) {
                    return IndexDocumentConfigurationFactory.extractConfigurationFromXML(input);
                }
            })));
        }
        catch (IndexDocumentConfigurationParseException e) {
            return Either.right((Object)e);
        }
    }

    private static Either<IndexDocumentConfiguration.ExtractConfiguration, IndexDocumentConfigurationParseException> extractConfigurationFromXML(Element extractElement) {
        assert (INDEX_DOCUMENT_EXTRACT_ELEMENT.equals(extractElement.getName())) : "Unexpected name for element " + extractElement.getName();
        try {
            String path = IndexDocumentConfigurationFactory.getRequiredAttribute(extractElement, INDEX_DOCUMENT_EXTRACT_ELEMENT, INDEX_DOCUMENT_EXTRACT_PATH_ATTRIBUTE);
            String typeStr = IndexDocumentConfigurationFactory.getRequiredAttribute(extractElement, INDEX_DOCUMENT_EXTRACT_ELEMENT, INDEX_DOCUMENT_EXTRACT_TYPE_ATTRIBUTE);
            Option type = IndexDocumentConfiguration.Type.getValue((String)typeStr);
            if (type.isEmpty()) {
                return Either.right((Object)new IndexDocumentConfigurationParseException(MessageFormat.format("Illegal value {0} for type argument expected one of {1}", typeStr, Arrays.toString(IndexDocumentConfiguration.Type.values()))));
            }
            return Either.left((Object)new IndexDocumentConfiguration.ExtractConfiguration(path, (IndexDocumentConfiguration.Type)type.get()));
        }
        catch (IndexDocumentConfigurationParseException e) {
            return Either.right((Object)e);
        }
    }

    private static String getRequiredAttribute(Element element, String elementName, String attributeName) throws IndexDocumentConfigurationParseException {
        Attribute entityKeyAttribute = element.attribute(attributeName);
        if (entityKeyAttribute == null) {
            throw new IndexDocumentConfigurationParseException(MessageFormat.format("Element {0} must have attribute {1} deffined", elementName, attributeName));
        }
        return entityKeyAttribute.getValue();
    }

    private static <T> List<T> transformRequiredElements(Element element, String elementName, Function<Element, Either<T, IndexDocumentConfigurationParseException>> function) throws IndexDocumentConfigurationParseException {
        List childElements = element.elements(elementName);
        if (childElements.size() < 1) {
            throw new IndexDocumentConfigurationParseException(MessageFormat.format("Expected at least one {0} element", elementName));
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Element childElement : childElements) {
            Either output = (Either)function.apply((Object)childElement);
            if (output.isLeft()) {
                listBuilder.add(output.left().get());
                continue;
            }
            throw (IndexDocumentConfigurationParseException)output.right().get();
        }
        return listBuilder.build();
    }

    public static class IndexDocumentConfigurationParseException
    extends Exception {
        private IndexDocumentConfigurationParseException(String message) {
            super(message);
        }

        public IndexDocumentConfigurationParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

