/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.EntitySearchExtractor;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class DefaultSearchExtractorRegistrationManager
implements SearchExtractorRegistrationManager {
    private final Logger LOG = Logger.getLogger(DefaultSearchExtractorRegistrationManager.class);
    private final ConcurrentMap<Class<?>, ImmutableSet<EntitySearchExtractor<?>>> extractors = Maps.newConcurrentMap();
    private final Cache<Class<?>, Lock> locks = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Lock>(){

        public Lock load(Class<?> key) throws Exception {
            return new ReentrantLock();
        }
    });

    @Override
    public <T> Collection<EntitySearchExtractor<T>> findExtractorsForEntity(Class<T> entityClass) {
        Preconditions.checkNotNull(entityClass, (Object)"entityClass parameter cannot be null");
        if (this.extractors.containsKey(entityClass)) {
            return (Collection)this.extractors.get(entityClass);
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void register(EntitySearchExtractor<? super T> extractor, Class<T> entityClass) {
        Preconditions.checkNotNull(extractor, (Object)"extractor parameter cannot be null");
        Preconditions.checkNotNull(entityClass, (Object)"entityClass parameter cannot be null");
        Lock lock = this.tryLock(entityClass);
        try {
            Set entitySearchExtractors = (Set)this.extractors.get(entityClass);
            this.extractors.put(entityClass, entitySearchExtractors == null ? ImmutableSet.of(extractor) : ImmutableSet.builder().addAll((Iterable)entitySearchExtractors).add(extractor).build());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void unregister(final EntitySearchExtractor<? super T> extractor, Class<T> entityClass) {
        Preconditions.checkNotNull(extractor, (Object)"extractor parameter cannot be null");
        Preconditions.checkNotNull(entityClass, (Object)"entityClass parameter cannot be null");
        Lock lock = this.tryLock(entityClass);
        try {
            ImmutableSet entitySearchExtractors = (ImmutableSet)this.extractors.get(entityClass);
            if (entitySearchExtractors == null || !entitySearchExtractors.contains(extractor)) {
                return;
            }
            this.extractors.put(entityClass, ImmutableSet.copyOf((Collection)Sets.filter((Set)entitySearchExtractors, (Predicate)new Predicate<EntitySearchExtractor<?>>(){

                public boolean apply(EntitySearchExtractor<?> input) {
                    return input != extractor && !input.equals((Object)extractor);
                }
            })));
        }
        finally {
            lock.unlock();
        }
    }

    private <T> Lock tryLock(Class<T> entityClass) {
        Lock lock = (Lock)this.locks.getUnchecked(entityClass);
        try {
            if (lock.tryLock(30L, TimeUnit.SECONDS)) {
                return lock;
            }
            this.LOG.error((Object)"Could not obtain lock for DefaultSearchExtractorRegistrationManager");
            throw new LockNotAcquiredException("Could not obtain lock for DefaultSearchExtractorRegistrationManager");
        }
        catch (InterruptedException e) {
            this.LOG.error((Object)"Could not obtain lock for DefaultSearchExtractorRegistrationManager");
            throw new LockNotAcquiredException("Could not obtain lock for DefaultSearchExtractorRegistrationManager", e);
        }
    }

    private static class LockNotAcquiredException
    extends RuntimeException {
        private LockNotAcquiredException(String message) {
            super(message);
        }

        private LockNotAcquiredException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

