/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.external.beans.ExternalWorklog;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.WorklogTransformer;
import org.apache.log4j.Logger;

public class WorklogTransformerImpl
implements WorklogTransformer {
    private static final Logger log = Logger.getLogger(WorklogTransformerImpl.class);

    @Override
    public ExternalWorklog transform(ProjectImportMapper projectImportMapper, ExternalWorklog oldWorklog) {
        ExternalWorklog newWorklog = new ExternalWorklog();
        newWorklog.setComment(oldWorklog.getComment());
        newWorklog.setGroupLevel(oldWorklog.getGroupLevel());
        newWorklog.setCreated(oldWorklog.getCreated());
        newWorklog.setUpdated(oldWorklog.getUpdated());
        newWorklog.setStartDate(oldWorklog.getStartDate());
        newWorklog.setTimeSpent(oldWorklog.getTimeSpent());
        String newUpdateAuthor = projectImportMapper.getUserMapper().getMappedUserKey(oldWorklog.getUpdateAuthor());
        String newAuthor = projectImportMapper.getUserMapper().getMappedUserKey(oldWorklog.getAuthor());
        newWorklog.setUpdateAuthor(newUpdateAuthor);
        newWorklog.setAuthor(newAuthor);
        String mappedIssueId = projectImportMapper.getIssueMapper().getMappedId(oldWorklog.getIssueId());
        newWorklog.setIssueId(mappedIssueId);
        String oldRoleLevel = oldWorklog.getRoleLevelId() == null ? null : oldWorklog.getRoleLevelId().toString();
        String newRoleLevelIdAsString = projectImportMapper.getProjectRoleMapper().getMappedId(oldRoleLevel);
        if (newRoleLevelIdAsString != null) {
            newWorklog.setRoleLevelId(new Long(newRoleLevelIdAsString));
        } else if (oldRoleLevel != null) {
            log.warn((Object)("Dropping the project role visibility level with id '" + oldRoleLevel + "' for a worklog against issue with id '" + mappedIssueId + "' as JIRA is unable to resolve the project role in the backup data."));
        }
        return newWorklog;
    }
}

