/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalEntityProperty;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.EntityPropertyParser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.google.common.collect.ImmutableMap;
import java.sql.Timestamp;
import java.util.Map;

public class EntityPropertyParserImpl
implements EntityPropertyParser {
    private Function<String, Long> toLong() {
        return new Function<String, Long>(){

            public Long get(String input) {
                return Long.valueOf(input);
            }
        };
    }

    private Function<String, Timestamp> toTimestamp() {
        return new Function<String, Timestamp>(){

            public Timestamp get(String input) {
                return Timestamp.valueOf(input);
            }
        };
    }

    @Override
    public ExternalEntityProperty parse(Map<String, String> attributes) throws ParseException {
        Long id = this.verifyRequiredAttribute(attributes, "id", this.toLong());
        Long entityId = this.verifyRequiredAttribute(attributes, "entityId", this.toLong());
        String key = (String)this.verifyRequiredAttribute(attributes, "propertyKey", Functions.identity());
        Timestamp updated = this.verifyRequiredAttribute(attributes, "updated", this.toTimestamp());
        Timestamp created = this.verifyRequiredAttribute(attributes, "created", this.toTimestamp());
        String value = (String)this.verifyRequiredAttribute(attributes, "value", Functions.identity());
        String entityName = (String)this.verifyRequiredAttribute(attributes, "entityName", Functions.identity());
        return new ExternalEntityProperty(id, entityName, entityId, key, value, created, updated);
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalEntityProperty entityProperty, Long newEntityId) {
        ImmutableMap.Builder attrBuilder = ImmutableMap.builder();
        attrBuilder.put((Object)"id", (Object)entityProperty.getId().toString());
        attrBuilder.put((Object)"entityName", (Object)entityProperty.getEntityName());
        attrBuilder.put((Object)"entityId", (Object)newEntityId.toString());
        attrBuilder.put((Object)"propertyKey", (Object)entityProperty.getKey());
        attrBuilder.put((Object)"value", (Object)entityProperty.getValue());
        attrBuilder.put((Object)"created", (Object)entityProperty.getCreated().toString());
        attrBuilder.put((Object)"updated", (Object)entityProperty.getUpdated().toString());
        return new EntityRepresentationImpl("EntityProperty", (Map<String, String>)attrBuilder.build());
    }

    private <T> T verifyRequiredAttribute(Map<String, String> attributes, String key, Function<String, T> transform) throws ParseException {
        String id = attributes.get("id");
        String string = id = id == null ? "" : " '" + id + "'";
        if (!attributes.containsKey(key)) {
            throw new ParseException("The " + key + " of " + "entityName" + id + " is missing ");
        }
        try {
            return (T)transform.get((Object)attributes.get(key));
        }
        catch (NumberFormatException e) {
            throw new ParseException("The " + key + " of " + "entityName" + id + " has invalid value " + attributes.get(key));
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("The " + key + " of " + "entityName" + id + " has invalid value " + attributes.get(key));
        }
    }
}

