/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeGroup;
import com.atlassian.jira.external.beans.ExternalChangeItem;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalEntityProperty;
import com.atlassian.jira.external.beans.ExternalLink;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.external.beans.ExternalVoter;
import com.atlassian.jira.external.beans.ExternalWatcher;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.AbstractImportPartitionHandler;
import com.atlassian.jira.imports.project.parser.ChangeGroupParser;
import com.atlassian.jira.imports.project.parser.ChangeGroupParserImpl;
import com.atlassian.jira.imports.project.parser.ChangeItemParser;
import com.atlassian.jira.imports.project.parser.ChangeItemParserImpl;
import com.atlassian.jira.imports.project.parser.CommentParser;
import com.atlassian.jira.imports.project.parser.CommentParserImpl;
import com.atlassian.jira.imports.project.parser.EntityPropertyParser;
import com.atlassian.jira.imports.project.parser.EntityPropertyParserImpl;
import com.atlassian.jira.imports.project.parser.IssueLinkParser;
import com.atlassian.jira.imports.project.parser.IssueLinkParserImpl;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import com.atlassian.jira.imports.project.parser.UserAssociationParser;
import com.atlassian.jira.imports.project.parser.UserAssociationParserImpl;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.model.ModelEntity;

public class IssueRelatedEntitiesPartionHandler
extends AbstractImportPartitionHandler {
    private final BackupProject backupProject;
    private final Map<String, ModelEntity> modelEntityMap;
    private final PrintWriter printWriter;
    private final PrintWriter secondDegreeEntityXmlWriter;
    private final Set<Long> changeGroupIds;
    private final Set<Long> commentIds;
    private ChangeGroupParser changeGroupParser;
    private ChangeItemParser changeItemParser;
    private UserAssociationParser userAssociationParser;
    private EntityPropertyParser entityPropertyParser;
    private NodeAssociationParser nodeAssocationParser;
    private IssueLinkParser issueLinkParser;
    private CommentParser commentParser;
    private int entityCount = 0;
    private int secondDegreeEntityCount = 0;

    public IssueRelatedEntitiesPartionHandler(BackupProject backupProject, PrintWriter printWriter, PrintWriter secondDegreeEntityXmlWriter, List modelEntities, String encoding, DelegatorInterface delegatorInterface) {
        super(printWriter, encoding, delegatorInterface);
        this.backupProject = backupProject;
        this.printWriter = printWriter;
        this.secondDegreeEntityXmlWriter = secondDegreeEntityXmlWriter;
        this.modelEntityMap = new HashMap<String, ModelEntity>();
        this.changeGroupIds = new HashSet<Long>();
        this.commentIds = new HashSet<Long>();
        this.buildModelEntityMap(modelEntities);
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        boolean saveEntity;
        ModelEntity modelEntity = this.modelEntityMap.get(entityName);
        if (modelEntity == null) {
            return;
        }
        if ("NodeAssociation".equals(entityName)) {
            saveEntity = this.handleNodeAssociation(attributes);
        } else if ("IssueLink".equals(entityName)) {
            saveEntity = this.handleIssueLink(attributes);
        } else if ("ChangeItem".equals(entityName)) {
            saveEntity = false;
            if (this.handleChangeItem(attributes)) {
                this.saveSecondDegreeEntity(modelEntity, attributes);
            }
        } else if ("UserAssociation".equals(entityName)) {
            saveEntity = this.handleVotersAndWatchers(attributes);
        } else if ("EntityProperty".equals(entityName)) {
            saveEntity = this.handleEntityProperty(modelEntity, attributes);
        } else {
            String issueId = attributes.get("issue");
            saveEntity = this.backupProject.containsIssue(issueId);
        }
        if (saveEntity) {
            this.handleChangeGroup(entityName, attributes);
            this.handleComment(entityName, attributes);
            GenericEntity genericEntity = new GenericEntity(this.delegator, modelEntity, attributes);
            genericEntity.writeXmlText(this.printWriter, null);
            ++this.entityCount;
        }
    }

    private void saveSecondDegreeEntity(ModelEntity modelEntity, Map<String, String> attributes) {
        GenericEntity genericEntity = new GenericEntity(this.delegator, modelEntity, attributes);
        genericEntity.writeXmlText(this.secondDegreeEntityXmlWriter, null);
        ++this.secondDegreeEntityCount;
    }

    private boolean handleEntityProperty(ModelEntity modelEntity, Map<String, String> attributes) throws ParseException {
        ExternalEntityProperty entityProperty = this.getEntityPropertyParser().parse(attributes);
        if (EntityPropertyType.ISSUE_PROPERTY.getDbEntityName().equals(entityProperty.getEntityName())) {
            return this.backupProject.containsIssue(String.valueOf(entityProperty.getEntityId()));
        }
        if (EntityPropertyType.COMMENT_PROPERTY.getDbEntityName().equals(entityProperty.getEntityName()) && this.commentIds.contains(entityProperty.getEntityId())) {
            this.saveSecondDegreeEntity(modelEntity, attributes);
            return false;
        }
        return false;
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    public int getSecondDegreeEntityCount() {
        return this.secondDegreeEntityCount;
    }

    private boolean handleVotersAndWatchers(Map<String, String> attributes) throws ParseException {
        ExternalVoter externalVoter = this.getUserAssociationParser().parseVoter(attributes);
        if (externalVoter != null) {
            return this.backupProject.containsIssue(externalVoter.getIssueId());
        }
        ExternalWatcher externalWatcher = this.getUserAssociationParser().parseWatcher(attributes);
        if (externalWatcher != null) {
            return this.backupProject.containsIssue(externalWatcher.getIssueId());
        }
        return false;
    }

    private boolean handleChangeItem(Map<String, String> attributes) throws ParseException {
        ExternalChangeItem externalChangeItem = this.getChangeItemParser().parse(attributes);
        try {
            Long groupId = new Long(externalChangeItem.getChangeGroupId());
            return this.changeGroupIds.contains(groupId);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Unable to parse the changeGroup id'" + externalChangeItem.getChangeGroupId() + "' for change item.");
        }
    }

    @Override
    public void startDocument() {
        super.startDocument();
        if (this.secondDegreeEntityXmlWriter != null) {
            this.secondDegreeEntityXmlWriter.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
            this.secondDegreeEntityXmlWriter.println("<entity-engine-xml>");
        }
    }

    @Override
    public void endDocument() {
        super.endDocument();
        if (this.secondDegreeEntityXmlWriter != null) {
            this.secondDegreeEntityXmlWriter.print("</entity-engine-xml>");
        }
    }

    public Map<String, ModelEntity> getRegisteredHandlers() {
        return Collections.unmodifiableMap(this.modelEntityMap);
    }

    private void handleComment(String entityName, Map<String, String> attributes) throws ParseException {
        if ("Action".equals(entityName)) {
            ExternalComment externalComment = this.getCommentParser().parse(attributes);
            String externalCommentId = externalComment.getId();
            if (externalCommentId != null) {
                try {
                    Long id = new Long(externalCommentId);
                    this.commentIds.add(id);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Unable to parse the id for changeGroup '" + externalCommentId + "'");
                }
            } else {
                throw new ParseException("Encountered a Comment entry without an id, this should not happen");
            }
        }
    }

    private void handleChangeGroup(String entityName, Map<String, String> attributes) throws ParseException {
        if ("ChangeGroup".equals(entityName)) {
            ExternalChangeGroup externalChangeGroup = this.getChangeGroupParser().parse(attributes);
            String idStr = externalChangeGroup.getId();
            if (idStr != null) {
                try {
                    Long id = new Long(idStr);
                    this.changeGroupIds.add(id);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Unable to parse the id for changeGroup '" + idStr + "'");
                }
            } else {
                throw new ParseException("Encountered a ChangeGroup entry without an id, this should not happen.");
            }
        }
    }

    private boolean handleIssueLink(Map<String, String> attributes) throws ParseException {
        ExternalLink externalLink = this.getIssueLinkParser().parse(attributes);
        return this.backupProject.containsIssue(externalLink.getSourceId()) || this.backupProject.containsIssue(externalLink.getDestinationId());
    }

    private boolean handleNodeAssociation(Map<String, String> attributes) throws ParseException {
        ExternalNodeAssociation externalNodeAssociation = this.getNodeAssociationParser().parse(attributes);
        if ("Issue".equals(externalNodeAssociation.getSourceNodeEntity()) && ("IssueVersion".equals(externalNodeAssociation.getAssociationType()) || "IssueFixVersion".equals(externalNodeAssociation.getAssociationType()) || "IssueComponent".equals(externalNodeAssociation.getAssociationType()))) {
            return this.backupProject.containsIssue(externalNodeAssociation.getSourceNodeId());
        }
        return false;
    }

    private void buildModelEntityMap(List modelEntities) {
        for (ModelEntity modelEntity : modelEntities) {
            this.modelEntityMap.put(modelEntity.getEntityName(), modelEntity);
        }
    }

    private NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    private IssueLinkParser getIssueLinkParser() {
        if (this.issueLinkParser == null) {
            this.issueLinkParser = new IssueLinkParserImpl();
        }
        return this.issueLinkParser;
    }

    private ChangeGroupParser getChangeGroupParser() {
        if (this.changeGroupParser == null) {
            this.changeGroupParser = new ChangeGroupParserImpl();
        }
        return this.changeGroupParser;
    }

    private ChangeItemParser getChangeItemParser() {
        if (this.changeItemParser == null) {
            this.changeItemParser = new ChangeItemParserImpl();
        }
        return this.changeItemParser;
    }

    UserAssociationParser getUserAssociationParser() {
        if (this.userAssociationParser == null) {
            this.userAssociationParser = new UserAssociationParserImpl();
        }
        return this.userAssociationParser;
    }

    EntityPropertyParser getEntityPropertyParser() {
        if (this.entityPropertyParser == null) {
            this.entityPropertyParser = new EntityPropertyParserImpl();
        }
        return this.entityPropertyParser;
    }

    CommentParser getCommentParser() {
        if (this.commentParser == null) {
            this.commentParser = new CommentParserImpl();
        }
        return this.commentParser;
    }
}

