/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalEntityProperty;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.EntityPropertyParser;
import com.atlassian.jira.imports.project.parser.EntityPropertyParserImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

public class EntityPropertiesPersisterHandler
extends AbstractPersisterHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(EntityPropertiesPersisterHandler.class);
    private final ProjectImportResults projectImportResults;
    private final ProjectImportPersister projectImportPersister;
    private final EntityPropertyType entityPropertyType;
    private final SimpleProjectImportIdMapper idMapperForType;
    private final EntityPropertyParser entityPropertyParser = new EntityPropertyParserImpl();

    public EntityPropertiesPersisterHandler(Executor executor, ProjectImportResults projectImportResults, ProjectImportPersister projectImportPersister, EntityPropertyType entityPropertyType, SimpleProjectImportIdMapper idMapperForType) {
        super(executor, projectImportResults);
        this.projectImportResults = projectImportResults;
        this.projectImportPersister = projectImportPersister;
        this.entityPropertyType = entityPropertyType;
        this.idMapperForType = idMapperForType;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("EntityProperty".equals(entityName)) {
            final ExternalEntityProperty externalEntityProperty = this.getParser().parse(attributes);
            if (this.entityPropertyType.getDbEntityName().equals(externalEntityProperty.getEntityName()) && externalEntityProperty.getEntityId() != null) {
                String newEntityIdStr = this.idMapperForType.getMappedId(String.valueOf(externalEntityProperty.getEntityId()));
                if (newEntityIdStr != null) {
                    final EntityRepresentation representation = this.getParser().getEntityRepresentation(externalEntityProperty, Long.valueOf(newEntityIdStr));
                    this.execute(new Runnable(){

                        @Override
                        public void run() {
                            Long entityId = EntityPropertiesPersisterHandler.this.projectImportPersister.createEntity(representation);
                            if (entityId == null) {
                                EntityPropertiesPersisterHandler.this.projectImportResults.addError(EntityPropertiesPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.entity.property.error", String.valueOf(externalEntityProperty.getId()), externalEntityProperty.getEntityName(), String.valueOf(externalEntityProperty.getEntityId())));
                            }
                        }
                    });
                } else {
                    log.debug((Object)("Ignoring entity property id=" + externalEntityProperty.getId() + " entityName = " + externalEntityProperty.getEntityName()));
                }
            }
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    private EntityPropertyParser getParser() {
        return this.entityPropertyParser;
    }
}

