/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeItem;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.ChangeItemParser;
import com.atlassian.jira.imports.project.parser.ChangeItemParserImpl;
import com.atlassian.jira.imports.project.transformer.ChangeItemTransformer;
import com.atlassian.jira.imports.project.transformer.ChangeItemTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

public class ChangeItemPersisterHandler
extends AbstractPersisterHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(ChangeItemPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private ChangeItemTransformer changeItemTransformer;
    private ChangeItemParser changeItemParser;

    public ChangeItemPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("ChangeItem".equals(entityName)) {
            final ExternalChangeItem oldChangeItem = this.getChangeItemParser().parse(attributes);
            final ExternalChangeItem newChangeItem = this.getChangeItemTransformer().transform(this.projectImportMapper, oldChangeItem);
            if (newChangeItem.getChangeGroupId() != null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        Long changeItemId = ChangeItemPersisterHandler.this.projectImportPersister.createEntity(ChangeItemPersisterHandler.this.getChangeItemParser().getEntityRepresentation(newChangeItem));
                        if (changeItemId == null) {
                            ChangeItemPersisterHandler.this.projectImportResults.addError(ChangeItemPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.change.item.error", oldChangeItem.getId(), oldChangeItem.getChangeGroupId()));
                        }
                    }
                });
            } else {
                log.warn((Object)("Not creating change item with id '" + oldChangeItem.getId() + "' for backup change group with id '" + oldChangeItem.getChangeGroupId() + "', the change group has not been mapped in the new system."));
            }
        }
    }

    ChangeItemTransformer getChangeItemTransformer() {
        if (this.changeItemTransformer == null) {
            this.changeItemTransformer = new ChangeItemTransformerImpl();
        }
        return this.changeItemTransformer;
    }

    ChangeItemParser getChangeItemParser() {
        if (this.changeItemParser == null) {
            this.changeItemParser = new ChangeItemParserImpl();
        }
        return this.changeItemParser;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }
}

