/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;

public class ProjectImportDataImpl
implements ProjectImportData {
    private final ProjectImportTemporaryFiles temporaryFiles;
    private final int issueCount;
    private final int fileAttachmentCount;
    private final int changeItemEntityCount;
    private int validAttachmentCount;
    private final int issueRelatedEntitiesCount;
    private final int customFieldValuesCount;
    private final ProjectImportMapper projectImportMapper;

    public ProjectImportDataImpl(ProjectImportMapper projectImportMapper, ProjectImportTemporaryFiles temporaryFiles, int issueCount, int customFieldValuesCount, int issueRelatedEntitiesCount, int fileAttachmentCount, int changeItemEntityCount) {
        this.temporaryFiles = temporaryFiles;
        this.issueCount = issueCount;
        this.customFieldValuesCount = customFieldValuesCount;
        this.issueRelatedEntitiesCount = issueRelatedEntitiesCount;
        this.projectImportMapper = projectImportMapper;
        this.fileAttachmentCount = fileAttachmentCount;
        this.changeItemEntityCount = changeItemEntityCount;
    }

    @Override
    public ProjectImportTemporaryFiles getTemporaryFiles() {
        return this.temporaryFiles;
    }

    @Override
    public String getPathToIssuesXml() {
        return this.temporaryFiles.getIssuesXmlFile().getAbsolutePath();
    }

    @Override
    public int getIssueEntityCount() {
        return this.issueCount;
    }

    @Override
    public String getPathToFileAttachmentXml() {
        return this.temporaryFiles.getFileAttachmentEntitiesXmlFile().getAbsolutePath();
    }

    @Override
    public int getFileAttachmentEntityCount() {
        return this.fileAttachmentCount;
    }

    @Override
    public String getPathToIssueRelatedEntitiesXml() {
        return this.temporaryFiles.getIssueRelatedEntitiesXmlFile().getAbsolutePath();
    }

    @Override
    public int getIssueRelatedEntityCount() {
        return this.issueRelatedEntitiesCount;
    }

    @Override
    public String getPathToCustomFieldValuesXml() {
        return this.temporaryFiles.getCustomFieldValuesXmlFile().getAbsolutePath();
    }

    @Override
    public int getCustomFieldValuesEntityCount() {
        return this.customFieldValuesCount;
    }

    @Override
    public int getChangeItemEntityCount() {
        return this.changeItemEntityCount;
    }

    @Override
    public ProjectImportMapper getProjectImportMapper() {
        return this.projectImportMapper;
    }

    @Override
    public void setValidAttachmentsCount(int validAttachmentCount) {
        this.validAttachmentCount = validAttachmentCount;
    }

    @Override
    public int getValidAttachmentsCount() {
        return this.validAttachmentCount;
    }

    @Override
    public String getPathToChangeItemXml() {
        return this.temporaryFiles.getChangeItemEntitiesXmlFile().getAbsolutePath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectImportDataImpl that = (ProjectImportDataImpl)o;
        if (this.customFieldValuesCount != that.customFieldValuesCount) {
            return false;
        }
        if (this.fileAttachmentCount != that.fileAttachmentCount) {
            return false;
        }
        if (this.issueCount != that.issueCount) {
            return false;
        }
        if (this.issueRelatedEntitiesCount != that.issueRelatedEntitiesCount) {
            return false;
        }
        if (this.validAttachmentCount != that.validAttachmentCount) {
            return false;
        }
        if (this.projectImportMapper != null ? !this.projectImportMapper.equals(that.projectImportMapper) : that.projectImportMapper != null) {
            return false;
        }
        return !(this.temporaryFiles != null ? !this.temporaryFiles.equals(that.temporaryFiles) : that.temporaryFiles != null);
    }

    public int hashCode() {
        int result = this.temporaryFiles != null ? this.temporaryFiles.hashCode() : 0;
        result = 31 * result + this.issueCount;
        result = 31 * result + this.fileAttachmentCount;
        result = 31 * result + this.validAttachmentCount;
        result = 31 * result + this.issueRelatedEntitiesCount;
        result = 31 * result + this.customFieldValuesCount;
        result = 31 * result + (this.projectImportMapper != null ? this.projectImportMapper.hashCode() : 0);
        return result;
    }
}

