/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.util.SecureRandomStringUtils;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.external.ExternalException;
import com.atlassian.jira.external.ExternalUtils;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.external.beans.ExternalVoter;
import com.atlassian.jira.external.beans.ExternalWatcher;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import com.atlassian.jira.imports.project.taskprogress.AbstractSubtaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.util.IssueIdsIssueIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.web.util.AttachmentException;
import com.opensymphony.module.propertyset.PropertySet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;

public class DefaultProjectImportPersister
implements ProjectImportPersister {
    private static final Logger log = Logger.getLogger(DefaultProjectImportPersister.class);
    static final String GENERIC_CONTENT_TYPE = "application/octet-stream";
    private final UserUtil userUtil;
    private final ExternalUtils externalUtils;
    private final IssueFactory issueFactory;
    private final OfBizDelegator ofBizDelegator;
    private final IssueIndexManager issueIndexManager;
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final VersionManager versionManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final UserAssociationStore userAssociationStore;
    private final ProjectComponentManager projectComponentManager;
    private final AttachmentManager attachmentManager;
    private final ChangeHistoryManager changeHistoryManager;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final CrowdService crowdService;
    private final ApplicationProperties applicationProperties;
    private final UserPropertyManager userPropertyManager;

    public DefaultProjectImportPersister(UserUtil userUtil, ExternalUtils externalUtils, IssueFactory issueFactory, OfBizDelegator ofBizDelegator, IssueIndexManager issueIndexManager, IssueManager issueManager, ProjectManager projectManager, VersionManager versionManager, NodeAssociationStore nodeAssociationStore, UserAssociationStore userAssociationStore, ProjectComponentManager projectComponentManager, AttachmentManager attachmentManager, ChangeHistoryManager changeHistoryManager, IssueLinkTypeManager issueLinkTypeManager, CrowdService crowdService, ApplicationProperties applicationProperties, UserPropertyManager userPropertyManager) {
        this.userUtil = userUtil;
        this.externalUtils = externalUtils;
        this.issueFactory = issueFactory;
        this.ofBizDelegator = ofBizDelegator;
        this.issueIndexManager = issueIndexManager;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.versionManager = versionManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.userAssociationStore = userAssociationStore;
        this.projectComponentManager = projectComponentManager;
        this.attachmentManager = attachmentManager;
        this.changeHistoryManager = changeHistoryManager;
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.crowdService = crowdService;
        this.applicationProperties = applicationProperties;
        this.userPropertyManager = userPropertyManager;
    }

    @Override
    public Issue createIssue(ExternalIssue externalIssue, Date importDate, User importAuthor) {
        try {
            Issue issueForExternalIssue = this.createIssueForExternalIssue(externalIssue);
            GenericValue issueGV = this.externalUtils.createIssue(issueForExternalIssue, externalIssue.getStatus(), externalIssue.getResolution());
            this.updateIssueKey(externalIssue, issueGV);
            ChangeItemBean changeItem = new ChangeItemBean("jira", "ProjectImport", "", "", String.valueOf(importDate.getTime()), importDate.toString());
            MutableIssue issue = this.issueFactory.getIssue(issueGV);
            this.createChangeItem(importAuthor, (Issue)issue, changeItem);
            return issue;
        }
        catch (ExternalException e) {
            log.error((Object)("Unable to create issue with key '" + externalIssue.getKey() + "'."), (Throwable)((Object)e));
            return null;
        }
        catch (RuntimeException e) {
            log.error((Object)("Unable to create issue with key '" + externalIssue.getKey() + "'."), (Throwable)e);
            return null;
        }
    }

    @Override
    public Long createEntity(EntityRepresentation entityRepresentation) {
        GenericValue value = this.ofBizDelegator.makeValue(entityRepresentation.getEntityName());
        ModelEntity modelEntity = value.getModelEntity();
        Map map = entityRepresentation.getEntityValues();
        Iterator i = modelEntity.getFieldsIterator();
        while (i.hasNext()) {
            ModelField modelField = (ModelField)i.next();
            String name = modelField.getName();
            String attr = (String)map.get(name);
            if (attr == null) continue;
            value.setString(name, attr);
        }
        try {
            GenericValue newValue = this.ofBizDelegator.createValue(value.getEntityName(), value.getAllFields());
            return newValue.getLong("id");
        }
        catch (DataAccessException ex) {
            log.error((Object)("DataAccessException occured while trying to create Entity type '" + entityRepresentation.getEntityName() + "' . " + entityRepresentation.getEntityValues()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public String createChangeItemForIssueLinkIfNeeded(String issueId, String issueLinkTypeId, String linkedIssueKey, boolean isSource, User importAuthor) {
        Assertions.notBlank((String)"issueId", (String)issueId);
        Assertions.notBlank((String)"issueLinkTypeId", (String)issueLinkTypeId);
        Assertions.notBlank((String)"linkedIssueKey", (String)linkedIssueKey);
        MutableIssue issue = this.issueManager.getIssueObject(new Long(issueId));
        if (issue == null) {
            log.warn((Object)("Attempted to create a change item for an issue link against an issue with id '" + issueId + "' but JIRA could not resolve the issue for that id, no change item will be created."));
            return null;
        }
        boolean createChangeItem = this.createIssueLinkChangeItem(linkedIssueKey, (Issue)issue);
        if (createChangeItem) {
            ChangeItemBean changeItem = this.getChangeItemBean(issueLinkTypeId, linkedIssueKey, isSource);
            this.createChangeItem(importAuthor, (Issue)issue, changeItem);
            issue.setUpdated(new Timestamp(System.currentTimeMillis()));
            issue.store();
            return issueId;
        }
        return null;
    }

    @Override
    public void reIndexProject(ProjectImportMapper projectImportMapper, TaskProgressInterval taskProgressInterval, I18nHelper i18n) throws IndexException {
        ArrayList<Long> newIssueIds = new ArrayList<Long>();
        for (String issueIdAsString : projectImportMapper.getIssueMapper().getAllMappedIds()) {
            if (issueIdAsString == null) continue;
            try {
                Long issueId = new Long(issueIdAsString);
                newIssueIds.add(issueId);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("The Issue Mapper returned an invalid issue ID '" + issueIdAsString + "'."));
            }
        }
        IssuesIterable issuesIterable = this.getIssuesIterable(newIssueIds);
        Context context = taskProgressInterval == null ? Contexts.percentageLogger((Sized)issuesIterable, (Logger)log) : Contexts.percentageReporter((Sized)issuesIterable, (TaskProgressSink)taskProgressInterval.getTaskProgressSink(), (I18nHelper)i18n, (Logger)log);
        this.issueIndexManager.reIndexIssues(issuesIterable, context);
    }

    @Override
    public boolean createAssociation(ExternalNodeAssociation nodeAssociation) {
        GenericValue associationGV = this.nodeAssociationStore.createAssociation(nodeAssociation.getSourceNodeEntity(), new Long(nodeAssociation.getSourceNodeId()), nodeAssociation.getSinkNodeEntity(), new Long(nodeAssociation.getSinkNodeId()), nodeAssociation.getAssociationType());
        return associationGV != null;
    }

    @Override
    public boolean createVoter(ExternalVoter voter) {
        try {
            this.userAssociationStore.createAssociation("VoteIssue", voter.getVoter(), "Issue", new Long(voter.getIssueId()));
            return true;
        }
        catch (DataAccessException e) {
            return false;
        }
    }

    @Override
    public boolean createWatcher(ExternalWatcher watcher) {
        try {
            this.userAssociationStore.createAssociation("WatchIssue", watcher.getWatcher(), "Issue", new Long(watcher.getIssueId()));
            return true;
        }
        catch (DataAccessException e) {
            return false;
        }
    }

    @Override
    public Project updateProjectDetails(ExternalProject externalProject) {
        Project project = this.projectManager.getProjectObjByKey(externalProject.getKey());
        if (project == null) {
            throw new IllegalStateException("Unable to find a project with key '" + externalProject.getKey() + "'. We can not create versions against a project that does not exist.");
        }
        Long assigneeType = null;
        if (externalProject.getAssigneeType() != null) {
            try {
                assigneeType = Long.parseLong(externalProject.getAssigneeType());
            }
            catch (NumberFormatException ex) {
                assigneeType = null;
            }
        }
        if (assigneeType == null) {
            assigneeType = this.isUnassignedIssuesAllowed() ? Long.valueOf(3L) : Long.valueOf(2L);
        }
        Project updatedProject = this.projectManager.updateProject(project, externalProject.getName(), externalProject.getDescription(), externalProject.getLead(), externalProject.getUrl(), assigneeType);
        this.setEmailSenderOnProject(updatedProject, externalProject.getEmailSender());
        return updatedProject;
    }

    boolean isUnassignedIssuesAllowed() {
        return this.applicationProperties.getOption("jira.option.allowunassigned");
    }

    @Override
    public Project createProject(ExternalProject project) throws ExternalException {
        Project newProject = this.externalUtils.createProject(project);
        this.setEmailSenderOnProject(newProject, project.getEmailSender());
        return newProject;
    }

    @Override
    public Map<String, Version> createVersions(BackupProject backupProject) {
        Project project = this.projectManager.getProjectObjByKey(backupProject.getProject().getKey());
        if (project == null) {
            throw new IllegalStateException("Unable to find a project with key '" + backupProject.getProject().getKey() + "'. We can not create versions against a project that does not exist.");
        }
        Long projectId = project.getId();
        HashMap<String, Version> newVersions = new HashMap<String, Version>();
        for (ExternalVersion externalVersion : this.getOrderedProjectVersions(backupProject)) {
            try {
                Version version = this.versionManager.createVersion(externalVersion.getName(), externalVersion.getReleaseDate(), externalVersion.getDescription(), projectId, null);
                newVersions.put(externalVersion.getId(), version);
                if (externalVersion.isArchived()) {
                    this.versionManager.archiveVersion(version, true);
                }
                if (!externalVersion.isReleased()) continue;
                this.versionManager.releaseVersions((Collection)EasyList.build((Object)version), true);
            }
            catch (Exception e) {
                log.error((Object)"There was a problem creating a project version for the project import.");
                throw new DataAccessException("There was a problem creating a project version for the project import.");
            }
        }
        return newVersions;
    }

    @Override
    public Map<String, ProjectComponent> createComponents(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        Project project = this.projectManager.getProjectObjByKey(backupProject.getProject().getKey());
        if (project == null) {
            throw new IllegalStateException("Unable to find a project with key '" + backupProject.getProject().getKey() + "'. We can not create components against a project that does not exist.");
        }
        Long projectId = project.getId();
        HashMap<String, ProjectComponent> newComponents = new HashMap<String, ProjectComponent>();
        for (ExternalComponent element : backupProject.getProjectComponents()) {
            ExternalComponent externalComponent = element;
            long assigneeType = externalComponent.getAssigneeType() != null ? Long.parseLong(externalComponent.getAssigneeType()) : 0L;
            String mappedLeadUserKey = projectImportMapper.getUserMapper().getMappedUserKey(externalComponent.getLead());
            ProjectComponent component = this.projectComponentManager.create(externalComponent.getName(), externalComponent.getDescription(), mappedLeadUserKey, assigneeType, projectId);
            if (component == null) {
                log.error((Object)("Could not create project component '" + externalComponent.getName() + "'."));
                throw new DataAccessException("Could not create project component '" + externalComponent.getName() + "'.");
            }
            newComponents.put(externalComponent.getId(), component);
        }
        return newComponents;
    }

    private Collection<ExternalVersion> getOrderedProjectVersions(BackupProject backupProject) {
        ArrayList<ExternalVersion> versions = new ArrayList<ExternalVersion>(backupProject.getProjectVersions());
        Collections.sort(versions, new Comparator<ExternalVersion>(){

            @Override
            public int compare(ExternalVersion o, ExternalVersion o1) {
                return o.getSequence().intValue() - o1.getSequence().intValue();
            }
        });
        return versions;
    }

    @Override
    public void updateProjectIssueCounter(BackupProject backupProject, long counter) {
        Project project = this.projectManager.getProjectObjByKey(backupProject.getProject().getKey());
        if (project == null) {
            throw new IllegalStateException("Unable to find a project with key '" + backupProject.getProject().getKey());
        }
        this.projectManager.setCurrentCounterForProject(project, counter);
    }

    @Override
    public boolean createUser(UserMapper userMapper, ExternalUser externalUser) {
        User newUser = this.crowdService.getUser(externalUser.getName());
        if (newUser != null) {
            log.warn((Object)("User '" + externalUser.getName() + "' already exists, not creating the user from the backup files details."));
            return true;
        }
        ImmutableUser.Builder builder = ImmutableUser.newUser().directoryId(-1L).name(externalUser.getName()).displayName(externalUser.getFullname()).emailAddress(externalUser.getEmail()).active(true);
        String randomPassword = SecureRandomStringUtils.getInstance().randomAlphanumericString(26) + "ABab23";
        try {
            newUser = this.crowdService.addUser(builder.toUser(), randomPassword);
        }
        catch (InvalidUserException e) {
            log.error((Object)("An error occurred while trying to create user '" + externalUser + "'."), (Throwable)e);
            return false;
        }
        catch (InvalidCredentialException e) {
            log.error((Object)("An error occurred while trying to create user '" + externalUser + "'."), (Throwable)e);
            return false;
        }
        catch (OperationNotPermittedException e) {
            log.error((Object)("An error occurred while trying to create user '" + externalUser + "'."), (Throwable)e);
            return false;
        }
        if (newUser == null) {
            log.error((Object)("An error occurred while trying to create user '" + externalUser + "'."));
            return false;
        }
        try {
            this.userUtil.addToJiraUsePermission(newUser);
        }
        catch (PermissionException e) {
            log.warn((Object)("User '" + externalUser.getName() + "' not added to Jira Use Permission, User Directory is read only."));
            return true;
        }
        for (Map.Entry entry : externalUser.getUserPropertyMap().entrySet()) {
            this.userPropertyManager.getPropertySet(newUser).setString("jira.meta." + (String)entry.getKey(), (String)entry.getValue());
        }
        return true;
    }

    @Override
    public Attachment createAttachment(ExternalAttachment externalAttachment) {
        Null.not("externalAttachment", externalAttachment);
        Null.not("attachedFile", externalAttachment.getAttachedFile());
        Null.not("fileName", externalAttachment.getFileName());
        Null.not("issueId", externalAttachment.getIssueId());
        MutableIssue issue = this.issueManager.getIssueObject(new Long(externalAttachment.getIssueId()));
        if (issue == null) {
            throw new IllegalArgumentException("Can not create an attachment against a null issue.");
        }
        try {
            ApplicationUser attacher = this.userUtil.getUserByKey(externalAttachment.getAttacher());
            String attacherUserName = attacher == null ? null : attacher.getName();
            return this.attachmentManager.createAttachmentCopySourceFile(externalAttachment.getAttachedFile(), externalAttachment.getFileName(), GENERIC_CONTENT_TYPE, attacherUserName, (Issue)issue, Collections.emptyMap(), externalAttachment.getAttachedDate());
        }
        catch (AttachmentException e) {
            log.error((Object)("Unable to create issue file attachment with name '" + externalAttachment.getFileName() + "'."), (Throwable)e);
            return null;
        }
    }

    void setEmailSenderOnProject(Project project, String emailSender) {
        if (emailSender != null) {
            PropertySet propertySet = this.getPropertySet(project);
            propertySet.setString("jira.project.email.sender", emailSender);
        }
    }

    PropertySet getPropertySet(Project project) {
        return OFBizPropertyUtils.getPropertySet(project.getGenericValue());
    }

    void createChangeItem(User author, Issue issue, ChangeItemBean changeItem) {
        ChangeLogUtils.createChangeGroup(author, issue, issue, (Collection<ChangeItemBean>)EasyList.build((Object)changeItem), false);
    }

    IssuesIterable getIssuesIterable(Collection<Long> newIssueIds) {
        return new IssueIdsIssueIterable(newIssueIds, this.issueManager);
    }

    void updateIssueKey(ExternalIssue externalIssue, GenericValue issueGV) {
        issueGV.setString("key", externalIssue.getKey());
        try {
            issueGV.store();
        }
        catch (GenericEntityException e) {
            String message = "Unable to set the required key '" + externalIssue.getKey() + "' in the Issue that we just created (id = '" + issueGV.getLong("id") + "').";
            log.error((Object)message, (Throwable)e);
            throw new DataAccessException(message, (Throwable)e);
        }
    }

    Issue createIssueForExternalIssue(ExternalIssue externalIssue) {
        MutableIssue issue = this.issueFactory.getIssue();
        issue.setProjectId(new Long(externalIssue.getProject()));
        issue.setIssueTypeId(externalIssue.getIssueType());
        issue.setReporterId(externalIssue.getReporter());
        issue.setAssigneeId(externalIssue.getAssignee());
        issue.setSummary(externalIssue.getSummary());
        issue.setDescription(externalIssue.getDescription());
        issue.setEnvironment(externalIssue.getEnvironment());
        issue.setPriorityId(externalIssue.getPriority());
        issue.setResolutionId(externalIssue.getResolution());
        issue.setCreated(this.toTimeStamp(externalIssue.getCreated()));
        issue.setUpdated(this.toTimeStamp(externalIssue.getUpdated()));
        issue.setDueDate(this.toTimeStamp(externalIssue.getDuedate()));
        issue.setResolutionDate(this.toTimeStamp(externalIssue.getResolutionDate()));
        issue.setVotes(externalIssue.getVotes());
        issue.setOriginalEstimate(externalIssue.getOriginalEstimate());
        issue.setTimeSpent(externalIssue.getTimeSpent());
        issue.setEstimate(externalIssue.getEstimate());
        if (externalIssue.getSecurityLevel() != null) {
            issue.setSecurityLevelId(new Long(externalIssue.getSecurityLevel()));
        }
        return issue;
    }

    ChangeItemBean getChangeItemBean(String issueLinkTypeId, String linkedIssueKey, boolean isSource) {
        IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(new Long(issueLinkTypeId));
        ChangeItemBean changeItem = isSource ? new ChangeItemBean("jira", "Link", null, null, linkedIssueKey, "This issue " + issueLinkType.getOutward() + " " + linkedIssueKey) : new ChangeItemBean("jira", "Link", null, null, linkedIssueKey, "This issue " + issueLinkType.getInward() + " " + linkedIssueKey);
        return changeItem;
    }

    boolean createIssueLinkChangeItem(String linkedIssueKey, Issue issue) {
        List linkChangeItemsForIssue = this.changeHistoryManager.getChangeItemsForField(issue, "Link");
        boolean createItemFound = false;
        boolean deleteItemFound = false;
        for (ChangeItemBean changeItemBean : linkChangeItemsForIssue) {
            if (linkedIssueKey.equals(changeItemBean.getFrom())) {
                createItemFound = true;
                continue;
            }
            if (!linkedIssueKey.equals(changeItemBean.getTo())) continue;
            deleteItemFound = true;
        }
        return !createItemFound || deleteItemFound;
    }

    private Timestamp toTimeStamp(Date date) {
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    static class ReindexTaskProgressProcessor
    extends AbstractSubtaskProgressProcessor {
        private final TaskProgressSink taskProgressSink;
        private final I18nHelper i18n;

        public ReindexTaskProgressProcessor(TaskProgressInterval taskProgressInterval, I18nHelper i18n) {
            super(taskProgressInterval, 100);
            this.i18n = i18n;
            this.taskProgressSink = taskProgressInterval == null ? null : taskProgressInterval.getTaskProgressSink();
        }

        public void processTaskProgress(int progress) {
            if (this.taskProgressSink == null) {
                return;
            }
            long percent = this.getOverallPercentageComplete(progress);
            String message = this.i18n.getText("admin.indexing.percent.complete", (Object)progress);
            this.taskProgressSink.makeProgress(percent, this.i18n.getText("admin.indexing.indexing"), message);
        }
    }
}

