/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.favourites;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.favourites.FavouritesStore;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@EventComponent
public class CachingFavouritesStore
implements FavouritesStore,
Startable {
    private final Cache<Key, Collection<Long>> favouritesCache;
    private final FavouritesStore delegateStore;

    public CachingFavouritesStore(FavouritesStore delegateStore, CacheManager cacheManager) {
        this.delegateStore = (FavouritesStore)Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.favouritesCache = cacheManager.getCache(CachingFavouritesStore.class.getName() + ".favouritesCache", (CacheLoader)new KeyCollectionCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maxEntries(1000).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.favouritesCache.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addFavourite(ApplicationUser user, SharedEntity entity) {
        try {
            boolean bl = this.delegateStore.addFavourite((ApplicationUser)Assertions.notNull((String)"user", (Object)user), (SharedEntity)Assertions.notNull((String)"entity", (Object)entity));
            return bl;
        }
        finally {
            this.flushFavourites(user, entity.getEntityType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFavourite(ApplicationUser user, SharedEntity entity) {
        try {
            boolean bl = this.delegateStore.removeFavourite((ApplicationUser)Assertions.notNull((String)"user", (Object)user), (SharedEntity)Assertions.notNull((String)"entity", (Object)entity));
            return bl;
        }
        finally {
            this.flushFavourites(user, entity.getEntityType());
        }
    }

    @Override
    public boolean isFavourite(ApplicationUser user, SharedEntity entity) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entity", (Object)entity);
        Collection<Long> ids = this.getFavouriteIds(user, entity.getEntityType());
        return ids.contains(entity.getId());
    }

    @Override
    public Collection<Long> getFavouriteIds(ApplicationUser user, SharedEntity.TypeDescriptor<?> entityType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entityType", entityType);
        Key key = new Key(user, entityType);
        Collection ids = (Collection)this.favouritesCache.get((Object)key);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFavouritesForUser(ApplicationUser user, SharedEntity.TypeDescriptor<?> entityType) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"entityType", entityType);
        try {
            this.delegateStore.removeFavouritesForUser(user, entityType);
        }
        finally {
            this.flushFavourites(user, entityType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFavouritesForEntity(SharedEntity entity) {
        try {
            this.delegateStore.removeFavouritesForEntity(entity);
        }
        finally {
            Cache<Key, Collection<Long>> cache = this.favouritesCache;
            synchronized (cache) {
                for (Key key : this.favouritesCache.getKeys()) {
                    Collection value;
                    if (!key.getType().equals((Object)entity.getEntityType()) || !(value = (Collection)this.favouritesCache.get((Object)key)).contains(entity.getId())) continue;
                    this.favouritesCache.remove((Object)key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSequence(ApplicationUser user, List<? extends SharedEntity> favouriteEntities) {
        try {
            this.delegateStore.updateSequence(user, favouriteEntities);
        }
        finally {
            if (!favouriteEntities.isEmpty()) {
                SharedEntity entity = favouriteEntities.get(0);
                this.flushFavourites(user, entity.getEntityType());
            }
        }
    }

    private void flushFavourites(ApplicationUser user, SharedEntity.TypeDescriptor<?> typeDescriptor) {
        if (user != null) {
            this.favouritesCache.remove((Object)new Key(user, typeDescriptor));
        }
    }

    public void start() throws Exception {
    }

    private class KeyCollectionCacheLoader
    implements CacheLoader<Key, Collection<Long>> {
        private KeyCollectionCacheLoader() {
        }

        public Collection<Long> load(Key key) {
            ApplicationUser user = key.getUser();
            SharedEntity.TypeDescriptor<?> entityType = key.getType();
            Collection<Long> ids = CachingFavouritesStore.this.delegateStore.getFavouriteIds(user, entityType);
            if (ids == null) {
                ids = Collections.emptyList();
            }
            return ids;
        }
    }

    private static class Key {
        private final ApplicationUser user;
        private final SharedEntity.TypeDescriptor<?> type;

        public Key(ApplicationUser user, SharedEntity.TypeDescriptor<?> type) {
            Assertions.notNull((String)"user", (Object)user);
            Assertions.notNull((String)"type", type);
            this.user = user;
            this.type = type;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public SharedEntity.TypeDescriptor<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.type.equals(key.type)) {
                return false;
            }
            return this.user.equals(key.user);
        }

        public int hashCode() {
            int result = this.user.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        }
    }
}

