/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.event.config.ApplicationPropertyChangeEvent;
import com.atlassian.jira.util.JiraKeyUtils;
import java.util.Map;
import org.apache.log4j.Logger;

@EventComponent
public class ProjectKeyRegexChangeListener {
    private static final Logger log = Logger.getLogger(ProjectKeyRegexChangeListener.class);

    @EventListener
    public static void onApplicationPropertyChange(ApplicationPropertyChangeEvent event) {
        try {
            Map params = event.getParams();
            ApplicationPropertyMetadata metadata = (ApplicationPropertyMetadata)params.get("metadata");
            if ("jira.projectkey.pattern".equals(metadata.getKey())) {
                log.info((Object)"Resetting the issue key matcher");
                JiraKeyUtils.resetKeyMatcher();
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to decide whether to reset the project key matcher because the event doesn't seem to contain the correct metadata");
        }
    }
}

