/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.remotelink;

import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.JsonNodeFactory;

public class LazyJsonParser {
    private static final String EMPTY_JSON_OBJECT = "{}";
    private final String json;
    private final LazyReference<JsonNode> rootRef;

    public LazyJsonParser(String json) {
        this.json = StringUtils.isBlank((CharSequence)json) ? EMPTY_JSON_OBJECT : json;
        this.rootRef = new LazyReference<JsonNode>(){

            protected JsonNode create() throws IOException {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode node = objectMapper.readTree((Reader)new StringReader(LazyJsonParser.this.json));
                return node != null ? node : JsonNodeFactory.instance.objectNode();
            }
        };
    }

    public String getJson() {
        return this.json;
    }

    public ReadOnlyJsonNode root() {
        return LazyJsonParser.wrap(this.getRootNode());
    }

    public String getTextAtPath(String ... fieldNames) {
        JsonNode node = this.getRootNode();
        for (String fieldName : fieldNames) {
            node = node.path(fieldName);
        }
        return node.isTextual() ? node.asText() : null;
    }

    private JsonNode getRootNode() {
        try {
            return (JsonNode)this.rootRef.get();
        }
        catch (LazyReference.InitializationException ie) {
            Throwable cause = ie.getCause();
            throw new IllegalArgumentException("Invalid JSON", cause != null ? cause : ie);
        }
    }

    static ReadOnlyJsonNode wrap(JsonNode node) {
        return node != null ? new ReadOnlyJsonNode(node) : null;
    }

    static List<ReadOnlyJsonNode> wrap(List<JsonNode> list) {
        if (list == null) {
            return null;
        }
        return Lists.transform(list, (Function)WrappingFunction.INSTANCE);
    }

    static Iterator<ReadOnlyJsonNode> wrap(Iterator<JsonNode> iterator) {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(iterator, (Function)WrappingFunction.INSTANCE));
    }

    static class WrappingFunction
    implements Function<JsonNode, ReadOnlyJsonNode> {
        static final WrappingFunction INSTANCE = new WrappingFunction();

        WrappingFunction() {
        }

        public ReadOnlyJsonNode apply(@Nullable JsonNode input) {
            return LazyJsonParser.wrap(input);
        }
    }

    public static class ReadOnlyJsonNode
    implements Iterable<ReadOnlyJsonNode> {
        private final JsonNode delegate;

        ReadOnlyJsonNode(JsonNode delegate) {
            this.delegate = delegate;
        }

        public boolean isValueNode() {
            return this.delegate.isValueNode();
        }

        public boolean isContainerNode() {
            return this.delegate.isContainerNode();
        }

        public boolean isMissingNode() {
            return this.delegate.isMissingNode();
        }

        public boolean isArray() {
            return this.delegate.isArray();
        }

        public boolean isObject() {
            return this.delegate.isObject();
        }

        public boolean isPojo() {
            return this.delegate.isPojo();
        }

        public boolean isNumber() {
            return this.delegate.isNumber();
        }

        public boolean isIntegralNumber() {
            return this.delegate.isIntegralNumber();
        }

        public boolean isFloatingPointNumber() {
            return this.delegate.isFloatingPointNumber();
        }

        public boolean isInt() {
            return this.delegate.isInt();
        }

        public boolean isLong() {
            return this.delegate.isLong();
        }

        public boolean isDouble() {
            return this.delegate.isDouble();
        }

        public boolean isBigDecimal() {
            return this.delegate.isBigDecimal();
        }

        public boolean isBigInteger() {
            return this.delegate.isBigInteger();
        }

        public boolean isTextual() {
            return this.delegate.isTextual();
        }

        public boolean isBoolean() {
            return this.delegate.isBoolean();
        }

        public boolean isNull() {
            return this.delegate.isNull();
        }

        public boolean isBinary() {
            return this.delegate.isBinary();
        }

        public JsonToken asToken() {
            return this.delegate.asToken();
        }

        public JsonParser.NumberType getNumberType() {
            return this.delegate.getNumberType();
        }

        public String getTextValue() {
            return this.delegate.getTextValue();
        }

        public byte[] getBinaryValue() throws IOException {
            return this.delegate.getBinaryValue();
        }

        public boolean getBooleanValue() {
            return this.delegate.getBooleanValue();
        }

        public Number getNumberValue() {
            return this.delegate.getNumberValue();
        }

        public int getIntValue() {
            return this.delegate.getIntValue();
        }

        public long getLongValue() {
            return this.delegate.getLongValue();
        }

        public double getDoubleValue() {
            return this.delegate.getDoubleValue();
        }

        public BigDecimal getDecimalValue() {
            return this.delegate.getDecimalValue();
        }

        public BigInteger getBigIntegerValue() {
            return this.delegate.getBigIntegerValue();
        }

        public ReadOnlyJsonNode get(int index) {
            return LazyJsonParser.wrap(this.delegate.get(index));
        }

        public ReadOnlyJsonNode get(String fieldName) {
            return LazyJsonParser.wrap(this.delegate.get(fieldName));
        }

        public String asText() {
            return this.delegate.asText();
        }

        public String asTextOrNull() {
            return this.delegate.isTextual() ? this.delegate.asText() : null;
        }

        public int asInt() {
            return this.delegate.asInt();
        }

        public int asInt(int defaultValue) {
            return this.delegate.asInt(defaultValue);
        }

        public long asLong() {
            return this.delegate.asLong();
        }

        public long asLong(long defaultValue) {
            return this.delegate.asLong(defaultValue);
        }

        public double asDouble() {
            return this.delegate.asDouble();
        }

        public double asDouble(double defaultValue) {
            return this.delegate.asDouble(defaultValue);
        }

        public boolean asBoolean() {
            return this.delegate.asBoolean();
        }

        public boolean asBoolean(boolean defaultValue) {
            return this.delegate.asBoolean(defaultValue);
        }

        public boolean has(String fieldName) {
            return this.delegate.has(fieldName);
        }

        public boolean has(int index) {
            return this.delegate.has(index);
        }

        public ReadOnlyJsonNode findValue(String fieldName) {
            return LazyJsonParser.wrap(this.delegate.findValue(fieldName));
        }

        public List<ReadOnlyJsonNode> findValues(String fieldName) {
            return LazyJsonParser.wrap(this.delegate.findValues(fieldName));
        }

        public List<String> findValuesAsText(String fieldName) {
            return this.delegate.findValuesAsText(fieldName);
        }

        public ReadOnlyJsonNode findPath(String fieldName) {
            return LazyJsonParser.wrap(this.delegate.findPath(fieldName));
        }

        public ReadOnlyJsonNode findParent(String fieldName) {
            return LazyJsonParser.wrap(this.delegate.findParent(fieldName));
        }

        public List<ReadOnlyJsonNode> findParents(String fieldName) {
            return LazyJsonParser.wrap(this.delegate.findParents(fieldName));
        }

        public int size() {
            return this.delegate.size();
        }

        @Override
        public Iterator<ReadOnlyJsonNode> iterator() {
            return Iterators.unmodifiableIterator((Iterator)Iterators.transform((Iterator)this.delegate.iterator(), (Function)WrappingFunction.INSTANCE));
        }

        public Iterator<ReadOnlyJsonNode> getElements() {
            return Iterators.unmodifiableIterator((Iterator)Iterators.transform((Iterator)this.delegate.getElements(), (Function)WrappingFunction.INSTANCE));
        }

        public Iterator<String> getFieldNames() {
            return Iterators.unmodifiableIterator((Iterator)this.delegate.getFieldNames());
        }

        public ReadOnlyJsonNode path(String ... fieldNames) {
            JsonNode node = this.delegate;
            for (String fieldName : fieldNames) {
                node = node.path(fieldName);
            }
            return LazyJsonParser.wrap(node);
        }

        public ReadOnlyJsonNode path(String fieldName) {
            return LazyJsonParser.wrap(this.delegate.path(fieldName));
        }

        public ReadOnlyJsonNode path(int index) {
            return LazyJsonParser.wrap(this.delegate.path(index));
        }

        public boolean equals(Object o) {
            return o instanceof ReadOnlyJsonNode && this.delegate.equals((Object)((ReadOnlyJsonNode)o).delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

