/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;

public class DelegatingEntityPropertyService<E extends WithId>
implements EntityPropertyService<E> {
    private final EntityPropertyService<E> delegate;

    public DelegatingEntityPropertyService(EntityPropertyService<E> delegate) {
        this.delegate = (EntityPropertyService)Preconditions.checkNotNull(delegate);
    }

    public ErrorCollection validatePropertyInput(EntityPropertyService.PropertyInput propertyInput) {
        return this.delegate.validatePropertyInput(propertyInput);
    }

    public EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, @NotNull Long entityId, @NotNull EntityPropertyService.PropertyInput propertyInput) {
        return this.delegate.validateSetProperty(user, entityId, propertyInput);
    }

    public EntityPropertyService.PropertyResult setProperty(ApplicationUser user, @NotNull EntityPropertyService.SetPropertyValidationResult propertyValidationResult) {
        return this.delegate.setProperty(user, propertyValidationResult);
    }

    public EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, @NotNull Long entityId, @NotNull String propertyKey) {
        return this.delegate.validateDeleteProperty(user, entityId, propertyKey);
    }

    public void deleteProperty(ApplicationUser user, @NotNull EntityPropertyService.DeletePropertyValidationResult validationResult) {
        this.delegate.deleteProperty(user, validationResult);
    }

    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, @NotNull Long entityId, @NotNull String propertyKey) {
        return this.delegate.getProperty(user, entityId, propertyKey);
    }

    public EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, @NotNull Long entityId) {
        return this.delegate.getPropertiesKeys(user, entityId);
    }
}

