/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.entity.CountEntityBuilder;
import com.atlassian.jira.entity.EntityBuilder;
import com.atlassian.jira.entity.EntityBuilders;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.IdEntityBuilder;
import com.atlassian.jira.entity.NamedEntityBuilder;
import com.atlassian.jira.entity.NoopEntityBuilder;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.entity.SelectQueryImpl;
import com.atlassian.jira.entity.StringEntityBuilder;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class Select {
    private static final Collection<String> COUNT_FIELD_LIST = Collections.singleton("count");

    public static SelectColumnsContext columns(String ... columns) {
        return new SelectColumnsContext(columns, false);
    }

    public static SelectColumnsContext distinct(String ... columns) {
        return new SelectColumnsContext(columns, true);
    }

    public static SelectSingleColumnContext<Long> id() {
        return new SelectSingleColumnContext<Long>("id", true, IdEntityBuilder.getInstance());
    }

    public static SelectSingleColumnContext<String> distinctString(String columnName) {
        StringEntityBuilder entityBuilder = new StringEntityBuilder(columnName);
        return new SelectSingleColumnContext<String>(columnName, true, entityBuilder);
    }

    public static SelectSingleColumnContext<String> stringColumn(String columnName) {
        StringEntityBuilder entityBuilder = new StringEntityBuilder(columnName);
        return new SelectSingleColumnContext<String>(columnName, false, entityBuilder);
    }

    public static <E> SelectColumnsFromContext<E> from(NamedEntityBuilder<E> entityFactory) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.fieldsToSelect = null;
        queryBuilder.distinct = false;
        queryBuilder.entityBuilder = entityFactory;
        queryBuilder.entityName = entityFactory.getEntityName();
        return new SelectColumnsFromContext(queryBuilder);
    }

    public static SelectColumnsFromContext<GenericValue> from(String entityName) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.fieldsToSelect = null;
        queryBuilder.distinct = false;
        queryBuilder.entityBuilder = new NoopEntityBuilder();
        queryBuilder.entityName = entityName;
        return new SelectColumnsFromContext<GenericValue>(queryBuilder);
    }

    public static SelectColumnsFromContext<Long> countFrom(String entityName) {
        QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.fieldsToSelect = COUNT_FIELD_LIST;
        queryBuilder.distinct = false;
        queryBuilder.entityBuilder = new CountEntityBuilder();
        queryBuilder.entityName = entityName + "Count";
        return new SelectColumnsFromContext<Long>(queryBuilder);
    }

    static class QueryBuilder<E> {
        boolean distinct;
        Collection<String> fieldsToSelect;
        String entityName;
        FieldMap whereEqual;
        List<EntityCondition> whereCondition;
        List<String> orderBy;
        int offset;
        int maxResults;
        EntityBuilder<E> entityBuilder;

        QueryBuilder() {
        }

        void addWhereEqual(String field, Object value) {
            if (this.whereEqual == null) {
                this.whereEqual = new FieldMap();
            }
            this.whereEqual.add(field, value);
        }

        void addWhereCondition(EntityCondition condition) {
            if (this.whereCondition == null) {
                this.whereCondition = new ArrayList<EntityCondition>();
            }
            this.whereCondition.add(condition);
        }

        public SelectQuery<E> toQuery() {
            return new SelectQueryImpl(this);
        }
    }

    public static class LimitContext<E>
    extends ExecutableContext<E> {
        LimitContext(QueryBuilder<E> queryBuilder) {
            super(queryBuilder);
        }
    }

    public static class OrderByContext<E>
    extends ExecutableContext<E> {
        private OrderByContext(QueryBuilder<E> queryBuilder) {
            super(queryBuilder);
        }

        public LimitContext<E> limit(int maxResults) {
            this.queryBuilder.maxResults = maxResults;
            return new LimitContext(this.queryBuilder);
        }

        public LimitContext<E> limit(int offset, int maxResults) {
            this.queryBuilder.offset = offset;
            this.queryBuilder.maxResults = maxResults;
            return new LimitContext(this.queryBuilder);
        }
    }

    public static class WhereContext<E>
    extends WhereClauseAwareContext<E> {
        private WhereContext(QueryBuilder<E> queryBuilder) {
            super(queryBuilder);
        }

        @Override
        public WhereContext<E> whereEqual(String fieldName, String value) {
            this.queryBuilder.addWhereEqual(fieldName, value);
            return this;
        }

        @Override
        public WhereContext<E> whereEqual(String fieldName, Long value) {
            this.queryBuilder.addWhereEqual(fieldName, value);
            return this;
        }

        @Override
        public WhereContext<E> whereCondition(EntityCondition condition) {
            this.queryBuilder.addWhereCondition(condition);
            return this;
        }

        public WhereContext<E> andEqual(String field, String value) {
            return this.whereEqual(field, value);
        }

        public WhereContext<E> andEqual(String field, Long value) {
            return this.whereEqual(field, value);
        }

        public WhereContext<E> andLike(String field, String pattern) {
            return this.whereLike(field, pattern);
        }

        @Override
        public OrderByContext<E> orderBy(String ... orderByColumn) {
            this.queryBuilder.orderBy = Arrays.asList(orderByColumn);
            return new OrderByContext(this.queryBuilder);
        }
    }

    public static class SelectColumnsFromContext<E>
    extends WhereClauseAwareContext<E> {
        private SelectColumnsFromContext(QueryBuilder<E> queryBuilder) {
            super(queryBuilder);
        }

        @Override
        public WhereContext<E> whereEqual(String fieldName, String value) {
            this.queryBuilder.addWhereEqual(fieldName, value);
            return new WhereContext(this.queryBuilder);
        }

        @Override
        public WhereContext<E> whereEqual(String fieldName, Long value) {
            this.queryBuilder.addWhereEqual(fieldName, value);
            return new WhereContext(this.queryBuilder);
        }

        @Override
        public WhereContext<E> whereCondition(EntityCondition condition) {
            this.queryBuilder.addWhereCondition(condition);
            return new WhereContext(this.queryBuilder);
        }

        @Override
        public OrderByContext<E> orderBy(String ... orderByColumn) {
            this.queryBuilder.orderBy = Arrays.asList(orderByColumn);
            return new OrderByContext(this.queryBuilder);
        }
    }

    public static abstract class WhereClauseAwareContext<E>
    extends ExecutableContext<E> {
        protected WhereClauseAwareContext(QueryBuilder<E> queryBuilder) {
            super(queryBuilder);
        }

        public abstract WhereContext<E> whereEqual(String var1, String var2);

        public abstract WhereContext<E> whereEqual(String var1, Long var2);

        public abstract WhereContext<E> whereCondition(EntityCondition var1);

        public abstract OrderByContext<E> orderBy(String ... var1);

        public final WhereContext<E> byId(@Nonnull Long id) {
            return this.whereEqual("id", (Long)Assertions.notNull((String)"id", (Object)id));
        }

        public final WhereContext<E> whereNull(String field) {
            return this.whereEqual(field, (String)null);
        }

        public final WhereContext<E> whereLike(String field, String pattern) {
            return this.whereCondition((EntityCondition)new EntityExpr(field, EntityOperator.LIKE, (Object)pattern));
        }
    }

    public static abstract class ExecutableContext<E>
    implements SelectQuery<E> {
        protected final QueryBuilder<E> queryBuilder;

        protected ExecutableContext(QueryBuilder<E> queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        @Override
        public final SelectQuery.ExecutionContext<E> runWith(OfBizDelegator ofBizDelegator) {
            return this.queryBuilder.toQuery().runWith(ofBizDelegator);
        }

        @Override
        public final SelectQuery.ExecutionContext<E> runWith(EntityEngine entityEngine) {
            return this.queryBuilder.toQuery().runWith(entityEngine);
        }
    }

    public static class SelectColumnsContext {
        private final QueryBuilder<GenericValue> queryBuilder = new QueryBuilder();

        private SelectColumnsContext(String[] columns, boolean distinct) {
            this.queryBuilder.fieldsToSelect = Arrays.asList(columns);
            this.queryBuilder.distinct = distinct;
        }

        public SelectColumnsFromContext<GenericValue> from(String entityName) {
            this.queryBuilder.entityName = entityName;
            this.queryBuilder.entityBuilder = EntityBuilders.NO_OP_BUILDER;
            return new SelectColumnsFromContext<GenericValue>(this.queryBuilder);
        }
    }

    public static class SelectSingleColumnContext<E> {
        private final QueryBuilder<E> queryBuilder = new QueryBuilder();

        private SelectSingleColumnContext(String columnName, boolean distinct, EntityBuilder<E> entityBuilder) {
            this.queryBuilder.fieldsToSelect = Collections.singletonList(columnName);
            this.queryBuilder.distinct = distinct;
            this.queryBuilder.entityBuilder = entityBuilder;
        }

        public SelectColumnsFromContext<E> from(String entityName) {
            this.queryBuilder.entityName = entityName;
            return new SelectColumnsFromContext(this.queryBuilder);
        }

        public SelectColumnsFromContext<E> from(NamedEntityBuilder<?> entityBuilder) {
            return this.from(entityBuilder.getEntityName());
        }
    }
}

