/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.dashboard;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.spi.DashboardStateStoreException;
import com.atlassian.gadgets.dashboard.spi.GadgetLayout;
import com.atlassian.gadgets.dashboard.spi.changes.AddGadgetChange;
import com.atlassian.gadgets.dashboard.spi.changes.DashboardChange;
import com.atlassian.gadgets.dashboard.spi.changes.GadgetColorChange;
import com.atlassian.gadgets.dashboard.spi.changes.RemoveGadgetChange;
import com.atlassian.gadgets.dashboard.spi.changes.UpdateGadgetUserPrefsChange;
import com.atlassian.gadgets.dashboard.spi.changes.UpdateLayoutChange;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationStore;

class JiraDashboardChangeVisitor
implements DashboardChange.Visitor {
    private final DashboardState updatedState;
    private final PortletConfigurationStore portletConfigurationStore;
    private final PortalPageStore portalPageStore;

    JiraDashboardChangeVisitor(DashboardState updatedState, PortletConfigurationStore portletConfigurationStore, PortalPageStore portalPageStore) {
        this.updatedState = updatedState;
        this.portletConfigurationStore = portletConfigurationStore;
        this.portalPageStore = portalPageStore;
    }

    public void accept(Iterable<DashboardChange> changes) {
        for (DashboardChange change : changes) {
            change.accept((DashboardChange.Visitor)this);
        }
    }

    public void visit(AddGadgetChange addGadgetChange) {
        DashboardState.ColumnIndex column = addGadgetChange.getColumnIndex();
        Iterable gadgets = this.updatedState.getGadgetsInColumn(column);
        GadgetState newGadgetState = addGadgetChange.getState();
        GadgetId newGadgetId = newGadgetState.getId();
        int row = 0;
        boolean skipGadget = true;
        for (GadgetState gadget : gadgets) {
            boolean isAddedGadget = gadget.getId().equals((Object)newGadgetId);
            if (isAddedGadget) {
                skipGadget = false;
                Long portalPageId = DashboardUtil.toLong((DashboardId)this.updatedState.getId());
                this.portletConfigurationStore.addGadget(portalPageId, DashboardUtil.toLong((GadgetId)newGadgetId), column.index(), row, newGadgetState.getGadgetSpecUri(), newGadgetState.getColor(), newGadgetState.getUserPrefs());
            } else if (!skipGadget) {
                this.portletConfigurationStore.updateGadgetPosition(DashboardUtil.toLong((GadgetId)gadget.getId()), row, column.index(), DashboardUtil.toLong((DashboardId)this.updatedState.getId()));
            }
            ++row;
        }
    }

    public void visit(GadgetColorChange gadgetColorChange) {
        Long gadgetId = DashboardUtil.toLong((GadgetId)gadgetColorChange.getGadgetId());
        PortletConfiguration portletConfiguration = this.portletConfigurationStore.getByPortletId(gadgetId);
        if (portletConfiguration == null) {
            throw new DashboardStateStoreException("Gadget with id '" + gadgetColorChange.getGadgetId() + "' not found for color change.");
        }
        this.portletConfigurationStore.updateGadgetColor(gadgetId, gadgetColorChange.getColor());
    }

    public void visit(RemoveGadgetChange removeGadgetChange) {
        PortletConfiguration gadgetToRemove = this.portletConfigurationStore.getByPortletId(DashboardUtil.toLong((GadgetId)removeGadgetChange.getGadgetId()));
        Iterable gadgets = this.updatedState.getGadgetsInColumn(DashboardState.ColumnIndex.from((int)gadgetToRemove.getColumn()));
        this.portletConfigurationStore.delete(gadgetToRemove);
        int row = 0;
        for (GadgetState gadget : gadgets) {
            this.portletConfigurationStore.updateGadgetPosition(DashboardUtil.toLong((GadgetId)gadget.getId()), row, gadgetToRemove.getColumn(), DashboardUtil.toLong((DashboardId)this.updatedState.getId()));
            ++row;
        }
    }

    public void visit(UpdateGadgetUserPrefsChange updateGadgetUserPrefsChange) {
        this.portletConfigurationStore.updateUserPrefs(DashboardUtil.toLong((GadgetId)updateGadgetUserPrefsChange.getGadgetId()), updateGadgetUserPrefsChange.getPrefValues());
    }

    public void visit(UpdateLayoutChange updateLayoutChange) {
        Long dashboardId = DashboardUtil.toLong((DashboardId)this.updatedState.getId());
        PortalPage portalPage = this.portalPageStore.getPortalPage(dashboardId);
        if (!portalPage.getLayout().equals((Object)updateLayoutChange.getLayout())) {
            this.portalPageStore.update(PortalPage.portalPage((PortalPage)portalPage).layout(updateLayoutChange.getLayout()).build());
        }
        GadgetLayout newLayout = updateLayoutChange.getGadgetLayout();
        for (int column = 0; column < newLayout.getNumberOfColumns(); ++column) {
            int row = 0;
            Iterable gadgets = newLayout.getGadgetsInColumn(column);
            for (GadgetId gadgetId : gadgets) {
                Long gadgetIdLong = DashboardUtil.toLong((GadgetId)gadgetId);
                PortletConfiguration portletConfiguration = this.portletConfigurationStore.getByPortletId(gadgetIdLong);
                if (portletConfiguration.getColumn() != column || portletConfiguration.getRow() != row) {
                    this.portletConfigurationStore.updateGadgetPosition(gadgetIdLong, row, column, dashboardId);
                }
                ++row;
            }
        }
    }
}

