/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.crowd.embedded.ofbiz.IdName;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.MembershipKey;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizInternalMembershipDao
implements InternalMembershipDao {
    private final OfBizDelegator ofBizDelegator;
    private Interner<String> myInterner = Interners.newWeakInterner();
    private final Cache<MembershipKey, Set<String>> parentsCache;
    private final Cache<MembershipKey, Set<String>> childrenCache;

    public OfBizInternalMembershipDao(OfBizDelegator ofBizDelegator, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.parentsCache = cacheManager.getCache(OfBizInternalMembershipDao.class.getName() + ".parentsCache", (CacheLoader)new parentsCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
        this.childrenCache = cacheManager.getCache(OfBizInternalMembershipDao.class.getName() + ".childrenCache", (CacheLoader)new childrenCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
    }

    @Override
    public boolean isUserDirectMember(long directoryId, String userName, String groupName) {
        Set parents = (Set)this.parentsCache.get((Object)MembershipKey.getKey(directoryId, userName, MembershipType.GROUP_USER));
        if (parents.contains(groupName)) {
            return true;
        }
        return parents.contains(IdentifierUtils.toLowerCase((String)groupName));
    }

    @Override
    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
    }

    private boolean isDirectMember(long directoryId, MembershipType membershipType, String parentName, String childName) {
        GenericValue genericValue = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).putCaseInsensitive("lowerChildName", childName).putCaseInsensitive("lowerParentName", parentName).put("membershipType", membershipType.name()).build()));
        return genericValue != null;
    }

    @Override
    public synchronized void addUserToGroup(long directoryId, IdName user, IdName group) throws MembershipAlreadyExistsException {
        if (this.isDirectMember(directoryId, MembershipType.GROUP_USER, group.getName(), user.getName())) {
            throw new MembershipAlreadyExistsException(directoryId, user.getName(), group.getName());
        }
        this.createMembership(directoryId, MembershipType.GROUP_USER, group, user);
        this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
    }

    private void createMembership(long directoryId, MembershipType membershipType, IdName parent, IdName child) {
        this.ofBizDelegator.createValue("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("childName", child.getName()).putCaseInsensitive("lowerChildName", child.getName()).put("parentId", parent.getId()).put("parentName", parent.getName()).putCaseInsensitive("lowerParentName", parent.getName()).put("membershipType", membershipType.name()).build());
    }

    @Override
    public void addGroupToGroup(long directoryId, IdName child, IdName parent) {
        if (!this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parent.getName(), child.getName())) {
            this.createMembership(directoryId, MembershipType.GROUP_GROUP, parent, child);
            this.invalidateChildrenCacheEntry(directoryId, parent.getName(), MembershipType.GROUP_GROUP);
            this.invalidateParentsCacheEntry(directoryId, child.getName(), MembershipType.GROUP_GROUP);
        }
    }

    @Override
    public synchronized void removeUserFromGroup(long directoryId, IdName user, IdName group) throws MembershipNotFoundException {
        this.removeMembership(directoryId, MembershipType.GROUP_USER, group, user);
        this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
    }

    private void removeMembership(long directoryId, MembershipType membershipType, IdName parent, IdName child) throws MembershipNotFoundException {
        GenericValue membershipGenericValue = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("parentId", parent.getId()).put("membershipType", membershipType.name()).build()));
        if (membershipGenericValue == null) {
            throw new MembershipNotFoundException(child.getName(), parent.getName());
        }
        this.ofBizDelegator.removeValue(membershipGenericValue);
    }

    @Override
    public void removeGroupFromGroup(long directoryId, IdName childGroup, IdName parentGroup) throws MembershipNotFoundException {
        this.removeMembership(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
        this.invalidateChildrenCacheEntry(directoryId, parentGroup.getName(), MembershipType.GROUP_GROUP);
        this.invalidateParentsCacheEntry(directoryId, childGroup.getName(), MembershipType.GROUP_GROUP);
    }

    @Override
    public void removeAllMembersFromGroup(Group group) {
        this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("parentName", group.getName()).build());
        this.removeGroupParentFromAllCaches(group.getDirectoryId(), group.getName());
    }

    @Override
    public void removeAllGroupMemberships(Group group) {
        this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("membershipType", MembershipType.GROUP_GROUP.name()).put("childName", group.getName()).build());
        this.removeGroupChildFromAllCaches(group.getDirectoryId(), group.getName());
    }

    @Override
    public void removeAllUserMemberships(User user) {
        this.removeAllUserMemberships(user.getDirectoryId(), user.getName());
    }

    @Override
    public void removeAllUserMemberships(long directoryId, String username) {
        this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("membershipType", MembershipType.GROUP_USER.name()).put("childName", username).build());
        this.removeUserFromAllCaches(directoryId, username);
    }

    @Override
    public List<String> search(long directoryId, MembershipQuery query) {
        if (this.canUseCacheSearch(query)) {
            return this.searchCache(directoryId, query);
        }
        PrimitiveMap.Builder filter = PrimitiveMap.builder();
        filter.put("directoryId", directoryId);
        if (query.isFindChildren()) {
            filter.putCaseInsensitive("lowerParentName", query.getEntityNameToMatch());
        } else {
            filter.putCaseInsensitive("lowerChildName", query.getEntityNameToMatch());
        }
        if (query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            filter.put("membershipType", MembershipType.GROUP_USER.name());
        } else {
            filter.put("membershipType", MembershipType.GROUP_GROUP.name());
        }
        List<GenericValue> memberships = this.findMemberships(filter.build());
        ArrayList<String> entityNames = new ArrayList<String>(memberships.size());
        for (GenericValue membership : memberships) {
            entityNames.add(query.isFindChildren() ? membership.getString("childName") : membership.getString("parentName"));
        }
        return entityNames;
    }

    private List<String> searchCache(long directoryId, MembershipQuery<?> query) {
        MembershipType type = query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user()) ? MembershipType.GROUP_USER : MembershipType.GROUP_GROUP;
        if (query.isFindChildren()) {
            return this.getChildrenOfGroupFromCache(directoryId, query.getEntityNameToMatch(), type);
        }
        return this.getParentsForMemberFromCache(directoryId, query.getEntityNameToMatch(), type);
    }

    private List<String> getParentsForMemberFromCache(long directoryId, String userName, MembershipType type) {
        Set parents = (Set)this.parentsCache.get((Object)MembershipKey.getKey(directoryId, userName, type));
        ArrayList<String> groupNames = new ArrayList<String>();
        if (parents != null) {
            for (String parent : parents) {
                groupNames.add(parent);
            }
        }
        return groupNames;
    }

    private List<String> getChildrenOfGroupFromCache(long directoryId, String groupName, MembershipType type) {
        Set children = (Set)this.childrenCache.get((Object)MembershipKey.getKey(directoryId, groupName, type));
        ArrayList<String> userNames = new ArrayList<String>();
        if (children != null) {
            for (String child : children) {
                userNames.add(child);
            }
        }
        return userNames;
    }

    private boolean canUseCacheSearch(MembershipQuery<?> query) {
        return query.getStartIndex() == 0 && query.getMaxResults() == -1;
    }

    private List<GenericValue> findMemberships(Map<String, Object> filter) {
        return this.ofBizDelegator.findByAnd("Membership", filter);
    }

    private Set<String> findChildren(long directoryId, MembershipType membershipType, String parent) {
        List memberships = this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("lowerParentName", parent).put("membershipType", membershipType.name()).build());
        HashSet children = Sets.newHashSetWithExpectedSize((int)memberships.size());
        for (GenericValue membership : memberships) {
            children.add(membership.getString("lowerChildName"));
        }
        return Collections.unmodifiableSet(children);
    }

    private Set<String> findParents(long directoryId, MembershipType membershipType, String child) {
        List memberships = this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("lowerChildName", child).put("membershipType", membershipType.name()).build());
        HashSet parents = Sets.newHashSetWithExpectedSize((int)memberships.size());
        for (GenericValue membership : memberships) {
            parents.add(membership.getString("lowerParentName"));
        }
        return Collections.unmodifiableSet(parents);
    }

    @Override
    public synchronized void flushCache() {
        this.parentsCache.removeAll();
        this.childrenCache.removeAll();
    }

    private void invalidateChildrenCacheEntry(Long directoryId, String parentName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, parentName, type);
        this.childrenCache.remove((Object)key);
    }

    private void invalidateParentsCacheEntry(Long directoryId, String childName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, childName, type);
        this.parentsCache.remove((Object)key);
    }

    private void removeUserFromAllCaches(Long directoryId, String userName) {
        List<String> groups = this.getParentsForMemberFromCache(directoryId, userName, MembershipType.GROUP_USER);
        for (String groupName : groups) {
            this.invalidateChildrenCacheEntry(directoryId, groupName, MembershipType.GROUP_USER);
            this.invalidateParentsCacheEntry(directoryId, userName, MembershipType.GROUP_USER);
        }
    }

    private void removeGroupParentFromAllCaches(Long directoryId, String groupName) {
        List<String> users = this.getChildrenOfGroupFromCache(directoryId, groupName, MembershipType.GROUP_USER);
        for (String userName : users) {
            this.invalidateChildrenCacheEntry(directoryId, groupName, MembershipType.GROUP_USER);
            this.invalidateParentsCacheEntry(directoryId, userName, MembershipType.GROUP_USER);
        }
        List<String> childGroups = this.getChildrenOfGroupFromCache(directoryId, groupName, MembershipType.GROUP_GROUP);
        for (String childName : childGroups) {
            this.invalidateChildrenCacheEntry(directoryId, groupName, MembershipType.GROUP_GROUP);
            this.invalidateParentsCacheEntry(directoryId, childName, MembershipType.GROUP_GROUP);
        }
    }

    private void removeGroupChildFromAllCaches(Long directoryId, String groupName) {
        List<String> parentGroups = this.getParentsForMemberFromCache(directoryId, groupName, MembershipType.GROUP_GROUP);
        for (String parentName : parentGroups) {
            this.invalidateChildrenCacheEntry(directoryId, parentName, MembershipType.GROUP_GROUP);
            this.invalidateParentsCacheEntry(directoryId, groupName, MembershipType.GROUP_GROUP);
        }
    }

    private class childrenCacheLoader
    implements CacheLoader<MembershipKey, Set<String>> {
        private childrenCacheLoader() {
        }

        public Set<String> load(@NotNull MembershipKey key) {
            return OfBizInternalMembershipDao.this.findChildren(key.getDirectoryId(), key.getType(), key.getName());
        }
    }

    private class parentsCacheLoader
    implements CacheLoader<MembershipKey, Set<String>> {
        private parentsCacheLoader() {
        }

        public Set<String> load(@NotNull MembershipKey key) {
            return OfBizInternalMembershipDao.this.findParents(key.getDirectoryId(), key.getType(), key.getName());
        }
    }
}

