/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUserDao;
import com.atlassian.jira.exception.DataAccessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OfBizDelegatingMembershipDao
implements MembershipDao {
    private final InternalMembershipDao membershipDao;
    private final OfBizGroupDao groupDao;
    private final OfBizUserDao userDao;

    public OfBizDelegatingMembershipDao(InternalMembershipDao membershipDao, UserDao userDao, GroupDao groupDao) {
        this.membershipDao = membershipDao;
        this.groupDao = (OfBizGroupDao)groupDao;
        this.userDao = (OfBizUserDao)userDao;
    }

    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws GroupNotFoundException {
        BatchResult result = new BatchResult(userNames.size());
        for (String userName : userNames) {
            try {
                this.addUserToGroup(directoryId, userName, groupName);
                result.addSuccess((Object)userName);
            }
            catch (UserNotFoundException e) {
                result.addFailure((Object)userName);
            }
            catch (DataAccessException e) {
                result.addFailure((Object)userName);
            }
            catch (MembershipAlreadyExistsException e) {
                result.addFailure((Object)userName);
            }
        }
        return result;
    }

    public boolean isUserDirectMember(long directoryId, String userName, String groupName) {
        return this.membershipDao.isUserDirectMember(directoryId, userName, groupName);
    }

    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.membershipDao.isGroupDirectMember(directoryId, childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String user, String group) throws UserNotFoundException, GroupNotFoundException, MembershipAlreadyExistsException {
        OfBizUser idUser = this.userDao.findByName(directoryId, user);
        OfBizGroup idGroup = this.groupDao.findByName(directoryId, group);
        this.membershipDao.addUserToGroup(directoryId, idUser, idGroup);
    }

    public void addGroupToGroup(long directoryId, String child, String parent) throws GroupNotFoundException {
        OfBizGroup idChild = this.groupDao.findByName(directoryId, child);
        OfBizGroup idParent = this.groupDao.findByName(directoryId, parent);
        this.membershipDao.addGroupToGroup(directoryId, idChild, idParent);
    }

    public void removeUserFromGroup(long directoryId, String user, String group) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException {
        OfBizUser idUser = this.userDao.findByName(directoryId, user);
        OfBizGroup idGroup = this.groupDao.findByName(directoryId, group);
        this.membershipDao.removeUserFromGroup(directoryId, idUser, idGroup);
    }

    public void removeGroupFromGroup(long directoryId, String child, String parent) throws GroupNotFoundException, MembershipNotFoundException {
        OfBizGroup idChild = this.groupDao.findByName(directoryId, child);
        OfBizGroup idParent = this.groupDao.findByName(directoryId, parent);
        this.membershipDao.removeGroupFromGroup(directoryId, idChild, idParent);
    }

    public <T> List<T> search(long directoryId, MembershipQuery<T> query) {
        return this.result(directoryId, query, this.membershipDao.search(directoryId, query));
    }

    public void flushCache() {
        this.membershipDao.flushCache();
    }

    private <T> List<T> result(long directoryId, MembershipQuery<T> query, List<String> entityNames) throws IllegalStateException {
        if (query.getReturnType().isAssignableFrom(String.class)) {
            ArrayList<String> typedResults = new ArrayList<String>(entityNames.size());
            for (String name : entityNames) {
                if (query.getEntityToReturn().equals((Object)EntityDescriptor.user())) {
                    try {
                        OfBizUser ofBizUser = this.userDao.findByName(directoryId, name);
                        typedResults.add(ofBizUser.getName());
                    }
                    catch (UserNotFoundException ex) {
                        // empty catch block
                    }
                }
                if (!query.getEntityToReturn().equals((Object)EntityDescriptor.group())) continue;
                try {
                    OfBizGroup ofBizGroup = this.groupDao.findByName(directoryId, name);
                    typedResults.add(ofBizGroup.getName());
                }
                catch (GroupNotFoundException ex) {}
            }
            return typedResults;
        }
        if (query.getReturnType().isAssignableFrom(User.class)) {
            ArrayList<OfBizUser> typedResults = new ArrayList<OfBizUser>(entityNames.size());
            for (String userName : entityNames) {
                try {
                    typedResults.add(this.userDao.findByName(directoryId, userName));
                }
                catch (UserNotFoundException ex) {}
            }
            return typedResults;
        }
        if (query.getReturnType().isAssignableFrom(Group.class)) {
            ArrayList<OfBizGroup> typedResults = new ArrayList<OfBizGroup>(entityNames.size());
            for (String groupName : entityNames) {
                try {
                    typedResults.add(this.groupDao.findByName(directoryId, groupName));
                }
                catch (GroupNotFoundException ex) {}
            }
            return typedResults;
        }
        throw new IllegalArgumentException("Class type '" + query.getReturnType() + "' for return values is not 'String', 'User' or 'Group'");
    }
}

