/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntity;
import java.io.Serializable;
import org.apache.commons.lang.builder.HashCodeBuilder;

final class DirectoryEntityKey
implements Serializable {
    private final long directoryId;
    private final String name;

    public static DirectoryEntityKey getKeyPreserveCase(long directoryId, String name) {
        return new DirectoryEntityKey(directoryId, name);
    }

    public static DirectoryEntityKey getKeyLowerCase(long directoryId, String name) {
        return new DirectoryEntityKey(directoryId, IdentifierUtils.toLowerCase((String)name));
    }

    public static DirectoryEntityKey getKeyLowerCase(DirectoryEntity entity) {
        return new DirectoryEntityKey(entity.getDirectoryId(), IdentifierUtils.toLowerCase((String)entity.getName()));
    }

    private DirectoryEntityKey(long directoryId, String name) {
        this.directoryId = directoryId;
        this.name = name;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryEntityKey)) {
            return false;
        }
        DirectoryEntityKey other = (DirectoryEntityKey)o;
        return this.directoryId == other.getDirectoryId() && this.name.equals(other.getName());
    }

    public final int hashCode() {
        return new HashCodeBuilder(1, 31).append(this.directoryId).append((Object)this.name).toHashCode();
    }

    public String toString() {
        return "{" + this.directoryId + "," + this.name + '}';
    }
}

