/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.db.DatabaseConfig;
import com.atlassian.jira.configurator.db.DatabaseInstance;
import com.atlassian.jira.exception.ParseException;

public class OracleDatabaseConfig
implements DatabaseConfig {
    @Override
    public String getDatabaseType() {
        return "Oracle";
    }

    @Override
    public String getInstanceFieldName() {
        return "SID";
    }

    @Override
    public String getClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public String getUrl(String hostname, String port, String instance) {
        return "jdbc:oracle:thin:@//" + hostname.trim() + ':' + port.trim() + "/" + instance.trim();
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        DatabaseInstance oracleConnectionProperties = new DatabaseInstance();
        if (!jdbcUrl.startsWith("jdbc:oracle:thin:")) {
            throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. It should start with protocol prefix 'jdbc:oracle:thin:'.");
        }
        String stripped = jdbcUrl.substring("jdbc:oracle:thin:".length());
        String[] split = stripped.split("@", 2);
        if (split.length == 1) {
            throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Expected to find a '@' before the host name.");
        }
        String props = split[1];
        if (props.startsWith("//")) {
            String[] hostPort_Sid = (props = props.substring(2)).split("/", 2);
            if (hostPort_Sid.length == 1) {
                throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Missing '/' before the SID.");
            }
            oracleConnectionProperties.setInstance(hostPort_Sid[1]);
            String[] hostPort = hostPort_Sid[0].split(":");
            oracleConnectionProperties.setHostname(hostPort[0]);
            if (hostPort.length == 1) {
                oracleConnectionProperties.setPort("");
            } else {
                oracleConnectionProperties.setPort(hostPort[1]);
            }
        } else {
            String[] host_Port_Sid = props.split(":", 3);
            if (host_Port_Sid.length == 1) {
                throw new ParseException("Unable to parse the Oracle JDBC URL '" + jdbcUrl + "'. Missing ':' before the SID.");
            }
            if (host_Port_Sid.length == 2) {
                oracleConnectionProperties.setHostname(host_Port_Sid[0]);
                oracleConnectionProperties.setPort("");
                oracleConnectionProperties.setInstance(host_Port_Sid[1]);
            } else {
                oracleConnectionProperties.setHostname(host_Port_Sid[0]);
                oracleConnectionProperties.setPort(host_Port_Sid[1]);
                oracleConnectionProperties.setInstance(host_Port_Sid[2]);
            }
        }
        return oracleConnectionProperties;
    }
}

