/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.console;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.configurator.config.ComplexConfigurationReason;
import com.atlassian.jira.configurator.config.FileExistanceWithCancelOptionValidator;
import com.atlassian.jira.configurator.config.FileSystem;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SslSettings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.config.Validator;
import com.atlassian.jira.configurator.config.WebServerProfile;
import com.atlassian.jira.configurator.console.ConsoleProvider;
import com.atlassian.jira.configurator.console.ConsoleToolkit;
import com.atlassian.jira.configurator.ssl.CertificateDetails;
import com.atlassian.jira.configurator.ssl.CertificatePrettyPrinter;
import com.atlassian.jira.configurator.ssl.KeyStoreAccessor;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class WebServerConfigurationConsole {
    private static final String SSL_DETAILS_URL = "https://confluence.atlassian.com/display/JIRA/Running+JIRA+over+SSL+or+HTTPS";
    static final String MENU_CHOICE_MAIN_MENU = "Web Server";
    static final char MENU_ITEM_CHANGE_PROFILE = 'P';
    static final String MENU_CHOICE_SELECT_PROFILE = "Profile (leave blank to exit)";
    static final char MENU_ITEM_CONF_HTTP = 'H';
    static final String INPUT_HTTP_PORT = "HTTP Port";
    static final char MENU_ITEM_CONF_SSL = 'S';
    static final String MENU_CHOICE_SELECT_KEY_STORE = "Keystore";
    static final char MENU_ITEM_SYSTEM_KEY_STORE = 'S';
    static final char MENU_ITEM_USER_DEFINED_KEY_STORE = 'U';
    static final char MENU_ITEM_CURRENT_KEY_STORE = 'C';
    static final String INPUT_KEY_STORE_FILE_NAME = "Keystore Path (leave blank to exit)";
    static final String INPUT_KEY_STORE_PASSWORD = "Keystore Password";
    static final String INPUT_KEY_ALIAS = "Key Alias";
    static final String INPUT_HTTPS_PORT = "HTTPs Port";
    static final String YES_NO_USE_CERTIFICATE = "Do you want to use this certificate?";
    static final String YES_NO_CERT_NOT_FOUND_TRY_AGAIN = "The referenced certificate could not be found or accessed. Do you want to try again?";
    static final char MENU_ITEM_EXIT = 'X';
    private final ConsoleProvider console;
    private final ConsoleToolkit consoleToolkit;
    private final KeyStoreAccessor keyStoreAccessor;
    private final FileSystem fileSystem;
    private final Settings settings;

    public WebServerConfigurationConsole(@Nonnull ConsoleProvider console, @Nonnull KeyStoreAccessor keyStoreAccessor, @Nonnull FileSystem fileSystem, @Nonnull Settings settings) {
        this.console = console;
        this.consoleToolkit = new ConsoleToolkit(console);
        this.keyStoreAccessor = keyStoreAccessor;
        this.fileSystem = fileSystem;
        this.settings = settings;
    }

    public void showSettings() throws IOException {
        do {
            SslSettings sslSettings = this.settings.getSslSettings();
            WebServerProfile webServerProfile = this.settings.getWebServerProfile();
            List<ComplexConfigurationReason> reasons = this.settings.getComplexConfigurationReasons();
            this.console.println();
            this.console.println("--- Web Server Configuration ---");
            if (!reasons.isEmpty()) {
                this.console.println();
                this.console.println("Warning: It has been detected, that the current configuration is too complex or partly not supported to offer all options. The following items have been identified:");
                for (ComplexConfigurationReason reason : reasons) {
                    this.console.println("* " + reason.getDescription());
                }
                this.console.println();
            }
            this.console.println("  Control Port  : " + StringUtils.defaultString((String)this.settings.getControlPort(), (String)"N/A"));
            this.console.println("  Profile       : " + webServerProfile.getLabel());
            if (webServerProfile.isHttpEnabled()) {
                this.console.println("  HTTP Port     : " + this.settings.getHttpPort());
            }
            if (webServerProfile.isHttpsEnabled() && sslSettings != null) {
                this.console.println("  HTTPs Port    : " + sslSettings.getHttpsPort());
                this.console.println("  Keystore Path : " + Strings.nullToEmpty((String)sslSettings.getKeystoreFile()));
                this.console.println("  Key Alias     : " + Strings.nullToEmpty((String)sslSettings.getKeyAlias()));
            }
            this.console.println();
            this.consoleToolkit.showMenuItem('P', "Change the Profile (enable/disable HTTP/HTTPs)");
            if (webServerProfile.isHttpEnabled()) {
                this.consoleToolkit.showMenuItem('H', "Configure HTTP Port");
            }
            if (webServerProfile.isHttpsEnabled()) {
                this.consoleToolkit.showMenuItem('S', "Configure SSL Encryption (requires an installed X509 certificate)");
            }
            this.consoleToolkit.showMenuItem('X', "Return to Main Menu");
            this.console.println();
        } while (this.processWebServerSettings());
    }

    private boolean processWebServerSettings() throws IOException {
        char ch;
        WebServerProfile profile = this.settings.getWebServerProfile();
        block8: while (true) {
            ch = this.consoleToolkit.readMenuChoice(MENU_CHOICE_MAIN_MENU);
            switch (ch) {
                case '\n': 
                case '\r': {
                    continue block8;
                }
                case '?': {
                    return true;
                }
                case 'X': {
                    return false;
                }
                case 'P': {
                    this.showChangeProfile();
                    return true;
                }
                case 'H': {
                    if (profile.isHttpEnabled()) {
                        this.showUpdateHttpConfiguration();
                    } else {
                        this.printUnknownCommand(ch);
                    }
                    return true;
                }
                case 'S': {
                    if (profile.isHttpsEnabled()) {
                        this.updateHttpsConfiguration();
                    } else {
                        this.printUnknownCommand(ch);
                    }
                    return true;
                }
            }
            break;
        }
        this.printUnknownCommand(ch);
        return true;
    }

    private void showChangeProfile() throws IOException {
        WebServerProfile currentProfile = this.settings.getWebServerProfile();
        this.console.println();
        this.console.println("To change the web server profile, please select one of the following options. The current profile is: " + currentProfile.getLabel() + ".");
        WebServerProfile newProfile = this.askForWebServerProfile();
        if (newProfile == null) {
            return;
        }
        String httpPort = null;
        if (newProfile.isHttpEnabled()) {
            if (!currentProfile.isHttpEnabled()) {
                httpPort = this.showEnterHttpConfiguration();
            } else {
                this.console.println("Using currently configured HTTP port: " + this.settings.getHttpPort());
                httpPort = this.settings.getHttpPort();
            }
        }
        SslSettings sslSettings = null;
        if (newProfile.isHttpsEnabled()) {
            if (!currentProfile.isHttpsEnabled()) {
                Result<SslSettings> sslSettingsResult = this.showUpdateHttpsConfiguration();
                if (!sslSettingsResult.hasResult()) {
                    this.console.println("The HTTPs configuration is not complete, aborting the profile change.");
                    return;
                }
                sslSettings = sslSettingsResult.getValue();
            } else {
                this.console.println("Using currently configured SSL settings");
                sslSettings = this.settings.getSslSettings();
            }
        }
        this.settings.updateWebServerConfiguration(httpPort, sslSettings);
        this.console.println();
        this.console.println("Updated the profile to '" + newProfile.getLabel() + "'. Remember to save the changes on exit.");
    }

    private WebServerProfile askForWebServerProfile() throws IOException {
        List<WebServerProfile> filteredProfiles = WebServerProfile.getUsableProfiles(this.settings);
        SortedMap<Character, WebServerProfile> profileSelectionMap = this.createProfileSelectionMap(filteredProfiles);
        while (true) {
            this.console.println();
            for (Map.Entry<Character, WebServerProfile> usableProfileEntry : profileSelectionMap.entrySet()) {
                Character menuKey = usableProfileEntry.getKey();
                WebServerProfile profile = usableProfileEntry.getValue();
                this.consoleToolkit.showMenuItem(menuKey.charValue(), profile.getLabel());
            }
            char profile = this.consoleToolkit.readMenuChoice(MENU_CHOICE_SELECT_PROFILE);
            if (profile == '\r' || profile == '\n') {
                return null;
            }
            if (profileSelectionMap.containsKey(Character.valueOf(profile))) {
                return (WebServerProfile)((Object)profileSelectionMap.get(Character.valueOf(profile)));
            }
            this.printUnknownCommand(profile);
        }
    }

    private SortedMap<Character, WebServerProfile> createProfileSelectionMap(List<WebServerProfile> filteredProfiles) {
        TreeMap<Character, WebServerProfile> profileSelectionMap = new TreeMap<Character, WebServerProfile>();
        for (int i = 0; i < filteredProfiles.size(); ++i) {
            Character key = Character.valueOf(Integer.toString(i + 1).charAt(0));
            WebServerProfile webServerProfile = filteredProfiles.get(i);
            profileSelectionMap.put(key, webServerProfile);
        }
        return profileSelectionMap;
    }

    private void showUpdateHttpConfiguration() throws IOException {
        this.console.println();
        this.console.println("You can update the HTTP port to a new value. The current port is: " + this.settings.getHttpPort());
        String s = this.processUpdateHttpConfiguration();
        if (s != null) {
            this.settings.setHttpPort(s);
            this.console.println();
            this.console.println("Updated the HTTP port to " + s + ". Remember to save the changes on exit.");
        }
    }

    private String showEnterHttpConfiguration() throws IOException {
        this.console.println();
        this.console.println("There is currently no HTTP port set. Please enter the port you want to use.");
        return this.processUpdateHttpConfiguration();
    }

    private String processUpdateHttpConfiguration() throws IOException {
        int newHttpPort;
        Integer httpsPort;
        int controlPort = Integer.parseInt(this.settings.getControlPort());
        SslSettings sslSettings = this.settings.getSslSettings();
        Integer n = httpsPort = sslSettings != null ? Integer.valueOf(Integer.parseInt(sslSettings.getHttpsPort())) : null;
        while (true) {
            if ((newHttpPort = this.consoleToolkit.askFor(INPUT_HTTP_PORT, Validator.PORT).intValue()) == controlPort) {
                this.console.printErrorMessage("The entered port is already used by the control port. Please pick a different port.");
                continue;
            }
            if (httpsPort == null || newHttpPort != httpsPort) break;
            this.console.printErrorMessage("The entered port is already used by the HTTPs port. Please pick a different port.");
        }
        return Integer.toString(newHttpPort);
    }

    private void updateHttpsConfiguration() throws IOException {
        Result<SslSettings> httpsConfigurationResult = this.showUpdateHttpsConfiguration();
        if (httpsConfigurationResult.hasResult()) {
            this.settings.setSslSettings(httpsConfigurationResult.getValue());
            this.console.println();
            this.console.println("Updated the SSL encryption settings. Remember to save the changes on exit.");
        }
    }

    private Result<SslSettings> showUpdateHttpsConfiguration() throws IOException {
        this.console.println();
        this.console.println("The next steps gather all required information to set up the HTTPs port (HTTP over SSL encryption). First of all, you need provide a so called key store containing the private key and the signed certificate. This can be either self-signed or obtained from a certified authority (CA). For more information, please see the link below. In order to verify the entered information, this tool will access the key store and print the certificate found.");
        this.console.println();
        this.console.println(SSL_DETAILS_URL);
        CertificateDetails certificateDetails = this.askForKeyStoreDetailsOrCancel();
        if (certificateDetails == null) {
            return Result.noResult();
        }
        int httpsPort = this.consoleToolkit.askFor(INPUT_HTTPS_PORT, Validator.PORT);
        SslSettings newSslSettings = new SslSettings(Integer.toString(httpsPort), certificateDetails.getKeyStoreLocation(), certificateDetails.getKeyStorePassword(), "JKS", certificateDetails.getKeyAlias());
        return new Result<SslSettings>(newSslSettings);
    }

    private CertificateDetails askForKeyStoreDetailsOrCancel() throws IOException {
        while (true) {
            String alias;
            String keystoreLocation;
            if ((keystoreLocation = this.askForKeyStoreLocationOrCancel()) == null) {
                return null;
            }
            String keyStorePassword = this.consoleToolkit.askForPassword(INPUT_KEY_STORE_PASSWORD, Validator.NON_EMTPY_STRING);
            CertificateDetails certificateDetails = new CertificateDetails(keystoreLocation, keyStorePassword, alias = this.consoleToolkit.askFor(INPUT_KEY_ALIAS, Validator.NON_EMTPY_STRING));
            X509Certificate x509Certificate = this.loadCertificate(certificateDetails);
            if (x509Certificate != null) {
                this.console.println();
                this.console.println("The following certificate was found:");
                this.console.println();
                this.console.println(CertificatePrettyPrinter.prettyPrint(x509Certificate));
                boolean correctCertificate = this.console.readYesNo(YES_NO_USE_CERTIFICATE, Boolean.TRUE);
                if (!correctCertificate) continue;
                return certificateDetails;
            }
            boolean tryAgain = this.console.readYesNo(YES_NO_CERT_NOT_FOUND_TRY_AGAIN, Boolean.TRUE);
            if (!tryAgain) break;
        }
        return null;
    }

    private String askForKeyStoreLocationOrCancel() throws IOException {
        File caCertsPath = this.getCaCertsPath();
        String canonicalCaCertsPath = caCertsPath.getCanonicalPath();
        SslSettings sslSettings = this.settings.getSslSettings();
        boolean hasExistingKeyStoreFileName = sslSettings != null && !Strings.nullToEmpty((String)sslSettings.getKeystoreFile()).isEmpty();
        block6: while (true) {
            this.console.println();
            this.console.println("Please select the keystore from the options below. It must contain the certificate and the private key to be used.");
            this.consoleToolkit.showMenuItem('S', String.format("The system-wide Java keystore (%s)", canonicalCaCertsPath));
            this.consoleToolkit.showMenuItem('U', "User-defined location");
            if (hasExistingKeyStoreFileName) {
                this.consoleToolkit.showMenuItem('C', String.format("The currently configured (%s)", sslSettings.getKeystoreFile()));
            }
            char keystore = this.consoleToolkit.readMenuChoice(MENU_CHOICE_SELECT_KEY_STORE);
            switch (keystore) {
                case '\n': 
                case '\r': {
                    continue block6;
                }
                case 'S': {
                    return canonicalCaCertsPath;
                }
                case 'U': {
                    return this.askForUserDefinedKeyStorePathOrCancel();
                }
                case 'C': {
                    if (!hasExistingKeyStoreFileName) break;
                    return sslSettings.getKeystoreFile();
                }
            }
            this.printUnknownCommand(keystore);
        }
    }

    private void printUnknownCommand(char ch) {
        this.console.println("Unknown command '" + ch + "'");
    }

    private File getCaCertsPath() {
        String javaHome = JiraSystemProperties.getInstance().getProperty("java.home");
        String caCertsPathAsText = Joiner.on((char)File.separatorChar).join((Iterable)Lists.newArrayList((Object[])new String[]{javaHome, "lib", "security", "cacerts"}));
        return new File(caCertsPathAsText);
    }

    @Nullable
    public X509Certificate loadCertificate(@Nonnull CertificateDetails certificateDetails) {
        try {
            return this.keyStoreAccessor.loadCertificate(certificateDetails);
        }
        catch (UnrecoverableEntryException e) {
            this.console.printErrorMessage("The entered password is valid for the key store, but not for the private key. You need to synchronize both passwords in order to proceed.");
            return null;
        }
        catch (Exception e) {
            this.console.printErrorMessage(e);
            return null;
        }
    }

    private String askForUserDefinedKeyStorePathOrCancel() throws IOException {
        FileExistanceWithCancelOptionValidator validator = new FileExistanceWithCancelOptionValidator(this.fileSystem);
        while (true) {
            try {
                return (String)((Validator)validator).apply("Keystore Path", this.console.readLine(INPUT_KEY_STORE_FILE_NAME));
            }
            catch (ValidationException e) {
                this.console.printErrorMessage(e);
                continue;
            }
            break;
        }
    }

    private static class Result<T> {
        private final boolean hasResult;
        private final T value;

        public Result(@Nullable T value) {
            this.hasResult = true;
            this.value = value;
        }

        private Result() {
            this.hasResult = false;
            this.value = null;
        }

        public boolean hasResult() {
            return this.hasResult;
        }

        @Nullable
        public T getValue() {
            return this.value;
        }

        public static <T> Result<T> noResult() {
            return new Result<T>();
        }
    }
}

