/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.Datasource;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.JndiDatasource;
import com.atlassian.jira.configurator.config.ComplexConfigurationReason;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.JiraHomeDatabaseConfigurationLoader;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SslSettings;
import com.atlassian.jira.configurator.config.WebServerProfile;
import com.atlassian.jira.exception.ParseException;
import com.atlassian.security.xml.SecureXmlParserFactory;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingsLoader {
    private static final String DEV_MODE_SERVER_XML = "target/tomcat7/work/conf/server.xml";
    static final String SECURITY_CONSTRAINT_NAME = "HTTP to HTTPs Redirection";
    private static final boolean devMode = new File("target/tomcat7/work/conf/server.xml").exists();

    public static Settings loadCurrentSettings() throws ParserConfigurationException, IOException, SAXException, ParseException {
        Settings settings = new Settings();
        SettingsLoader.loadApplicationProperties(settings);
        SettingsLoader.loadDbConfig(settings);
        SettingsLoader.loadServerXmlSettings(settings);
        SettingsLoader.loadWebXml(settings);
        return settings;
    }

    private static void loadWebXml(@Nonnull Settings settings) throws IOException, ParseException {
        String webXmlPath = SettingsLoader.getWebXmlPath();
        Document doc = SettingsLoader.parseDocument(webXmlPath);
        SettingsLoader.checkExistingSecurityConstraints(doc, settings);
    }

    private static void checkExistingSecurityConstraints(@Nonnull Document doc, @Nonnull Settings settings) throws ParseException {
        Node webAppNode = SettingsLoader.getOnlyChildNode(doc, "web-app");
        int securityConstraintNodeCount = SettingsLoader.countSecurityConstraints(webAppNode);
        if (securityConstraintNodeCount == 1) {
            Node redirectionSecurityConstraint = SettingsLoader.findSecurityConstraint(webAppNode);
            if (redirectionSecurityConstraint == null) {
                settings.addComplexConfigurationReason(ComplexConfigurationReason.AnotherSecurityConstraintExisting);
            }
        } else if (securityConstraintNodeCount > 1) {
            settings.addComplexConfigurationReason(ComplexConfigurationReason.AnotherSecurityConstraintExisting);
        }
    }

    public static void saveSettings(Settings newSettings) throws IOException, ParseException {
        SettingsLoader.saveSettingsToApplicationProperties(newSettings);
        SettingsLoader.saveSettingsToServerXml(newSettings);
        SettingsLoader.saveDbConfig(newSettings);
        SettingsLoader.updateWebXml(newSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"PATH_TRAVERSAL_OUT"}, justification="Only writes a configuration file to a hard-coded location.")
    private static void saveSettingsToApplicationProperties(Settings newSettings) throws IOException {
        if (newSettings.getJiraHome() == null || newSettings.getJiraHome().trim().length() == 0) {
            throw new IOException("Please set a value for jira-home.");
        }
        File jiraHomeDirectory = new File(newSettings.getJiraHome());
        if (jiraHomeDirectory.exists()) {
            if (!jiraHomeDirectory.isDirectory()) {
                throw new IOException("jira-home '" + newSettings.getJiraHome() + "' is not a directory.");
            }
        } else {
            boolean created = jiraHomeDirectory.mkdirs();
            if (!created) {
                throw new IOException("Unable to create jira-home '" + newSettings.getJiraHome() + "'");
            }
        }
        BufferedReader reader = new BufferedReader(new FileReader(SettingsLoader.getJiraApplicationProperties()));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean jiraHomeSet = false;
            while ((line = reader.readLine()) != null) {
                if (SettingsLoader.isJiraHomeProperty(line)) {
                    sb.append("jira.home = ").append(SettingsLoader.encodeForPropertiesFile(newSettings.getJiraHome())).append("\n");
                    jiraHomeSet = true;
                    continue;
                }
                sb.append(line).append("\n");
            }
            if (!jiraHomeSet) {
                throw new IOException("Unable to find the jira.home property to replace in the jira.application.properties file (" + SettingsLoader.getJiraApplicationProperties() + ").");
            }
        }
        finally {
            reader.close();
        }
        FileWriter writer = new FileWriter(SettingsLoader.getJiraApplicationProperties());
        try {
            writer.write(sb.toString());
        }
        finally {
            writer.close();
        }
    }

    private static String encodeForPropertiesFile(String value) {
        return value.replace("\\", "\\\\");
    }

    private static boolean isJiraHomeProperty(String line) {
        if (line.startsWith("jira.home")) {
            String value = line.substring("jira.home".length());
            if ((value = value.trim()).startsWith("=")) {
                return true;
            }
        }
        return false;
    }

    private static void saveSettingsToServerXml(Settings newSettings) throws IOException {
        Document doc;
        try {
            doc = SettingsLoader.parseDocument(SettingsLoader.getServerXmlFile());
            SettingsLoader.saveNetworkingSettingsToServerXml(newSettings, doc);
        }
        catch (Exception ex) {
            String message = "An error occured while trying to save settings. Your settings may be in an invalid state.";
            if (ex.getMessage() != null) {
                message = message + " " + ex.getMessage();
            }
            throw new IOException(message);
        }
        SettingsLoader.writeXmlFile(doc, SettingsLoader.getServerXmlFile());
    }

    private static void updateWebXml(@Nonnull Settings newSettings) throws IOException, ParseException {
        String webXmlPath = SettingsLoader.getWebXmlPath();
        Document doc = SettingsLoader.parseDocument(webXmlPath);
        boolean isDirty = SettingsLoader.updateSecurityConstraint(newSettings, doc);
        if (isDirty) {
            SettingsLoader.writeXmlFile(doc, webXmlPath);
        }
    }

    static void saveNetworkingSettingsToServerXml(Settings newSettings, Document doc) throws ParseException {
        Node serverNode = SettingsLoader.getOnlyChildNode(doc, "Server");
        SettingsLoader.addAttributeToNode(serverNode, "port", newSettings.getControlPort());
        Node serviceNode = SettingsLoader.getOnlyChildNode(serverNode, "Service");
        SettingsLoader.updateHttpConnector(newSettings, serviceNode);
        SettingsLoader.updateHttpsConnector(newSettings, serviceNode);
    }

    static boolean updateSecurityConstraint(@Nonnull Settings newSettings, @Nonnull Document doc) throws ParseException {
        Node webAppNode = SettingsLoader.getOnlyChildNode(doc, "web-app");
        int securityConstraintNodeNumber = SettingsLoader.countSecurityConstraints(webAppNode);
        Node securityConstraintNode = SettingsLoader.findSecurityConstraint(webAppNode);
        WebServerProfile webServerProfile = newSettings.getWebServerProfile();
        if (webServerProfile == WebServerProfile.HttpRedirectedToHttps) {
            if (securityConstraintNode == null && securityConstraintNodeNumber == 0) {
                webAppNode.appendChild(SettingsLoader.createSecurityConstraintNode(doc));
                return true;
            }
        } else if (securityConstraintNode != null) {
            webAppNode.removeChild(securityConstraintNode);
            return true;
        }
        return false;
    }

    private static int countSecurityConstraints(@Nullable Node webAppNode) {
        if (webAppNode != null) {
            return SettingsLoader.getChildNodes(webAppNode, "security-constraint").size();
        }
        return 0;
    }

    @Nullable
    private static Node findSecurityConstraint(@Nullable Node webAppNode) throws ParseException {
        if (webAppNode == null) {
            return null;
        }
        List<Node> securityConstraintNodes = SettingsLoader.getChildNodes(webAppNode, "security-constraint");
        for (Node securityConstraintNode : securityConstraintNodes) {
            String displayNameText;
            Node displayNameNode = SettingsLoader.getOnlyChildNode(securityConstraintNode, "display-name");
            if (displayNameNode == null || !SECURITY_CONSTRAINT_NAME.equals(displayNameText = Strings.nullToEmpty((String)displayNameNode.getTextContent()).trim())) continue;
            return securityConstraintNode;
        }
        return null;
    }

    private static Node createSecurityConstraintNode(@Nonnull Document doc) {
        return SettingsLoader.addToNode(doc.createElement("security-constraint"), SettingsLoader.addToNode(SettingsLoader.createElementWithTextContent(doc, "display-name", SECURITY_CONSTRAINT_NAME), new Node[0]), SettingsLoader.addToNode(doc.createElement("web-resource-collection"), SettingsLoader.createElementWithTextContent(doc, "web-resource-name", "all-except-attachments"), SettingsLoader.createElementWithTextContent(doc, "url-pattern", "*.jsp"), SettingsLoader.createElementWithTextContent(doc, "url-pattern", "*.jspa"), SettingsLoader.createElementWithTextContent(doc, "url-pattern", "/browse/*")), SettingsLoader.addToNode(doc.createElement("user-data-constraint"), SettingsLoader.createElementWithTextContent(doc, "transport-guarantee", "CONFIDENTIAL")));
    }

    private static Node addToNode(@Nonnull Node parent, Node ... nodes) {
        for (Node node : nodes) {
            parent.appendChild(node);
        }
        return parent;
    }

    private static Element createElementWithTextContent(@Nonnull Document doc, @Nonnull String tagName, @Nonnull String textContent) {
        Element element = doc.createElement(tagName);
        element.setTextContent(textContent);
        return element;
    }

    private static void updateHttpConnector(@Nonnull Settings newSettings, @Nonnull Node serviceNode) {
        WebServerProfile webServerProfile = newSettings.getWebServerProfile();
        List<Node> httpConnectorNodes = SettingsLoader.findHttpConnectorNodes(serviceNode);
        if (httpConnectorNodes.size() <= 1) {
            Node httpConnectorNode;
            Node node = httpConnectorNode = httpConnectorNodes.isEmpty() ? null : httpConnectorNodes.get(0);
            if (webServerProfile.isHttpEnabled()) {
                String httpPort = newSettings.getHttpPort();
                if (httpConnectorNode == null) {
                    Document doc = serviceNode.getOwnerDocument();
                    httpConnectorNode = serviceNode.appendChild(doc.createElement("Connector"));
                    SettingsLoader.addAttributeToNode(httpConnectorNode, "protocol", "HTTP/1.1");
                    SettingsLoader.addDefaultConnectorDefaultSettings(httpConnectorNode);
                }
                SettingsLoader.addAttributeToNode(httpConnectorNode, "port", httpPort);
                SslSettings sslSettings = newSettings.getSslSettings();
                if (webServerProfile.isHttpsEnabled() && sslSettings != null) {
                    SettingsLoader.addAttributeToNode(httpConnectorNode, "redirectPort", sslSettings.getHttpsPort());
                }
            } else if (httpConnectorNode != null) {
                serviceNode.removeChild(httpConnectorNode);
            }
        }
    }

    private static void updateHttpsConnector(@Nonnull Settings newSettings, @Nonnull Node serviceNode) {
        WebServerProfile webServerProfile = newSettings.getWebServerProfile();
        SslSettings sslSettings = newSettings.getSslSettings();
        List<Node> httpsConnectorNodes = SettingsLoader.findHttpsConnectorNodes(serviceNode);
        if (httpsConnectorNodes.size() <= 1) {
            Node httpsConnectorNode;
            if (httpsConnectorNodes.isEmpty()) {
                httpsConnectorNode = null;
            } else {
                httpsConnectorNode = httpsConnectorNodes.get(0);
                if (SettingsLoader.isAprEnabledConnector(httpsConnectorNode)) {
                    return;
                }
            }
            if (webServerProfile.isHttpsEnabled() && sslSettings != null) {
                if (httpsConnectorNode == null) {
                    Document doc = serviceNode.getOwnerDocument();
                    httpsConnectorNode = serviceNode.appendChild(doc.createElement("Connector"));
                }
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "port", sslSettings.getHttpsPort());
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "scheme", "https");
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "secure", "true");
                String keystoreFile = sslSettings.getKeystoreFile();
                if (keystoreFile != null) {
                    SettingsLoader.addAttributeToNode(httpsConnectorNode, "keystoreFile", keystoreFile);
                }
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "keystorePass", sslSettings.getKeystorePass());
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "keystoreType", sslSettings.getKeystoreType());
                String keyAlias = sslSettings.getKeyAlias();
                if (keyAlias != null) {
                    SettingsLoader.addAttributeToNode(httpsConnectorNode, "keyAlias", keyAlias);
                }
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "clientAuth", "false");
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "sslProtocol", "TLS");
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "SSLEnabled", "true");
                SettingsLoader.addAttributeToNode(httpsConnectorNode, "protocol", "org.apache.coyote.http11.Http11Protocol");
                SettingsLoader.addDefaultConnectorDefaultSettings(httpsConnectorNode);
            } else if (httpsConnectorNode != null) {
                serviceNode.removeChild(httpsConnectorNode);
            }
        }
    }

    private static List<Node> findHttpsConnectorNodes(@Nonnull Node serviceNode) {
        return Lists.newArrayList((Iterable)Iterables.filter(SettingsLoader.getChildNodes(serviceNode, "Connector"), (Predicate)new Predicate<Node>(){

            public boolean apply(@Nullable Node connectorNode) {
                if (connectorNode == null) {
                    return false;
                }
                NamedNodeMap attributes = connectorNode.getAttributes();
                if (attributes == null) {
                    return false;
                }
                String sslEnabledAttributeValue = Strings.nullToEmpty((String)SettingsLoader.getAttributeValue(connectorNode, "SSLEnabled"));
                if (sslEnabledAttributeValue.equalsIgnoreCase("true")) {
                    return true;
                }
                String secureAttributeValue = Strings.nullToEmpty((String)SettingsLoader.getAttributeValue(connectorNode, "secure"));
                return secureAttributeValue.equalsIgnoreCase("true");
            }
        }));
    }

    private static void addDefaultConnectorDefaultSettings(@Nonnull Node httpsConnectorNode) {
        SettingsLoader.updateAttribute(httpsConnectorNode, "maxThreads", "150");
        SettingsLoader.updateAttribute(httpsConnectorNode, "minSpareThreads", "25");
        SettingsLoader.updateAttribute(httpsConnectorNode, "maxSpareThreads", "75");
        SettingsLoader.updateAttribute(httpsConnectorNode, "connectionTimeout", "20000");
        SettingsLoader.updateAttribute(httpsConnectorNode, "enableLookups", "false");
        SettingsLoader.updateAttribute(httpsConnectorNode, "maxHttpHeaderSize", "8192");
        SettingsLoader.updateAttribute(httpsConnectorNode, "useBodyEncodingForURI", "true");
        SettingsLoader.updateAttribute(httpsConnectorNode, "acceptCount", "100");
        SettingsLoader.updateAttribute(httpsConnectorNode, "disableUploadTimeout", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDbConfig(Settings newSettings) {
        JiraHomeDatabaseConfigurationLoader databaseConfigurationLoader = new JiraHomeDatabaseConfigurationLoader(newSettings.getJiraHome());
        DatabaseType databaseType = newSettings.initDatabaseType(false);
        newSettings.applyDefaultAdvancedSettings();
        ConnectionPoolInfo connectionPoolInfo = newSettings.getConnectionPoolInfoBuilder().build();
        JdbcDatasource.Builder datasourceBuilder = newSettings.getJdbcDatasourceBuilder();
        try {
            JdbcDatasource datasource = datasourceBuilder.setConnectionPoolInfo(connectionPoolInfo).build();
            DatabaseConfig databaseConfig = new DatabaseConfig(databaseType.getTypeName(), newSettings.getSchemaName(), datasource);
            databaseConfigurationLoader.saveDatabaseConfiguration(databaseConfig);
        }
        finally {
            datasourceBuilder.setConnectionPoolInfo(null);
        }
    }

    private static void writeXmlFile(Document doc, String filename) throws IOException {
        try {
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(filename);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception ex) {
            String errorMessage = "An error occurred while writing XML file '" + filename + "'.";
            System.err.println(errorMessage);
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            throw new IOException(errorMessage + "\n" + ex.getMessage());
        }
    }

    private static Document parseDocument(String filename) throws IOException {
        try {
            return SecureXmlParserFactory.newDocumentBuilder().parse(filename);
        }
        catch (RuntimeException ex) {
            throw new IOException("Error occurred trying to parse the XML file '" + filename + "'. " + ex.getMessage());
        }
        catch (SAXException ex) {
            throw new IOException("Error occurred trying to parse the XML file '" + filename + "'. " + ex.getMessage());
        }
    }

    private static IOException asIOException(RuntimeException re) {
        Throwable cause = re.getCause();
        if (cause == null) {
            cause = re;
        } else if (cause instanceof IOException) {
            return (IOException)cause;
        }
        IOException ioe = new IOException("Unable to load database configuration: " + cause);
        ioe.initCause(cause);
        return ioe;
    }

    private static void loadDbConfig(Settings settings) throws IOException {
        DatabaseConfig databaseConfig;
        String jiraHome = settings.getJiraHome();
        if (jiraHome == null || jiraHome.length() == 0) {
            System.out.println("jira-home not configured - no database settings can be loaded.");
            return;
        }
        File dbConfigFile = new File(settings.getJiraHome(), "dbconfig.xml");
        if (!dbConfigFile.exists()) {
            System.out.println("DB config file '" + dbConfigFile.getAbsolutePath() + "' is not created yet - loading database settings as blank.");
            return;
        }
        try {
            databaseConfig = new JiraHomeDatabaseConfigurationLoader(jiraHome).loadDatabaseConfiguration();
        }
        catch (RuntimeException re) {
            throw SettingsLoader.asIOException(re);
        }
        SettingsLoader.loadDbConfig(databaseConfig, settings);
    }

    private static void loadDbConfig(DatabaseConfig databaseConfig, Settings settings) throws IOException {
        Datasource datasource = databaseConfig.getDatasource();
        if (datasource instanceof JndiDatasource) {
            throw new IOException("You current database configuration uses JNDI, and this configuration tool does not support that");
        }
        if (!(datasource instanceof JdbcDatasource)) {
            throw new IOException("Unrecognized datasource configuration " + datasource);
        }
        JdbcDatasource jdbcDatasource = (JdbcDatasource)datasource;
        settings.setSchemaName(databaseConfig.getSchemaName());
        settings.setJdbcDatasourceBuilder(jdbcDatasource.toBuilder().setConnectionPoolInfo(null));
        settings.setConnectionPoolInfoBuilder(jdbcDatasource.getConnectionPoolInfo().toBuilder());
        try {
            settings.initDatabaseType(true);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae.getMessage());
        }
    }

    private static void loadServerXmlSettings(Settings settings) throws IOException {
        Document doc = SettingsLoader.parseDocument(SettingsLoader.getServerXmlFile());
        try {
            SettingsLoader.loadWebServerSettings(doc, settings);
        }
        catch (ParseException ex) {
            throw new IOException("Unable to parse the config file '" + SettingsLoader.getServerXmlFile() + "'. " + ex.getMessage());
        }
    }

    static void loadWebServerSettings(Document doc, Settings settings) throws ParseException {
        Node serverNode = SettingsLoader.getOnlyChildNode(doc, "Server");
        settings.setControlPort(SettingsLoader.getAttributeValue(serverNode, "port"));
        Node childNode = SettingsLoader.getOnlyChildNode(serverNode, "Service");
        String httpPort = SettingsLoader.parseHttpPort(childNode, settings);
        SslSettings sslSettings = SettingsLoader.parseSslSettings(childNode, settings);
        settings.updateWebServerConfiguration(httpPort, sslSettings);
    }

    private static String parseHttpPort(@Nonnull Node serviceNode, @Nonnull Settings settings) {
        List<Node> httpConnectorNodes = SettingsLoader.findHttpConnectorNodes(serviceNode);
        if (httpConnectorNodes.isEmpty()) {
            return null;
        }
        if (httpConnectorNodes.size() > 1) {
            settings.addComplexConfigurationReason(ComplexConfigurationReason.MultipleHttpConnectors);
            return null;
        }
        Node httpConnectorNode = httpConnectorNodes.get(0);
        return SettingsLoader.getAttributeValue(httpConnectorNode, "port");
    }

    private static List<Node> findHttpConnectorNodes(@Nonnull Node serviceNode) {
        return Lists.newArrayList((Iterable)Iterables.filter(SettingsLoader.getChildNodes(serviceNode, "Connector"), (Predicate)new Predicate<Node>(){

            public boolean apply(@Nullable Node connectorNode) {
                if (connectorNode == null) {
                    return false;
                }
                NamedNodeMap attributes = connectorNode.getAttributes();
                if (attributes == null) {
                    return false;
                }
                String sslEnabledAttributeValue = Strings.nullToEmpty((String)SettingsLoader.getAttributeValue(connectorNode, "SSLEnabled"));
                if (sslEnabledAttributeValue.equalsIgnoreCase("true")) {
                    return false;
                }
                String secureAttributeValue = SettingsLoader.getAttributeValue(connectorNode, "secure");
                return secureAttributeValue == null || secureAttributeValue.equalsIgnoreCase("false");
            }
        }));
    }

    @Nullable
    private static SslSettings parseSslSettings(@Nonnull Node serviceNode, @Nonnull Settings settings) {
        List<Node> sslConnectorNodes = SettingsLoader.getChildNodesWithAttribute(serviceNode, "Connector", "secure", "true");
        if (sslConnectorNodes.isEmpty()) {
            return null;
        }
        if (sslConnectorNodes.size() > 1) {
            settings.addComplexConfigurationReason(ComplexConfigurationReason.MultipleHttpsConnectors);
            return null;
        }
        Node sslConnectorNode = sslConnectorNodes.get(0);
        if (SettingsLoader.isAprEnabledConnector(sslConnectorNode)) {
            settings.addComplexConfigurationReason(ComplexConfigurationReason.SslEnabledAprConnector);
            return null;
        }
        String port = SettingsLoader.getAttributeValue(sslConnectorNode, "port");
        String keystoreFile = SettingsLoader.getAttributeValue(sslConnectorNode, "keystoreFile");
        String keystorePass = StringUtils.defaultString((String)SettingsLoader.getAttributeValue(sslConnectorNode, "keystorePass"), (String)"changeit");
        String keystoreType = StringUtils.defaultString((String)SettingsLoader.getAttributeValue(sslConnectorNode, "keystoreType"), (String)"JKS");
        String keyAlias = SettingsLoader.getAttributeValue(sslConnectorNode, "keyAlias");
        return new SslSettings(port, keystoreFile, keystorePass, keystoreType, keyAlias);
    }

    private static boolean isAprEnabledConnector(Node connectorNode) {
        String protocol = Strings.nullToEmpty((String)SettingsLoader.getAttributeValue(connectorNode, "protocol"));
        return "org.apache.coyote.http11.Http11AprProtocol".equals(protocol);
    }

    private static void loadApplicationProperties(Settings settings) throws IOException {
        File jiraApplicationProperties = new File(SettingsLoader.getJiraApplicationProperties());
        SettingsLoader.logInfo("Loading application properties from " + jiraApplicationProperties.getCanonicalPath());
        FileInputStream propertiesInputStream = new FileInputStream(jiraApplicationProperties);
        try {
            String jiraHome = SettingsLoader.getJiraHomeValue(propertiesInputStream);
            if (File.separatorChar == '\\') {
                jiraHome = jiraHome.replace("/", "\\");
            }
            settings.setJiraHome(jiraHome);
        }
        catch (ParseException ex) {
            throw new IOException("Error parsing " + jiraApplicationProperties + ". " + ex.getMessage());
        }
        finally {
            ((InputStream)propertiesInputStream).close();
        }
    }

    private static void logInfo(String message) {
        System.out.println(message);
    }

    static String getJiraHomeValue(InputStream propertiesInputStream) throws ParseException, IOException {
        Properties applicationProperties = new Properties();
        applicationProperties.load(propertiesInputStream);
        String jiraHome = applicationProperties.getProperty("jira.home");
        if (jiraHome == null) {
            throw new ParseException("Unable to find the jira.home property.");
        }
        return jiraHome;
    }

    @Nonnull
    private static List<Node> getChildNodesWithAttribute(Node parentNode, String tagName, String attributeName, String attributeValue) {
        List<Node> nodes = SettingsLoader.getChildNodes(parentNode, tagName);
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : nodes) {
            String value = SettingsLoader.getAttributeValue(node, attributeName);
            if (!attributeValue.equals(value)) continue;
            result.add(node);
        }
        return result;
    }

    private static String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node attrNode = attributes.getNamedItem(attributeName);
        if (attrNode == null) {
            return null;
        }
        return attrNode.getNodeValue();
    }

    private static Node getOnlyChildNode(Node parentNode, String tagName) throws ParseException {
        List<Node> childNodes = SettingsLoader.getChildNodes(parentNode, tagName);
        if (childNodes.size() == 1) {
            return childNodes.get(0);
        }
        if (childNodes.size() == 0) {
            return null;
        }
        throw new ParseException("Expected to find one child <" + tagName + "> in <" + parentNode.getNodeName() + "> but found " + childNodes.size());
    }

    private static List<Node> getChildNodes(Node parentNode, String tagName) {
        NodeList childNodes = parentNode.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(tagName)) continue;
            list.add(child);
        }
        return list;
    }

    private static void addAttributeToNode(@Nonnull Node targetNode, @Nonnull String attributeName, @Nonnull String attributeValue) {
        NamedNodeMap nodeAttributes = targetNode.getAttributes();
        Document doc = targetNode.getOwnerDocument();
        Attr attribute = doc.createAttribute(attributeName);
        attribute.setNodeValue(attributeValue);
        nodeAttributes.setNamedItem(attribute);
    }

    private static void updateAttribute(@Nonnull Node targetNode, @Nonnull String attributeName, @Nonnull String attributeValue) {
        NamedNodeMap nodeAttributes = targetNode.getAttributes();
        if (nodeAttributes.getNamedItem(attributeName) == null) {
            Document doc = targetNode.getOwnerDocument();
            Attr attribute = doc.createAttribute(attributeName);
            attribute.setNodeValue(attributeValue);
            nodeAttributes.setNamedItem(attribute);
        }
    }

    private static String getServerXmlFile() {
        if (devMode) {
            return DEV_MODE_SERVER_XML;
        }
        return "../conf/server.xml";
    }

    private static String getWebXmlPath() {
        if (devMode) {
            return "jira-components/jira-webapp/src/main/webapp/WEB-INF/web.xml";
        }
        return "../atlassian-jira/WEB-INF/web.xml";
    }

    private static String getJiraApplicationProperties() {
        if (devMode) {
            return "jira-components/jira-core/src/main/resources/jira-application.properties";
        }
        return "../atlassian-jira/WEB-INF/classes/jira-application.properties";
    }

    public static Settings reloadDbConfig(String jiraHome) throws IOException {
        Settings settings = new Settings();
        settings.setJiraHome(jiraHome);
        SettingsLoader.loadDbConfig(settings);
        return settings;
    }
}

