/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.MetadataLoader;
import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.opensymphony.module.propertyset.InvalidPropertyTypeException;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ApplicationPropertiesStore {
    private static final Logger log = Logger.getLogger(ApplicationPropertiesStore.class);
    public static final String JIRA_CONFIG_PROPERTIES = "jira-config.properties";
    private static final String METADATA_XML = "jpm.xml";
    @ClusterSafe
    private static final LazyReference<LinkedHashMap<String, ApplicationPropertyMetadata>> METADATA_CACHE = new LazyReference<LinkedHashMap<String, ApplicationPropertyMetadata>>(){

        protected LinkedHashMap<String, ApplicationPropertyMetadata> create() throws Exception {
            return new MetadataLoader().loadMetadata(ApplicationPropertiesStore.METADATA_XML);
        }
    };
    private final PropertiesManager propertiesManager;
    private final JiraHome jiraHome;
    @ClusterSafe
    private final ResettableLazyReference<Map<String, String>> defaultWithOverlays = new ResettableLazyReference<Map<String, String>>(){

        protected Map<String, String> create() throws Exception {
            Properties properties = this.loadOverlays();
            HashMap defaultPropertyMap = new HashMap(properties.size());
            for (Map.Entry metadata : ((LinkedHashMap)METADATA_CACHE.get()).entrySet()) {
                defaultPropertyMap.put(metadata.getKey(), ((ApplicationPropertyMetadata)metadata.getValue()).getDefaultValue());
            }
            for (Object keyObj : properties.keySet()) {
                if (!(keyObj instanceof String)) continue;
                String key = (String)keyObj;
                defaultPropertyMap.put(key, properties.getProperty(key));
            }
            return Collections.unmodifiableMap(defaultPropertyMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties loadOverlays() {
            FileInputStream in;
            Properties overlays;
            block4: {
                overlays = new Properties();
                in = null;
                File overlayFile = null;
                try {
                    overlayFile = new File(ApplicationPropertiesStore.this.jiraHome.getLocalHomePath(), ApplicationPropertiesStore.JIRA_CONFIG_PROPERTIES);
                    if (!overlayFile.exists()) break block4;
                    in = new FileInputStream(overlayFile);
                    overlays.load(in);
                }
                catch (IOException e) {
                    try {
                        log.warn((Object)("Could not load config properties from '" + overlayFile + "'."));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            IOUtils.closeQuietly(in);
            return overlays;
        }
    };

    public ApplicationPropertiesStore(PropertiesManager propertiesManager, JiraHome jiraHome) {
        this.propertiesManager = propertiesManager;
        this.jiraHome = jiraHome;
    }

    public List<ApplicationProperty> getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel permissionLevel, String keyFilter) {
        ArrayList<ApplicationProperty> props = new ArrayList<ApplicationProperty>();
        for (ApplicationPropertyMetadata value : ((LinkedHashMap)METADATA_CACHE.get()).values()) {
            if (!this.propertyIsAtLevel(value, permissionLevel) || value.isRequiresRestart() || !this.propertyIsInFilter(value, keyFilter)) continue;
            props.add(this.toApplicationProperty(value));
        }
        return props;
    }

    private boolean propertyIsInFilter(ApplicationPropertyMetadata value, String keyFilter) {
        if (StringUtils.isBlank((String)keyFilter)) {
            return true;
        }
        return value.getKey().matches(keyFilter);
    }

    private boolean propertyIsAtLevel(ApplicationPropertyMetadata propertyMetadata, ApplicationPropertiesService.EditPermissionLevel permissionLevel) {
        switch (permissionLevel) {
            case SYSADMIN_ONLY: {
                return propertyMetadata.isSysadminEditable() && !propertyMetadata.isAdminEditable();
            }
            case SYSADMIN: {
                return propertyMetadata.isSysadminEditable();
            }
            case ADMIN: {
                return propertyMetadata.isAdminEditable();
            }
        }
        return false;
    }

    ApplicationProperty toApplicationProperty(ApplicationPropertyMetadata meta) {
        String key = meta.getKey();
        if (meta.getType().equalsIgnoreCase("boolean")) {
            return new ApplicationProperty(meta, this.getOption(key).toString());
        }
        return new ApplicationProperty(meta, this.getString(key));
    }

    public Boolean getOption(String key) {
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (propertySet.exists(key)) {
            try {
                return propertySet.getBoolean(key);
            }
            catch (Exception e) {
                log.error((Object)("Exception getting option '" + key + "' from database. Using default"));
            }
        }
        return this.getOverlayedOption(key);
    }

    private Boolean getOverlayedOption(String key) {
        return Boolean.valueOf((String)((Map)this.defaultWithOverlays.get()).get(key));
    }

    public ApplicationProperty getApplicationPropertyFromKey(String key) {
        ApplicationPropertyMetadata applicationPropertyMetadata = (ApplicationPropertyMetadata)((LinkedHashMap)METADATA_CACHE.get()).get(key);
        if (applicationPropertyMetadata == null) {
            return null;
        }
        return this.toApplicationProperty(applicationPropertyMetadata);
    }

    public ApplicationProperty setApplicationProperty(String key, String value) {
        ApplicationPropertyMetadata applicationPropertyMetadata = (ApplicationPropertyMetadata)((LinkedHashMap)METADATA_CACHE.get()).get(key);
        String type = applicationPropertyMetadata.getType();
        if ("boolean".equalsIgnoreCase(type)) {
            this.setOption(key, Boolean.parseBoolean(value));
        } else {
            this.setString(key, value);
        }
        return this.getApplicationPropertyFromKey(key);
    }

    public void setString(String key, String value) {
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (value == null) {
            if (propertySet.exists(key)) {
                propertySet.remove(key);
            }
        } else {
            propertySet.setString(key, value);
        }
    }

    public void setOption(String key, Boolean value) {
        this.propertiesManager.getPropertySet().setBoolean(key, value.booleanValue());
    }

    public String getTextFromDb(String key) {
        return this.propertiesManager.getPropertySet().getText(key);
    }

    public void setText(String key, String value) {
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        if (value == null) {
            if (propertySet.exists(key)) {
                propertySet.remove(key);
            }
        } else {
            propertySet.setText(key, value);
        }
    }

    public String getStringFromDb(String key) {
        try {
            return this.propertiesManager.getPropertySet().getString(key);
        }
        catch (InvalidPropertyTypeException e) {
            return "";
        }
    }

    public boolean existsInDb(String key) {
        return this.propertiesManager.getPropertySet().exists(key);
    }

    public Collection<String> getKeysStoredInDb() {
        return this.propertiesManager.getPropertySet().getKeys();
    }

    public Map<String, Object> getPropertiesAsMap() {
        Map<String, String> defaultProperties = this.getDefaultsWithOverlays();
        PropertySet propertySet = this.propertiesManager.getPropertySet();
        HashSet<String> smooshedKeys = new HashSet<String>();
        smooshedKeys.addAll(this.getKeysStoredInDb());
        smooshedKeys.addAll(defaultProperties.keySet());
        HashMap<String, Object> allProperties = new HashMap<String, Object>(smooshedKeys.size());
        for (String key : smooshedKeys) {
            Object value = null;
            try {
                value = propertySet.getAsActualType(key);
            }
            catch (PropertyException ignored) {
                // empty catch block
            }
            if (value == null) {
                value = defaultProperties.get(key);
            }
            allProperties.put(key, value);
        }
        return allProperties;
    }

    public void refreshDbProperties() {
        this.propertiesManager.refresh();
    }

    public void refresh() {
        this.defaultWithOverlays.reset();
        this.refreshDbProperties();
    }

    public Map<String, String> getDefaultsWithOverlays() {
        return (Map)this.defaultWithOverlays.get();
    }

    public Collection<String> getStringsWithPrefixFromDb(String prefix) {
        return this.propertiesManager.getPropertySet().getKeys(prefix, 5);
    }

    public String getString(String key) {
        String value = null;
        try {
            value = this.getStringFromDb(key);
        }
        catch (Exception e) {
            log.warn((Object)("Exception getting property '" + key + "' from database. Using default"));
        }
        if (value == null) {
            value = this.getOverlayedString(key);
        }
        return value;
    }

    public String getOverlayedString(String key) {
        return (String)((Map)this.defaultWithOverlays.get()).get(key);
    }
}

