/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.database.InvalidDatabaseDriverException;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.db.DatabaseConfigFactory;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;

@Internal
public class DatabaseDriverRegisterer {
    private final DatabaseType databaseType;
    private final String driverClassName;

    public static DatabaseDriverRegisterer forType(DatabaseType type) {
        return new DatabaseDriverRegisterer((DatabaseType)((Object)Assertions.notNull((String)"type", (Object)((Object)type))), DatabaseConfigFactory.getDatabaseConfigFor(type).getClassName());
    }

    public static DatabaseDriverRegisterer forDriverClass(String className) {
        return new DatabaseDriverRegisterer(DatabaseDriverRegisterer.findForDriverClass((String)Assertions.notNull((String)"driverClassName", (Object)className)), className);
    }

    private static DatabaseType findForDriverClass(String className) {
        try {
            return DatabaseType.forJdbcDriverClassName(className);
        }
        catch (IllegalArgumentException iae) {
            return DatabaseType.UKNOWN;
        }
    }

    private DatabaseDriverRegisterer(DatabaseType databaseType, String driverClassName) {
        this.databaseType = databaseType;
        this.driverClassName = driverClassName;
    }

    public DatabaseType databaseType() {
        return this.databaseType;
    }

    public void registerDriver() {
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException ex) {
            Iterator<String> message = this.getErrorMessage().iterator();
            JiraStartupLogger.log().fatal((Object)message.next());
            while (message.hasNext()) {
                JiraStartupLogger.log().info((Object)message.next());
            }
            throw new InvalidDatabaseDriverException(this.driverClassName, "JDBC Driver class '" + this.driverClassName + " could not be loaded.'", ex);
        }
    }

    public Iterable<String> getErrorMessage() {
        HelpUtil.HelpPath link;
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)("Driver for the database " + this.databaseType.getDisplayName() + " not found. Ensure it is installed in the 'lib' directory."));
        if (this.databaseType == DatabaseType.MY_SQL) {
            builder.add((Object)"If you are upgrading a standalone distribution of JIRA, this may be due to the fact that JIRA no longer ships with MySQL drivers.");
        }
        if ((link = this.getDbConfigLink()) != null) {
            builder.add((Object)("Please visit " + link.getSimpleUrl() + " for more information."));
        }
        return builder.build();
    }

    public boolean isDriverRegistered() {
        try {
            Class.forName(this.driverClassName);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public HelpUtil.HelpPath getDbConfigLink() {
        if (!DatabaseDriverRegisterer.hasDbconfigLink(this.databaseType.getTypeName())) {
            return null;
        }
        return DatabaseDriverRegisterer.getDbConfigLink(this.databaseType);
    }

    public static HelpUtil.HelpPath getDbConfigLink(DatabaseType type) {
        return DatabaseDriverRegisterer.getDbConfigLink(type.getTypeName());
    }

    public static HelpUtil.HelpPath getDbConfigLink(String key) {
        return HelpUtil.getInstance().getHelpPath(DatabaseDriverRegisterer.withDbConfigPrefix(key));
    }

    public static boolean hasDbconfigLink(String key) {
        return HelpUtil.getInstance().keySet().contains(DatabaseDriverRegisterer.withDbConfigPrefix(key));
    }

    private static String withDbConfigPrefix(String key) {
        return "dbconfig." + key;
    }
}

