/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.component;

import com.atlassian.jira.config.component.GroupedMethodProfiler;
import com.atlassian.util.profiling.UtilTimerStack;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.AbstractBehavior;

public class ProfilingComponentAdapter<T>
extends AbstractBehavior<T> {
    private static final Logger log = Logger.getLogger(ProfilingComponentAdapter.class);
    private final AtomicReference<T> instanceReference = new AtomicReference();
    private final AtomicReference<T> profilingReference = new AtomicReference();

    public ProfilingComponentAdapter(ComponentAdapter delegate) {
        super(delegate);
    }

    public T getComponentInstance(PicoContainer container, Type into) throws PicoCompositionException {
        if (this.instanceReference.get() == null) {
            Object componentInstance;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting component instance with key '" + this.getComponentKey() + "' and implementation class '" + this.getComponentImplementation() + "'."));
            }
            try {
                componentInstance = this.delegate.getComponentInstance(container, into);
            }
            catch (PicoCompositionException ex) {
                throw new PicoCompositionException("Error trying to instantiate " + this.getComponentImplementation() + ": " + ex.getMessage(), (Throwable)ex);
            }
            Object key = super.getComponentKey();
            if (key != null && key instanceof Class && ((Class)key).isInterface()) {
                Object profiledInstance = GroupedMethodProfiler.getProfiledObject(componentInstance);
                this.profilingReference.set(profiledInstance);
            } else {
                this.profilingReference.set(componentInstance);
            }
            this.instanceReference.set(componentInstance);
        }
        if (UtilTimerStack.isActive()) {
            return this.profilingReference.get();
        }
        return this.instanceReference.get();
    }

    public String getDescriptor() {
        return "ProfilingComponentAdapter";
    }
}

