/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.resolution.ResolutionImpl;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultResolutionManager
extends AbstractIssueConstantsManager<Resolution>
implements ResolutionManager {
    private static final Logger log = Logger.getLogger(DefaultResolutionManager.class);
    private final ApplicationProperties applicationProperties;
    private final IssueConstantFactory factory;

    public DefaultResolutionManager(ConstantsManager constantsManager, IssueIndexManager issueIndexManager, OfBizDelegator ofBizDelegator, ApplicationProperties applicationProperties, IssueConstantFactory factory) {
        super(constantsManager, ofBizDelegator, issueIndexManager);
        this.applicationProperties = applicationProperties;
        this.factory = factory;
    }

    public synchronized Resolution createResolution(String name, String description) {
        Assertions.notBlank((String)"name", (String)name);
        for (Resolution resolution : this.constantsManager.getResolutionObjects()) {
            if (!name.trim().equalsIgnoreCase(resolution.getName())) continue;
            throw new IllegalStateException("A resolution with the name '" + name + "' already exists.");
        }
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("id", this.getNextStringId());
            fields.put("sequence", this.getMaxSequenceNo() + 1L);
            GenericValue resolutionGenericValue = this.createConstant(fields);
            Resolution resolution = this.factory.createResolution(resolutionGenericValue);
            return resolution;
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to create a resolution with name '" + name + "'", (Throwable)ex);
        }
        finally {
            this.clearCaches();
        }
    }

    public void editResolution(Resolution resolution, String name, String description) {
        Assertions.notNull((String)"resolution", (Object)resolution);
        Assertions.notBlank((String)"name", (String)name);
        for (Resolution res : this.getResolutions()) {
            if (!name.equalsIgnoreCase(res.getName()) || resolution.getId().equals(res.getId())) continue;
            throw new IllegalArgumentException("Cannot rename resolution. A resolution with the name '" + name + "' exists already.");
        }
        try {
            ResolutionImpl updatedResolution = (ResolutionImpl)this.factory.createResolution(resolution.getGenericValue());
            updatedResolution.setName(name);
            updatedResolution.setDescription(description);
            updatedResolution.getGenericValue().store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update resolution with name '" + resolution.getName() + "'", (Throwable)e);
        }
        finally {
            this.clearCaches();
        }
    }

    public List<Resolution> getResolutions() {
        return Lists.newArrayList((Iterable)this.constantsManager.getResolutionObjects());
    }

    public void removeResolution(String resolutionId, String newResolutionId) {
        Assertions.notBlank((String)"resolutionId", (String)resolutionId);
        Assertions.notBlank((String)"newResolutionId", (String)newResolutionId);
        Resolution resolution = this.getResolution(resolutionId);
        if (resolution == null) {
            throw new IllegalArgumentException("A resolution with the name '" + resolutionId + "' does not exist.");
        }
        Resolution newResolution = this.getResolution(newResolutionId);
        if (newResolution == null) {
            throw new IllegalArgumentException("A resolution with the name '" + newResolutionId + "' does not exist.");
        }
        try {
            this.removeConstant("resolution", resolution, newResolution.getId());
        }
        catch (Exception ex) {
            throw new DataAccessException("Failed to remove resolution with id '" + resolutionId + "'", (Throwable)ex);
        }
    }

    public Resolution getResolutionByName(String name) {
        for (Resolution resolution : this.getResolutions()) {
            if (!resolution.getName().equalsIgnoreCase(name)) continue;
            return resolution;
        }
        return null;
    }

    public Resolution getResolution(String id) {
        return this.constantsManager.getResolutionObject(id);
    }

    public void moveResolutionUp(String id) {
        Resolution resolution = this.checkResolutionExists(id);
        this.moveUp(resolution);
    }

    public void moveResolutionDown(String id) {
        Resolution resolution = this.checkResolutionExists(id);
        this.moveDown(resolution);
    }

    public void setDefaultResolution(String id) {
        if (id != null) {
            this.checkResolutionExists(id);
        }
        this.applicationProperties.setString("jira.constant.default.resolution", id);
    }

    public Resolution getDefaultResolution() {
        String defaultResolutionId = this.applicationProperties.getString("jira.constant.default.resolution");
        if (StringUtils.isNotEmpty((String)defaultResolutionId)) {
            Resolution resolution = this.getResolution(defaultResolutionId);
            if (resolution == null) {
                log.warn((Object)("Default resolution with id '" + defaultResolutionId + "' does not exist."));
            }
            return resolution;
        }
        return null;
    }

    private Resolution checkResolutionExists(String id) {
        Assertions.notBlank((String)"id", (String)id);
        Resolution resolution = this.getResolution(id);
        if (resolution == null) {
            throw new IllegalArgumentException("A resolution with the '" + id + "' does not exist.");
        }
        return resolution;
    }

    @Override
    protected void postProcess(Resolution resolution) {
        if (resolution.getId().equals(this.applicationProperties.getString("jira.constant.default.resolution"))) {
            this.applicationProperties.setString("jira.constant.default.resolution", null);
        }
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshResolutions();
    }

    @Override
    protected String getIssueConstantField() {
        return "Resolution";
    }

    @Override
    protected List<Resolution> getAllValues() {
        return this.getResolutions();
    }
}

