/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.IndexTask;
import com.atlassian.jira.config.ReindexMessage;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;

@EventComponent
public class DefaultReindexMessageManager
implements ReindexMessageManager {
    static final String PS_KEY = "admin.message.manager";
    static final String PS_KEY_USER = "user";
    static final String PS_KEY_TASK = "task";
    static final String PS_KEY_TIME = "time";
    static final String PS_KEY_RAW = "rawmsg";
    private final UserKeyService userKeyService;
    private final UserFormatManager userFormatManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final OutlookDateManager outlookDateManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final CachedReference<PropertySet> propertiesReference;
    private final PermissionManager permissionManager;
    private final TaskManager taskManager;

    public DefaultReindexMessageManager(final JiraPropertySetFactory jiraPropertySetFactory, UserKeyService userKeyService, UserFormatManager userFormatManager, I18nHelper.BeanFactory i18nFactory, OutlookDateManager outlookDateManager, VelocityRequestContextFactory velocityRequestContextFactory, PermissionManager permissionManager, TaskManager taskManager, CacheManager cacheManager) {
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"velocityRequestContextFactory", (Object)velocityRequestContextFactory);
        this.userKeyService = (UserKeyService)Assertions.notNull((String)"userKeyService", (Object)userKeyService);
        this.userFormatManager = (UserFormatManager)Assertions.notNull((String)"userFormatManager", (Object)userFormatManager);
        this.i18nFactory = (I18nHelper.BeanFactory)Assertions.notNull((String)"i18nFactory", (Object)i18nFactory);
        this.outlookDateManager = (OutlookDateManager)Assertions.notNull((String)"outlookDateManager", (Object)outlookDateManager);
        this.taskManager = (TaskManager)Assertions.notNull((String)"taskManager", (Object)taskManager);
        this.propertiesReference = cacheManager.getCachedReference(DefaultReindexMessageManager.class, "propertiesReference", (Supplier)new Supplier<PropertySet>(){

            public PropertySet get() {
                return jiraPropertySetFactory.buildCachingDefaultPropertySet(DefaultReindexMessageManager.PS_KEY, true);
            }
        });
    }

    @EventListener
    public synchronized void onClearCache(ClearCacheEvent event) {
        this.propertiesReference.reset();
    }

    public synchronized void pushMessage(User user, String i18nTask) {
        this.pushMessage(user);
        ((PropertySet)this.propertiesReference.get()).setString(PS_KEY_TASK, i18nTask);
        this.propertiesReference.reset();
    }

    public synchronized void pushRawMessage(User user, String i18nMessage) {
        this.pushMessage(user);
        ((PropertySet)this.propertiesReference.get()).setString(PS_KEY_RAW, i18nMessage);
        this.propertiesReference.reset();
    }

    private void pushMessage(User user) {
        String key = ApplicationUsers.getKeyFor((User)user);
        ((PropertySet)this.propertiesReference.get()).setString(PS_KEY_USER, key == null ? "" : key);
        ((PropertySet)this.propertiesReference.get()).setDate(PS_KEY_TIME, this.getCurrentDate());
        this.propertiesReference.reset();
    }

    public synchronized void clear() {
        PropertySet propertySet = (PropertySet)this.propertiesReference.get();
        if (propertySet.exists(PS_KEY_USER)) {
            propertySet.remove(PS_KEY_TIME);
            if (propertySet.exists(PS_KEY_TASK)) {
                propertySet.remove(PS_KEY_TASK);
            }
            propertySet.remove(PS_KEY_USER);
            if (propertySet.exists(PS_KEY_RAW)) {
                propertySet.remove(PS_KEY_RAW);
            }
        }
        this.propertiesReference.reset();
    }

    public synchronized String getMessage(User user) {
        TaskDescriptor<Object> task = this.findActiveIndexTasks();
        PropertySet propertySet = (PropertySet)this.propertiesReference.get();
        if (propertySet.exists(PS_KEY_USER) && this.permissionManager.hasPermission(0, user)) {
            String userKey = propertySet.getString(PS_KEY_USER);
            String i18nTaskKey = propertySet.getString(PS_KEY_TASK);
            Date time = propertySet.getDate(PS_KEY_TIME);
            String rawMessageKey = propertySet.getString(PS_KEY_RAW);
            if (rawMessageKey != null && rawMessageKey.length() > 0) {
                return this.getRawIndexRequiredMessage(user, rawMessageKey);
            }
            if (task == null || task.isFinished()) {
                return this.getReindexRequiredMessage(user, userKey, i18nTaskKey, time);
            }
            Date startedTimestamp = task.getStartedTimestamp();
            if (startedTimestamp != null && startedTimestamp.before(time)) {
                return this.getReindexRestartRequiredMessage(user, userKey, i18nTaskKey, time);
            }
        }
        if (task != null && task.isStarted() && !task.isFinished()) {
            I18nHelper i18n = this.i18nFactory.getInstance(user);
            return ((IndexTask)task.getTaskContext()).getTaskInProgressMessage(i18n);
        }
        return null;
    }

    private String getRawIndexRequiredMessage(User user, String rawMessageKey) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        String rawMessage = i18n.getText(rawMessageKey);
        String reindexLink = this.getHelpPathString();
        StringBuilder message = new StringBuilder();
        message.append("<p>").append(i18n.getText("admin.notifications.reindex.rawmessage", (Object)new Object[]{rawMessage, reindexLink, "</a>"}));
        message.append("<p>").append(i18n.getText("admin.notifications.reindex.now", "<a href='" + this.getContextPath() + "/secure/admin/jira/IndexAdmin.jspa'>", "</a>"));
        return message.toString();
    }

    private String getReindexRequiredMessage(User user, String userKey, String i18nTaskKey, Date time) {
        return this.getMessage(user, userKey, i18nTaskKey, time, false);
    }

    private String getMessage(User user, String userKey, String i18nTaskKey, Date time, boolean restartRequired) {
        I18nHelper i18n = this.i18nFactory.getInstance(user);
        String restart = restartRequired ? ".restart" : "";
        String timeString = this.getTimeString(time, i18n);
        String userFullName = this.userFormatManager.formatUserkey(userKey, "fullName", "fullName");
        String i18nTask = i18n.getText(i18nTaskKey);
        String reindexLink = this.getHelpPathString();
        StringBuilder message = new StringBuilder();
        if (userFullName == null) {
            message.append("<p>").append(i18n.getText("admin.notifications.task.requires.reindex" + restart + ".nouser", (Object)new Object[]{i18nTask, timeString, reindexLink, "</a>"}));
        } else {
            message.append("<p>").append(i18n.getText("admin.notifications.task.requires.reindex" + restart, (Object)new Object[]{userFullName, i18nTask, timeString, reindexLink, "</a>"}));
        }
        message.append("<p>").append(i18n.getText("admin.notifications.reindex.now", "<a href='" + this.getContextPath() + "/secure/admin/jira/IndexAdmin.jspa'>", "</a>"));
        message.append("<p>").append(i18n.getText("admin.notifications.complete.all.changes"));
        return message.toString();
    }

    private String getHelpPathString() {
        HelpUtil helpUtil = HelpUtil.getInstance();
        HelpUtil.HelpPath path = helpUtil.getHelpPath("reindex_after_configuration_changes");
        return String.format("<a href=\"%s\" data-helplink=\"online\" target=\"_jirahelp\">", path.getUrl().toString());
    }

    private String getTimeString(Date time, I18nHelper i18n) {
        OutlookDate outlookDate = this.outlookDateManager.getOutlookDate(i18n.getLocale());
        return outlookDate.formatDMYHMS(time);
    }

    private String getReindexRestartRequiredMessage(User user, String userKey, String i18nTaskKey, Date time) {
        return this.getMessage(user, userKey, i18nTaskKey, time, true);
    }

    public synchronized ReindexMessage getMessageObject() {
        PropertySet propertySet = (PropertySet)this.propertiesReference.get();
        if (propertySet.exists(PS_KEY_USER)) {
            String userKey = propertySet.getString(PS_KEY_USER);
            String i18nTaskKey = propertySet.getString(PS_KEY_TASK);
            Date time = propertySet.getDate(PS_KEY_TIME);
            String userName = this.userKeyService.getUsernameForKey(userKey);
            if (userName == null) {
                userName = userKey;
            }
            return new ReindexMessage(userName, time, i18nTaskKey);
        }
        return null;
    }

    public synchronized void clearMessageForTimestamp(Date time) {
        Date messageTime;
        if (((PropertySet)this.propertiesReference.get()).exists(PS_KEY_TIME) && !time.before(messageTime = ((PropertySet)this.propertiesReference.get()).getDate(PS_KEY_TIME))) {
            this.clear();
        }
    }

    String getContextPath() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    private TaskDescriptor<Object> findActiveIndexTasks() {
        return this.taskManager.findFirstTask(new TaskMatcher(){

            @Override
            public boolean match(TaskDescriptor<?> descriptor) {
                return !descriptor.isFinished() && descriptor.getTaskContext() instanceof IndexTask;
            }
        });
    }
}

