/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.comment;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import webwork.action.Action;

public class AddCommentContextProvider
implements CacheableContextProvider {
    private final FieldLayoutManager fieldLayoutManager;

    public AddCommentContextProvider(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        Action action = (Action)context.get("action");
        Map paramsBuilder = MapBuilder.newBuilder(context).toMutableMap();
        paramsBuilder.put("commentHtml", this.getCommentHtml(issue, action));
        return paramsBuilder;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        User user = (User)context.get("user");
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private String getCommentHtml(Issue issue, Action action) {
        OperationContext context = (OperationContext)action;
        MapBuilder displayParams = MapBuilder.newBuilder();
        displayParams.add((Object)"theme", (Object)"aui");
        displayParams.add((Object)"noHeader", (Object)true);
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        FieldLayoutItem commentFieldLayoutItem = fieldLayout.getFieldLayoutItem("comment");
        OrderableField commentField = commentFieldLayoutItem.getOrderableField();
        return commentField.getCreateHtml(commentFieldLayoutItem, context, action, issue, displayParams.toMap());
    }
}

