/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.ha.RemoteImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ha.RemoteImportStartedEvent;
import com.atlassian.jira.cluster.ClusterMessage;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandler;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.OfBizClusterMessageStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.plugin.ha.PluginSyncService;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class OfBizMessageHandlerService
implements MessageHandler {
    private static final int INITIAL_DELAY = 3;
    private static final int PERIOD = 3;
    private static final Logger log = Logger.getLogger(OfBizMessageHandlerService.class);
    private final EventPublisher eventPublisher;
    private final ListenerManager listenerManager;
    private final NodeStateManager nodeStateManager;
    private final OfBizClusterMessageStore clusterMessageStore;
    private final ScheduledExecutorService scheduler;
    @ClusterSafe
    private final LazyReference<IndexCopyService> indexCopyServiceRef = new LazyReference<IndexCopyService>(){

        protected IndexCopyService create() throws Exception {
            return (IndexCopyService)ComponentAccessor.getComponent(IndexCopyService.class);
        }
    };
    @ClusterSafe
    private final LazyReference<PluginSyncService> pluginSyncServiceRef = new LazyReference<PluginSyncService>(){

        protected PluginSyncService create() throws Exception {
            return (PluginSyncService)ComponentAccessor.getComponent(PluginSyncService.class);
        }
    };
    @Nullable
    private volatile ScheduledFuture<?> messageHandlerService;
    private final Runnable handler = new Runnable(){

        @Override
        public void run() {
            OfBizMessageHandlerService.this.handleReceivedMessages();
        }
    };

    public OfBizMessageHandlerService(NodeStateManager nodeStateManager, OfBizClusterMessageStore clusterMessageStore, EventPublisher eventPublisher, ListenerManager listenerManager) {
        this.clusterMessageStore = clusterMessageStore;
        this.eventPublisher = eventPublisher;
        this.nodeStateManager = nodeStateManager;
        this.listenerManager = listenerManager;
        this.scheduler = Executors.newScheduledThreadPool(1, ThreadFactories.namedThreadFactory("ClusterMessageHandlerServiceThread"));
    }

    @Override
    @Nullable
    public ClusterMessage sendMessage(String destinationId, Message message) {
        ClusterMessage clusterMessage = null;
        if (this.getCurrentNode().isClustered()) {
            String sourceId = this.getCurrentNode().getNodeId();
            clusterMessage = this.clusterMessageStore.createMessage(sourceId, destinationId, message.toString());
        }
        return clusterMessage;
    }

    @Override
    public List<ClusterMessage> receiveMessages() {
        return this.clusterMessageStore.getMessages(this.getCurrentNode());
    }

    @Override
    public void start() {
        this.messageHandlerService = this.scheduler.scheduleAtFixedRate(this.handler, 3L, 3L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.messageHandlerService != null) {
            this.messageHandlerService.cancel(false);
        }
        this.scheduler.shutdown();
    }

    private Node getCurrentNode() {
        return this.nodeStateManager.getNode();
    }

    private void handleReceivedMessages() {
        boolean pluginEvent = false;
        List<ClusterMessage> messages = this.receiveMessages();
        IndexCopyService indexCopyService = (IndexCopyService)this.indexCopyServiceRef.get();
        ArrayList pluginMessages = Lists.newArrayList();
        try {
            for (ClusterMessage message : messages) {
                switch (message.getMessage().getMessageType()) {
                    case BACKUP_INDEX: {
                        indexCopyService.backupIndex(message.getSourceNode());
                        break;
                    }
                    case BACKUP_INDEX_DONE: {
                        indexCopyService.restoreIndex();
                        break;
                    }
                    case PLUGIN_CHANGE: {
                        pluginEvent = true;
                        pluginMessages.add(message);
                        break;
                    }
                    case IMPORT_STARTED: {
                        this.eventPublisher.publish((Object)new RemoteImportStartedEvent());
                        break;
                    }
                    case IMPORT_FINISHED: {
                        boolean importResult = Boolean.parseBoolean(message.getMessage().getSupplementalInformation());
                        this.eventPublisher.publish((Object)new RemoteImportCompletedEvent(importResult));
                        break;
                    }
                    case REFRESH_LISTENERS: {
                        this.listenerManager.onRefreshListeners();
                    }
                }
                this.clusterMessageStore.deleteMessage(message);
            }
            if (pluginEvent) {
                ((PluginSyncService)this.pluginSyncServiceRef.get()).syncPlugins(pluginMessages);
            }
        }
        catch (Exception e) {
            log.error((Object)"There was a problem handling a cluster message", (Throwable)e);
        }
    }
}

