/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.google.common.collect.Maps;
import java.util.Map;

public class Message {
    public static final String DELIMITER = ":-";
    private final MessageType messageType;
    private final String supplementalInformation;

    public static Message refreshListenersMessage() {
        return new Message(MessageType.REFRESH_LISTENERS, null);
    }

    public String getSupplementalInformation() {
        return this.supplementalInformation;
    }

    private Message(MessageType messageType, String supplementalInformation) {
        this.messageType = messageType;
        this.supplementalInformation = supplementalInformation;
    }

    public static Message fromString(String message) {
        String messageType;
        String supplementalInformation;
        int separatorIndex = message.indexOf(DELIMITER);
        if (separatorIndex > 0) {
            supplementalInformation = message.substring(separatorIndex + DELIMITER.length());
            messageType = message.substring(0, separatorIndex);
        } else {
            supplementalInformation = null;
            messageType = message;
        }
        return new Message(MessageType.fromString(messageType), supplementalInformation);
    }

    public static Message pluginMessage(String supplementalInformation) {
        return new Message(MessageType.PLUGIN_CHANGE, supplementalInformation);
    }

    public static Message indexMessage(MessageType messageType) {
        return new Message(messageType, null);
    }

    public static Message importFinishedMessage(Boolean success) {
        return new Message(MessageType.IMPORT_FINISHED, success.toString());
    }

    public static Message importStartedMessage() {
        return new Message(MessageType.IMPORT_STARTED, null);
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String toString() {
        return this.serializeAsString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.messageType == message.messageType && this.isSameSupplementalInformation(message);
    }

    private boolean isSameSupplementalInformation(Message message) {
        return this.supplementalInformation == null ? message.supplementalInformation == null : this.supplementalInformation.equals(message.supplementalInformation);
    }

    public int hashCode() {
        int result = this.messageType.hashCode();
        result = 31 * result + (this.supplementalInformation != null ? this.supplementalInformation.hashCode() : 0);
        return result;
    }

    private String serializeAsString() {
        StringBuilder sb = new StringBuilder(this.messageType.getMessageType());
        if (this.supplementalInformation != null) {
            sb.append(DELIMITER);
            sb.append(this.supplementalInformation);
        }
        return sb.toString();
    }

    public static enum MessageType {
        BACKUP_INDEX("Backup Index"),
        BACKUP_INDEX_DONE("Index Backed Up"),
        PLUGIN_CHANGE("Plugin event"),
        IMPORT_STARTED("Import Started"),
        IMPORT_FINISHED("Import Done"),
        REFRESH_LISTENERS("Refresh Listeners");

        private static Map<String, MessageType> messageTypeMap;
        private String messageType;

        private MessageType(String messageType) {
            this.messageType = messageType;
        }

        public String getMessageType() {
            return this.messageType;
        }

        private static MessageType fromString(String messageType) {
            if (messageTypeMap == null) {
                MessageType.initialiseMessageMap();
            }
            return messageTypeMap.get(messageType);
        }

        private static void initialiseMessageMap() {
            messageTypeMap = Maps.newHashMap();
            for (MessageType messageType : MessageType.values()) {
                messageTypeMap.put(messageType.getMessageType(), messageType);
            }
        }
    }
}

