/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.jfreechart;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.io.SessionTempFile;
import com.atlassian.jira.io.TempFileFactory;
import com.atlassian.jira.util.PathTraversalException;
import com.atlassian.jira.util.PathUtils;
import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.servlet.DisplayChart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayChartServlet
implements Servlet {
    public static final Logger log = LoggerFactory.getLogger(DisplayChartServlet.class);
    private final Servlet displayChart = new DisplayChart();

    public void init(ServletConfig config) throws ServletException {
        this.displayChart.init(config);
    }

    public void destroy() {
        this.displayChart.destroy();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String filename = request.getParameter("filename");
        String tmpDir = JiraSystemProperties.getInstance().getProperty("java.io.tmpdir");
        try {
            File path = new File(tmpDir, filename);
            PathUtils.ensurePathInSecureDir((String)tmpDir, (String)path.getAbsolutePath());
            if (path.exists()) {
                this.displayChart.service(request, response);
                this.unmarkAsTemporaryFile(filename);
                return;
            }
            log.warn("File not found, returning 404 (filename='{}').", (Object)filename);
        }
        catch (PathTraversalException e) {
            log.warn("Possible path traversal attempt, returning 404 (filename='{}').", (Object)filename);
        }
        catch (IOException e) {
            log.error("Error checking path, returning 404 (filename='{}').", (Object)filename);
        }
        ((HttpServletResponse)response).sendError(404);
    }

    public ServletConfig getServletConfig() {
        return this.displayChart.getServletConfig();
    }

    public String getServletInfo() {
        return this.displayChart.getServletInfo();
    }

    private void unmarkAsTemporaryFile(String filename) {
        TempFileFactory tempFileFactory = (TempFileFactory)ComponentAccessor.getComponent(TempFileFactory.class);
        if (tempFileFactory == null) {
            return;
        }
        SessionTempFile sessionTempFile = tempFileFactory.getSessionTempFile(filename);
        if (sessionTempFile != null && !sessionTempFile.getFile().exists()) {
            sessionTempFile.unbind();
        }
    }
}

