/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.NotNull;
import java.util.Collection;

public class TransformedKeyCache<K, T, V>
implements Cache<K, V> {
    final Cache<T, V> delegate;
    final Function<K, T> keyTransform;

    public static <K, T, V> TransformedKeyCache<K, T, V> transform(Cache<T, V> delegate, Function<K, T> keyTransform) {
        return new TransformedKeyCache<K, T, V>(delegate, keyTransform);
    }

    public static <K, T, V> TransformedKeyCache<K, T, V> transform(Cache<T, V> delegate, Function<K, T> keyTransform, CacheLoader<K, V> loader) {
        if (loader == null) {
            return TransformedKeyCache.transform(delegate, keyTransform);
        }
        return new LazyTransformedKeyCache<K, T, V>(delegate, keyTransform, loader);
    }

    TransformedKeyCache(Cache<T, V> delegate, Function<K, T> keyTransform) {
        this.delegate = (Cache)Assertions.notNull((String)"delegate", delegate);
        this.keyTransform = (Function)Assertions.notNull((String)"keyTransform", keyTransform);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Collection<K> getKeys() {
        throw new UnsupportedOperationException("Cannot get the keys of a cache that uses a key transform.");
    }

    public Collection<T> getTransformedKeys() {
        return this.delegate.getKeys();
    }

    public V get(@NotNull K key) {
        return (V)this.delegate.get(this.transform(key));
    }

    public void put(@NotNull K key, V value) {
        this.delegate.put(this.transform(key), value);
    }

    public void remove(@NotNull K key) {
        this.delegate.remove(this.transform(key));
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.delegate.putIfAbsent(this.transform(key), value);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.delegate.replace(this.transform(key), oldValue, newValue);
    }

    public boolean remove(K key, V value) {
        return this.delegate.remove(this.transform(key), value);
    }

    protected T transform(K key) {
        return (T)Assertions.notNull((String)"transformedKey", (Object)this.keyTransform.get(Assertions.notNull((String)"key", key)));
    }

    static class LazyTransformedKeyCache<K, T, V>
    extends TransformedKeyCache<K, T, V> {
        private final CacheLoader<K, V> loader;

        LazyTransformedKeyCache(Cache<T, V> delegate, Function<K, T> keyTransform, CacheLoader<K, V> loader) {
            super(delegate, keyTransform);
            this.loader = (CacheLoader)Assertions.notNull((String)"loader", loader);
        }

        @Override
        public V get(@NotNull K key) {
            Object transformedKey = this.transform(key);
            Object value = this.delegate.get(transformedKey);
            if (value != null) {
                return (V)value;
            }
            value = this.load(key);
            Object sneaky = this.delegate.putIfAbsent(transformedKey, value);
            return (V)(sneaky != null ? sneaky : value);
        }

        private V load(K key) {
            try {
                return (V)this.loader.load(key);
            }
            catch (Exception ex) {
                throw new CacheException((Throwable)ex);
            }
        }
    }
}

