/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit;

import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkDeleteOperation;
import com.atlassian.jira.bulkedit.operation.BulkEditOperation;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.bulkedit.operation.BulkUnwatchOperation;
import com.atlassian.jira.bulkedit.operation.BulkWatchOperation;
import com.atlassian.jira.bulkedit.operation.BulkWorkflowTransitionOperation;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class DefaultBulkOperationManager
implements BulkOperationManager {
    private static final Logger log = Logger.getLogger(DefaultBulkOperationManager.class);
    private final WatcherService watcherService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final Map<String, BulkOperation> systemBulkOperations;
    private final Map<String, BulkOperation> systemBulkWatchOperations;
    private final Map<String, BulkOperation> pluginProvidedBulkOperations = Maps.newLinkedHashMap();

    public DefaultBulkOperationManager(JiraAuthenticationContext jiraAuthenticationContext, WatcherService watcherService, BulkEditOperation bulkEditOperation, BulkMigrateOperation bulkMigrateOperation, BulkWorkflowTransitionOperation bulkWorkflowTransitionOperation, BulkDeleteOperation bulkDeleteOperation, BulkWatchOperation bulkWatchOperation, BulkUnwatchOperation bulkUnwatchOperation) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.watcherService = watcherService;
        this.systemBulkOperations = ImmutableMap.of((Object)bulkEditOperation.getNameKey(), (Object)bulkEditOperation, (Object)bulkMigrateOperation.getNameKey(), (Object)bulkMigrateOperation, (Object)bulkWorkflowTransitionOperation.getNameKey(), (Object)bulkWorkflowTransitionOperation, (Object)bulkDeleteOperation.getNameKey(), (Object)bulkDeleteOperation);
        this.systemBulkWatchOperations = ImmutableMap.of((Object)bulkWatchOperation.getNameKey(), (Object)bulkWatchOperation, (Object)bulkUnwatchOperation.getNameKey(), (Object)bulkUnwatchOperation);
    }

    public Collection<BulkOperation> getBulkOperations() {
        return this.getBulkOperationsMap().values();
    }

    public BulkOperation getOperation(String operationName) {
        return this.getBulkOperationsMap().get(operationName);
    }

    public boolean isValidOperation(String operationName) {
        return this.getBulkOperationsMap().containsKey(operationName);
    }

    public void addBulkOperation(String operationName, Class<? extends BulkOperation> componentClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding Bulk Operation " + operationName + " with class " + componentClass));
        }
        this.pluginProvidedBulkOperations.put(operationName, JiraUtils.loadComponent(componentClass));
    }

    protected Map<String, BulkOperation> getBulkOperationsMap() {
        MapBuilder results = MapBuilder.newBuilder();
        results.addAll(this.systemBulkOperations);
        if (this.jiraAuthenticationContext.isLoggedInUser() && this.watcherService.isWatchingEnabled()) {
            results.addAll(this.systemBulkWatchOperations);
        }
        results.addAll(this.pluginProvidedBulkOperations);
        return results.toListOrderedMap();
    }
}

