/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bean.export;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.dataimport.ExportService;
import com.atlassian.jira.bean.export.AutoExport;
import com.atlassian.jira.bean.export.FileExistsException;
import com.atlassian.jira.bean.export.FilenameGenerator;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Joiner;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class AutoExportImpl
implements AutoExport {
    private static final Logger log = Logger.getLogger(AutoExportImpl.class);
    private static final FilenameGenerator DATESTAMP_FILENAME_GENERATOR = new FilenameGenerator(){

        @Override
        public File generate(String basepath) throws IOException {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String dateExtension = simpleDateFormat.format(new Date());
            File file = new File(basepath + File.separator + "jira_autoexport_" + dateExtension + ".zip");
            return file;
        }
    };
    private String defaultDir;
    private FilenameGenerator filenameGenerator;

    public AutoExportImpl(String defaultDir) {
        this(defaultDir, DATESTAMP_FILENAME_GENERATOR);
    }

    AutoExportImpl(String defaultDir, FilenameGenerator filenameGenerator) {
        this.defaultDir = defaultDir;
        this.filenameGenerator = filenameGenerator;
        if (defaultDir == null) {
            throw new NullPointerException("defaultDir");
        }
        if (filenameGenerator == null) {
            throw new NullPointerException("filenameGenerator");
        }
    }

    private String getDefaultDir() {
        return this.defaultDir;
    }

    @Override
    public String exportData() throws IOException, FileExistsException, IllegalXMLCharactersException, AtlassianCoreException {
        JiraAuthenticationContext authenticationContext;
        String exportFilename = this.getExportFilePath();
        ExportService exportService = this.getExportService();
        ServiceOutcome<Void> outcome = exportService.export((authenticationContext = this.getJiraAuthContext()).getLoggedInUser(), exportFilename, TaskProgressSink.NULL_SINK);
        if (outcome.isValid()) {
            return exportFilename;
        }
        if (outcome.getErrorCollection().getReasons().contains(ErrorCollection.Reason.VALIDATION_FAILED)) {
            log.error((Object)"Invalid XML characters found in data. Cannot export data before upgrade.");
            throw new IllegalXMLCharactersException("Illegal XML characters found in data.\nCannot export data before upgrade.");
        }
        throw new AtlassianCoreException(Joiner.on((String)"\n").join((Iterable)outcome.getErrorCollection().getErrorMessages()));
    }

    protected JiraAuthenticationContext getJiraAuthContext() {
        return (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
    }

    protected ExportService getExportService() {
        return (ExportService)ComponentAccessor.getComponent(ExportService.class);
    }

    @Override
    public String getExportFilePath() throws FileNotFoundException, FileExistsException, IOException {
        JiraHome jiraHome = (JiraHome)ComponentAccessor.getComponent(JiraHome.class);
        String filename = jiraHome.getExportDirectory().getPath();
        if (!(this.isValidDirectory(filename) || this.isValidDirectory(filename = ComponentAccessor.getIndexPathManager().getIndexRootPath()) || this.isValidDirectory(filename = this.getDefaultDir()))) {
            throw new FileNotFoundException("Could not find suitable directory for export.");
        }
        File file = this.filenameGenerator.generate(filename);
        if (file.exists()) {
            throw new FileExistsException("File with file name '" + file.getAbsolutePath() + "' already exists.");
        }
        return file.getAbsolutePath();
    }

    protected boolean isValidDirectory(String filename) {
        if (!TextUtils.stringSet((String)filename)) {
            return false;
        }
        File file = new File(filename);
        return file.exists() && file.isDirectory() && file.canWrite();
    }
}

