/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class UserMatcherPredicate
implements Predicate<User> {
    private final String query;
    private final boolean canMatchAddresses;
    private final String emailQuery;

    public UserMatcherPredicate(String query, boolean canMatchAddresses) {
        this(query, "", canMatchAddresses);
    }

    public UserMatcherPredicate(String nameQuery, String emailQuery, boolean canMatchAddresses) {
        Assertions.notNull((String)"query", (Object)nameQuery);
        Assertions.notNull((String)"emailquery", (Object)emailQuery);
        this.query = nameQuery.toLowerCase();
        this.emailQuery = emailQuery == null ? null : emailQuery.toLowerCase();
        this.canMatchAddresses = canMatchAddresses;
    }

    public boolean apply(User user) {
        boolean separateEmailQuery = StringUtils.isNotBlank((String)this.emailQuery);
        boolean usernameMatched = false;
        String userPart = user.getName();
        if (StringUtils.isNotBlank((String)userPart) && userPart.toLowerCase().startsWith(this.query)) {
            if (separateEmailQuery && this.canMatchAddresses) {
                usernameMatched = true;
            } else {
                return true;
            }
        }
        if (this.canMatchAddresses) {
            userPart = user.getEmailAddress();
            if (StringUtils.isNotBlank((String)userPart) && userPart.toLowerCase().startsWith(separateEmailQuery ? this.emailQuery : this.query)) {
                if (!separateEmailQuery || usernameMatched) {
                    return true;
                }
            } else if (separateEmailQuery) {
                return false;
            }
        }
        if (StringUtils.isNotBlank((String)(userPart = user.getDisplayName()))) {
            String lowerCaseDisplayName = userPart.toLowerCase();
            if (lowerCaseDisplayName.startsWith(this.query)) {
                return true;
            }
            StringTokenizer tokenizer = new StringTokenizer(lowerCaseDisplayName);
            tokenizer.nextToken();
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().startsWith(this.query)) continue;
                return true;
            }
        }
        return false;
    }
}

